/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 *
 * This file is part of KLyX, the High Level Word Processor
 *
 * Copyright (C) 1997-1999 Matthias Ettrich and the KLyX Team
 */


#ifndef _KLYXMENU_H
#define _KLYXMENU_H

#include <qobject.h>

class LyXView;
class QWidget;
class KMenuBar;
class QPopupMenu;


class KLyXMenuReceiver : public QObject
{
  Q_OBJECT

public:
  KLyXMenuReceiver( LyXView* view );
  ~KLyXMenuReceiver();

  KMenuBar* getMenubar(){ return bar;};

  void showMenus();
  void hideMenus();

  // some simple context menus
  void createTableMenu(QPopupMenu*);
  void createEditMenu(QPopupMenu*);


public slots:
  void activated(int);
  void m_fileActivated(int);
  void m_exportActivated(int);
  void m_editActivated( int );
  void m_editFloatActivated( int );
  void m_editTableActivated( int );
  void m_vcActivated( int );
  void m_layoutActivated( int );
  void m_insertActivated( int );
  void m_insertASCIIActivated( int );
  void m_insertTableActivated( int );
  void m_insertFloatActivated( int );
  void m_insertSpecialActivated( int );
  void m_optionsActivated( int );
  void m_bufferActivated(int);

  void createMenu( int );
  void aboutToShowFile();
  void aboutToShowEdit();
  void aboutToShowLayout();
  void aboutToShowInsert();
  void aboutToShowOptions();
  void aboutToShowBuffer();

  void helpCredits();
  void helpIntroduction();
  void helpTutorial();
  void helpHowDoI();
  void helpUsersGuide();
  void helpAdvancedEditing();
  void helpCustomization();
  void helpReferenceManual();
  void helpKnownBugs();
  void helpLaTeXConfiguration();





private:
  void ScreenOptions();
  void credits();
  void menuDocu( const char* );

  enum {
  i_file = 100,
  i_export,
  i_edit,
  i_editfloat,
  i_edittable,
  i_vc,
  i_layout,
  i_insert,
  i_insertascii,
  i_insertfloat,
  i_inserttable,
  i_insertspecial,
  i_options,
  i_buffer,
  };

  LyXView* _view;
  KMenuBar* bar;
  QPopupMenu* m_file;
  QPopupMenu* m_preview;
  QPopupMenu* m_export;
  QPopupMenu* m_window;
  QPopupMenu* m_edit;
  QPopupMenu* m_editfloat;
  QPopupMenu* m_edittable;
  QPopupMenu* m_vc;
  QPopupMenu* m_layout;
  QPopupMenu* m_insert;
  QPopupMenu* m_insertascii;
  QPopupMenu* m_insertfloat;
  QPopupMenu* m_inserttable;
  QPopupMenu* m_insertspecial;
  QPopupMenu* m_options;
  QPopupMenu* m_buffer;
  bool hidden;
};






#endif
