/*
 * $Id: InsertTableDialog.C,v 1.4 1998/12/02 11:31:25 rocher Exp $
 */

#include "InsertTableDialog.h"

#include <qslider.h>
#include <kapp.h>
#include <klocale.h>

#include <qlabel.h>
#include <qlcdnum.h>
#include <qpushbt.h>
#include <qslider.h>
#include <qlayout.h>

InsertTableDialog::InsertTableDialog( QWidget * parent=0, 
									  const char * name=0, 
									  WFlags f=0 ) :
  QDialog( parent, name, true, f )
{
  // toplevel
  QVBoxLayout *vlayout = new QVBoxLayout(this, 5);
  // slider, label and number
  QGridLayout *grid = new QGridLayout(5, 3, 10);
  // buttons
  QHBoxLayout *hlayout = new QHBoxLayout();

  vlayout->addStretch(1);
  vlayout->addLayout(grid,3);
  vlayout->addLayout(hlayout,1);
  vlayout->addStretch(1);
  
  QLabel* rowsLA = new QLabel( i18n( "Rows:" ), this );
  rowsLA->adjustSize();
  rowsLA->setMinimumSize(rowsLA->size());

  grid->addWidget(rowsLA, 0, 0);
  rowsLA->setAlignment( AlignVCenter | AlignRight );

  rowsSL = new QSlider( 1, 50, 5, 5, QSlider::Horizontal, this );
  rowsSL->adjustSize();
  rowsSL->setFixedWidth(200); // Rocher 981202, added extra space,
                              // was rowsSL->setMinimumSize(rowsSL->size());
  grid->addWidget(rowsSL, 0, 1);
  
  rowsLC = new QLCDNumber( 2, this );
  rowsLC->adjustSize();
  rowsLC->setMinimumSize(rowsLC->size());
  grid->addWidget(rowsLC, 0, 2);
  rowsLC->display( 5 );
  QObject::connect( rowsSL, SIGNAL( valueChanged( int ) ), 
		    rowsLC, SLOT( display( int ) ) );

  QLabel* columnsLA = new QLabel( i18n( "Columns:" ), this );
  columnsLA->adjustSize();
  columnsLA->setMinimumSize(columnsLA->size());
  
  grid->addWidget(columnsLA, 1, 0);
  columnsLA->setAlignment( AlignVCenter | AlignRight );

  columnsSL = new QSlider( 1, 50, 5, 5, QSlider::Horizontal, this );
  columnsSL->adjustSize();
  columnsSL->setMinimumSize(columnsSL->size());
  grid->addWidget(columnsSL, 1, 1);
  
  columnsLC = new QLCDNumber( 2, this );
  columnsLC->adjustSize();
  columnsLC->setMinimumSize(columnsLC->size());
  grid->addWidget(columnsLC, 1, 2);
  columnsLC->display( 5 );
  QObject::connect( columnsSL, SIGNAL( valueChanged( int ) ), 
		    columnsLC, SLOT( display( int ) ) );

  hlayout->addStretch(1);
  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setMinimumSize(okPB->size());
  okPB->setMaximumHeight(okPB->height());
  hlayout->addWidget(okPB, 3);
  hlayout->addStretch(1);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( accept() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), this);
  cancelPB->adjustSize();
  cancelPB->setMinimumSize(cancelPB->size());
  cancelPB->setMaximumHeight(cancelPB->height());
  hlayout->addWidget(cancelPB, 3);
  hlayout->addStretch(1);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );
  grid->setColStretch(0, 1);
  grid->setColStretch(1, 5);
  grid->setColStretch(2, 1);
  vlayout->activate();

  // make it as small as necessary
  resize(10,10);
  setCaption( i18n( "Insert table" ) );
}


void InsertTableDialog::setData( InsertTableDialogData* data )
{
  rowsSL->setValue( data->rows );
  rowsLC->display( data->rows );
  columnsSL->setValue( data->columns );
  columnsLC->display( data->columns );
}


static InsertTableDialogData tempdata;

InsertTableDialogData* InsertTableDialog::data() const
{
  tempdata.rows = rowsSL->value();
  tempdata.columns = columnsSL->value();

  return &tempdata;
}


/*
 * $Log: InsertTableDialog.C,v $
 * Revision 1.4  1998/12/02 11:31:25  rocher
 * Added extra horizontal space in sliders.
 *
 * Revision 1.3  1998/03/02 22:12:40  kulow
 * the next one without hard coded coordinates
 *
 * Revision 1.2  1998/03/02 21:13:52  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1.1.1  1997/12/14 21:19:45  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/12/04 22:10:27  kalle
 * InsertTableDialog in Qt
 *
 */
