/*
 * $Id: InsertIndexEntryDialog.h,v 1.2 1998/03/02 21:13:45 kalle Exp $
 */

#ifndef _INSERTINDEXENTRYDIALOG_H
#define _INSERTINDEXENTRYDIALOG_H

#include <qdialog.h>
#include <qstring.h>

class QLabel;
class QLineEdit;
class QPushButton;
class InsetIndex;

class LyXView;

class InsertIndexEntryDialog : public QDialog
{
  Q_OBJECT

public:
  InsertIndexEntryDialog ( LyXView* view, QWidget * parent=0, 
						   const char * name=0, 
						   WFlags f=0 );

  QString getIndexEntry() const;
  void setIndexEntry( const char* );
  void setInsetIndex( InsetIndex* _inset ) { inset = _inset; }

signals:
  void ok();
  void cancel();

private slots:
  void okClicked();
  void cancelClicked();
  void clearClicked();

private:
  LyXView* _view;
  InsetIndex* inset;

  QLineEdit* editED;
};

#endif

/*
 * $Log: InsertIndexEntryDialog.h,v $
 * Revision 1.2  1998/03/02 21:13:45  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/05 22:53:59  kalle
 * - added InsertLabelDialog
 * - added InsertIndexEntryDialog
 * - added menu entry for inserting index entries to insert menu
 * 1375 XForms calls left!
 *
 */
