/*
 * $Id: InsertIndexEntryDialog.C,v 1.3 1999/01/05 11:16:31 kulow Exp $
 */

#include "InsertIndexEntryDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>

#include "insetindex.h"
#include "LString.h"
#include "LyXView.h"

extern void UpdateInset(Inset* inset, bool mark_dirty = true);

InsertIndexEntryDialog::InsertIndexEntryDialog( LyXView* view, 
												QWidget * parent=0, 
												const char * name=0, 
												WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QLabel* labelLA = new QLabel( i18n( "Enter index entry:" ),
								this );
  labelLA->setGeometry( 10, 10, 320, 30 );
  
  editED = new QLineEdit( this );
  editED->setGeometry( 10, 40, 320, 30 );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 90, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 120, 90, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  QPushButton* clearPB = new QPushButton( i18n( "Clear" ), 
										  this );
  clearPB->setGeometry( 230, 90, 100, 30 );
  connect( clearPB, SIGNAL( clicked() ), SLOT( clearClicked() ) );

  setCaption( i18n( "Insert Index Entry" ) );
}


void InsertIndexEntryDialog::okClicked()
{
  if(!_view->currentBuffer()->isReadonly()) {
	LString tmp = editED->text();
	if(tmp != inset->getContents())	{
	  inset->setContents(tmp);
	  UpdateInset(inset);
	}
  }
  
  accept();
}


void InsertIndexEntryDialog::cancelClicked()
{
  reject();
}


void InsertIndexEntryDialog::clearClicked()
{
  editED->setText( "" );
}


QString InsertIndexEntryDialog::getIndexEntry() const
{
  return editED->text();
}


void InsertIndexEntryDialog::setIndexEntry( const char* text )
{
  editED->setText( text );
}


/*
 * $Log: InsertIndexEntryDialog.C,v $
 * Revision 1.3  1999/01/05 11:16:31  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.2  1998/03/02 21:13:44  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/05 22:53:59  kalle
 * - added InsertLabelDialog
 * - added InsertIndexEntryDialog
 * - added menu entry for inserting index entries to insert menu
 * 1375 XForms calls left!
 *
 */
