/*
 * $Id: ExportCustomDialog.C,v 1.6 1999/01/05 11:16:28 kulow Exp $
 */

#include <qslider.h>

#include "ExportCustomDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlined.h>

#include "LyXView.h"
#include "filetools.h"
#include "pathstack.h"
#include "syscall.h"
#include "lyxrc.h"

extern BufferView* current_view;
extern LyXRC* lyxrc;
extern void ProhibitInput();
extern void AllowInput();
extern int MakeDVIOutput(Buffer *buffer);
extern bool MenuRunDvips(Buffer *buffer, bool wait);

ExportCustomDialog::ExportCustomDialog( LyXView* view, QWidget * parent=0,
									  const char * name=0,
									  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QButtonGroup* filetypeBG = new QButtonGroup( i18n( "Filetype" ),
											   this );
  filetypeBG->setGeometry( 10, 10, 300, 100 );

  lyxRB = new QRadioButton( i18n( "LyX" ), this );
  lyxRB->setGeometry( 20, 30, 100, 30 );
  filetypeBG->insert( lyxRB );
  lyxRB->setChecked( true );

  latexRB = new QRadioButton( i18n( "LaTeX" ), this );
  latexRB->setGeometry( 140, 30, 100, 30 );
  filetypeBG->insert( latexRB );

  dviRB = new QRadioButton( i18n( "DVI" ), this );
  dviRB->setGeometry( 250, 30, 50, 30 );
  filetypeBG->insert( dviRB );

  postscriptRB = new QRadioButton( i18n( "PostScript" ), this );
  postscriptRB->setGeometry( 60, 70, 90, 30 );
  filetypeBG->insert( postscriptRB );

  asciiRB = new QRadioButton( i18n( "ASCII" ), this );
  asciiRB->setGeometry( 190, 70, 60, 30 );
  filetypeBG->insert( asciiRB );

  QLabel* commandLA = new QLabel( i18n( "Command:" ), this );
  commandLA->setAlignment( AlignVCenter | AlignRight );
  commandLA->setGeometry( 20, 120, 70, 30 );

  commandED = new QLineEdit( this );
  commandED->setGeometry( 100, 120, 200, 30 );
	

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 40, 170, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ),
										   this );
  cancelPB->setGeometry( 180, 170, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), this, SLOT( reject() ) );

  setCaption( i18n( "Export custom type" ) );
}


void ExportCustomDialog::okClicked()
{
  if (!current_view->available())
	{
	  accept();
	  return;
	}

  LString command = commandED->text();
  if (command.empty())
	{
	  accept();
	  return;
	}

  ProhibitInput();
  // Generate dvi file and check if there are errors in the .lyx file
  Buffer *buffer = current_view->currentBuffer();
  if (MakeDVIOutput(buffer) > 0) {
	AllowInput();
	accept();
	return;
  }
  AllowInput();
  LString ftypeext;
  if( lyxRB->isChecked() )
	ftypeext = ".lyx";
  else if( latexRB->isChecked() )
	ftypeext = ".tex";
  else if( dviRB->isChecked() )
	ftypeext = ".dvi";
  else if( asciiRB->isChecked() )
	ftypeext = ".txt";
  else {
	ftypeext = ".ps_tmp";
	MenuRunDvips(buffer, true);
  }
  LString fname = ChangeExtension(buffer->getFileName(), ftypeext, true);
  if (!command.contains("$$FName"))
	command = "cat $$FName | " + command;
  command.subst("$$FName",fname);
  command += " &"; // execute in background
  // push directorypath, if necessary
  LString path = OnlyPath(buffer->getFileName());
  if (lyxrc->use_tempdir || (IsDirWriteable(path) < 1)){
	path = buffer->tmppath;
  }
  PathPush(path);
  // save the .lyx file in tmp_dir if this filetype is requested
  if( lyxRB->isChecked() )
	buffer->writeFile(fname,true);
  // create the .txt file in tmp_dir if this filetype is requested
  if( asciiRB->isChecked() )
	buffer->writeFileAscii(fname, lyxrc->ascii_linelen);
  Systemcalls one(Systemcalls::System, command);
  PathPop();

  accept();
}


void ExportCustomDialog::setData( ExportCustomDialogData* _data )
{
  switch( _data->filetype )
	{
	case ExportCustomDialogData::LyX:
	  lyxRB->setChecked( true );
	  break;
	case ExportCustomDialogData::LaTeX:
	  latexRB->setChecked( true );
	  break;
	case ExportCustomDialogData::DVI:
	  dviRB->setChecked( true );
	  break;
	case ExportCustomDialogData::PostScript:
	  postscriptRB->setChecked( true );
	  break;
	case ExportCustomDialogData::ASCII:
	  asciiRB->setChecked( true );
	  break;
	};

  commandED->setText( _data->command );
}


static ExportCustomDialogData tempdata;

ExportCustomDialogData* ExportCustomDialog::data() const
{
  if( lyxRB->isChecked() )
	tempdata.filetype = ExportCustomDialogData::LyX;
  else if( latexRB->isChecked() )
	tempdata.filetype = ExportCustomDialogData::LaTeX;
  else if( dviRB->isChecked() )
	tempdata.filetype = ExportCustomDialogData::DVI;
  else if( postscriptRB->isChecked() )
	tempdata.filetype = ExportCustomDialogData::PostScript;
  else if( asciiRB->isChecked() )
	tempdata.filetype = ExportCustomDialogData::ASCII;

  tempdata.command = commandED->text();

  return &tempdata;
}



/*
 * $Log: ExportCustomDialog.C,v $
 * Revision 1.6  1999/01/05 11:16:28  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.5  1998/09/04 16:07:40  ettrich
 * Matthias: bugfixes
 *
 * Revision 1.4  1998/08/05 11:04:11  kuepper
 * Added type specifiers to some variable declarations. Added return type
 * specifiers to several functions extern declarations.
 *
 * Revision 1.3  1998/03/15 07:11:10  kalle
 * More Qt-ified
 *
 * Revision 1.2  1998/03/03 22:36:20  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/01/14 22:26:41  kalle
 * ExportCustomDialog
 *
 */
