/*
 * $Id: CharacterStyleDialog.h,v 1.6 1998/03/17 01:19:30 ettrich Exp $
 */

#ifndef _CHARACTERSTYLEDIALOG_H
#define _CHARACTERSTYLEDIALOG_H

#include <qdialog.h>
#include <qstring.h>

#include "lyxdummies.h"

class QComboBox;
class LyXFont;


class CharacterStyleDialogData
{
 public:
  CharacterStyleDialogData(){};
  LyXFont font();

  enum Family { FamilyNoChange, Roman, SansSerif, Typewriter, FamilyReset };
  Family family;
  enum Series { SeriesNoChange, Medium, Bold, SeriesReset };
  Series series;
  enum Shape { ShapeNoChange, Upright, Italic, Slanted, SmallCaps, 
			   ShapeReset };
  Shape shape;
  enum Size { SizeNoChange, Tiny, Smallest, Smaller, Small, Normal, Large,
			  Larger, Largest, Huge, Huger, Increase, Decrease, SizeReset };
  Size size;
  enum Misc { MiscNoChange, Emph, Underbar, Noun, LaTeXMode, MiscReset };
  Misc misc;
  enum Color { ColorNoChange, NoColor, Black, White, Red, Green, Blue, Cyan, 
			   Magenta, Yellow, ColorReset };
  Color color;
};


class CharacterStyleDialog : public QDialog
{
  Q_OBJECT

public:
  CharacterStyleDialog ( QWidget * parent=0, const char * name=0, 
						 WFlags f=0 ) ;

  void setData( CharacterStyleDialogData* data );
  CharacterStyleDialogData* data() const;

private slots:
	void okClicked();
	void applyClicked();

private:

  QComboBox* familyCO;
  QComboBox* seriesCO;
  QComboBox* shapeCO;
  QComboBox* sizeCO;
  QComboBox* miscCO;
  QComboBox* colorCO;
};

#endif

/*
 * $Log: CharacterStyleDialog.h,v $
 * Revision 1.6  1998/03/17 01:19:30  ettrich
 * Matthias: - resize handling better (important for dynamic toolbars)
 *           - a couple of bugfixes, hopefully some critical, too
 *           - fixes for F(x) on mathtoolbar
 *           - this and that....
 *
 * Revision 1.5  1998/03/15 07:11:09  kalle
 * More Qt-ified
 *
 * Revision 1.4  1998/03/03 15:58:15  ettrich
 * Matthias: - fixed the zoom-zero bug.
 *           - CharacterStyle dialog should have a working apply-button now
 *           - default background color is "white" now (was bisque)
 *
 * Revision 1.3  1998/01/28 23:25:27  ettrich
 * Matthias: introduce charToolbar
 *
 * Revision 1.2  1997/12/26 22:39:52  kalle
 * Kalle:
 * - Changed ScreenOptions dialog to KDE/Qt version
 * - Changed SpellcheckerOptions dialog to KDE/Qt version
 * - Removed old toolbar
 *
 * Revision 1.1.1.1  1997/12/14 21:19:33  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:13  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.1  1997/11/16 22:07:28  kalle
 * added CharacterStyleDialog
 *
 *
 */
