/*
 * $Id: CharacterStyleDialog.C,v 1.13 1999/01/05 11:16:25 kulow Exp $
 */

#include "CharacterStyleDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qcombo.h>
#include <qlabel.h>
#include <qpushbt.h>

#include "lyxfont.h"

extern void ToggleAndShow(LyXFont const &);

LyXFont CharacterStyleDialogData::font()
{
	LyXFont font(LyXFont::ALL_IGNORE);
	//int pos;

	switch(family) {
	case FamilyNoChange: 
	  font.setFamily(LyXFont::IGNORE_FAMILY); 
	  break;
	case Roman: 
	  font.setFamily(LyXFont::ROMAN_FAMILY); 
	  break;
	case SansSerif: 
	  font.setFamily(LyXFont::SANS_FAMILY); 
	  break;
	case Typewriter: 
	  font.setFamily(LyXFont::TYPEWRITER_FAMILY); 
	  break;
	case FamilyReset: 
	  font.setFamily(LyXFont::INHERIT_FAMILY); 
	  break;
	}

	switch(series) {
	case SeriesNoChange: 
	  font.setSeries(LyXFont::IGNORE_SERIES); 
	  break;
	case Medium: 
	  font.setSeries(LyXFont::MEDIUM_SERIES); 
	  break;
	case Bold: 
	  font.setSeries(LyXFont::BOLD_SERIES); 
	  break;
	case SeriesReset: 
	  font.setSeries(LyXFont::INHERIT_SERIES); 
	  break;
	}

	switch(shape) {
	case ShapeNoChange: 
	  font.setShape(LyXFont::IGNORE_SHAPE); 
	  break;
	case Upright: 
	  font.setShape(LyXFont::UP_SHAPE); 
	  break;
	case Italic: 
	  font.setShape(LyXFont::ITALIC_SHAPE); 
	  break;
	case Slanted: 
	  font.setShape(LyXFont::SLANTED_SHAPE); 
	  break;
	case SmallCaps: 
	  font.setShape(LyXFont::SMALLCAPS_SHAPE); 
	  break;
	case ShapeReset: 
	  font.setShape(LyXFont::INHERIT_SHAPE); 
	  break;
	}

	switch(size) {
	case SizeNoChange: 
	  font.setSize(LyXFont::IGNORE_SIZE); 
	  break;
	case Tiny: 
	  font.setSize(LyXFont::SIZE_TINY); 
	  break;
	case Smallest: 
	  font.setSize(LyXFont::SIZE_SCRIPT); 
	  break;
	case Smaller: 
	  font.setSize(LyXFont::SIZE_FOOTNOTE); 
	  break;
	case Small: 
	  font.setSize(LyXFont::SIZE_SMALL); 
	  break;
	case Normal: 
	  font.setSize(LyXFont::SIZE_NORMAL); 
	  break;
	case Large: 
	  font.setSize(LyXFont::SIZE_LARGE); 
	  break;
	case Larger: 
	  font.setSize(LyXFont::SIZE_LARGER); 
	  break;
	case Largest: 
	  font.setSize(LyXFont::SIZE_LARGEST); 
	  break;
	case Huge: 
	  font.setSize(LyXFont::SIZE_HUGE); 
	  break;
	case Huger: 
	  font.setSize(LyXFont::SIZE_HUGER); 
	  break;
	case Increase: 
	  font.setSize(LyXFont::INCREASE_SIZE); 
	  break;
	case Decrease: 
	  font.setSize(LyXFont::DECREASE_SIZE); 
	  break;
	case SizeReset: 
	  font.setSize(LyXFont::INHERIT_SIZE); 
	  break;
	}

	switch(misc) {
	case MiscNoChange: 
	  font.setEmph(LyXFont::IGNORE);
	  font.setUnderbar(LyXFont::IGNORE);
	  font.setNoun(LyXFont::IGNORE);
	  font.setLatex(LyXFont::IGNORE);
	  break;
	case Emph: 
	  font.setEmph(LyXFont::ON); 
	  break;
	case Underbar: 
	  font.setUnderbar(LyXFont::ON); 
	  break;
	case Noun: 
	  font.setNoun(LyXFont::ON); 
	  break;
	case LaTeXMode: 
	  font.setLatex(LyXFont::ON); 
	  break;
	case MiscReset: 
	  font.setEmph(LyXFont::INHERIT);
	  font.setUnderbar(LyXFont::INHERIT);
	  font.setNoun(LyXFont::INHERIT);
	  font.setLatex(LyXFont::INHERIT);
	  break;
	}

	switch(color) {
	case ColorNoChange: 
	  font.setColor(LyXFont::IGNORE_COLOR); 
	  break;
	case NoColor: 
	  font.setColor(LyXFont::NONE); 
	  break;
	case Black: 
	  font.setColor(LyXFont::BLACK); 
	  break;
	case White: 
	  font.setColor(LyXFont::WHITE); 
	  break;
	case Red: 
	  font.setColor(LyXFont::RED); 
	  break;
	case Green: 
	  font.setColor(LyXFont::GREEN); 
	  break;
	case Blue: 
	  font.setColor(LyXFont::BLUE); 
	  break;
	case Cyan: 
	  font.setColor(LyXFont::CYAN); 
	  break;
	case Magenta: 
	  font.setColor(LyXFont::MAGENTA); 
	  break;
	case Yellow: 
	  font.setColor(LyXFont::YELLOW); 
	  break;
	case ColorReset: 
	  font.setColor(LyXFont::INHERIT_COLOR); 
	  break;
	}

	return font; 
}

CharacterStyleDialog::CharacterStyleDialog( QWidget * parent=0, 
											const char * name=0, 
											WFlags f=0 ) :
  QDialog( parent, name, false, f )
{
  QLabel* familyLA = new QLabel( i18n( "Family" ), this );
  familyLA->setGeometry( 10, 10, 60, 30 );
  familyLA->setAlignment( AlignRight );

  familyCO = new QComboBox( false, this );
  familyCO->setGeometry( 80, 10, 150, 30 );
  familyCO->insertItem( i18n( "Keep" ), 
						CharacterStyleDialogData::FamilyNoChange );
  familyCO->insertItem( i18n( "Roman" ),
						CharacterStyleDialogData::Roman );
  familyCO->insertItem( i18n( "SansSerif" ),
						CharacterStyleDialogData::SansSerif );
  familyCO->insertItem( i18n( "Typewriter" ),
						CharacterStyleDialogData::Typewriter );
  familyCO->insertItem( i18n( "Reset" ), 
						CharacterStyleDialogData::FamilyReset );
  familyCO->setSizeLimit(familyCO->count());	// Rocher 981201


  QLabel* seriesLA = new QLabel( i18n( "Series" ), this );
  seriesLA->setGeometry( 10, 50, 60, 30 );
  seriesLA->setAlignment( AlignRight );

  seriesCO = new QComboBox( false, this );
  seriesCO->setGeometry( 80, 50, 150, 30 );
  seriesCO->insertItem( i18n( "Keep" ), 
						CharacterStyleDialogData::SeriesNoChange );
  seriesCO->insertItem( i18n( "Medium" ), 
						CharacterStyleDialogData::Medium );
  seriesCO->insertItem( i18n( "Bold" ), 
						CharacterStyleDialogData::Bold );
  seriesCO->insertItem( i18n( "Reset" ), 
						CharacterStyleDialogData::SeriesReset );
  seriesCO->setSizeLimit(seriesCO->count());	// Rocher 981201


  QLabel* shapeLA = new QLabel( i18n( "Shape" ), this );
  shapeLA->setGeometry( 10, 90, 60, 30 );
  shapeLA->setAlignment( AlignRight );

  shapeCO = new QComboBox( false, this );
  shapeCO->setGeometry( 80, 90, 150, 30 );
  shapeCO->insertItem( i18n( "Keep" ), 
					   CharacterStyleDialogData::ShapeNoChange );
  shapeCO->insertItem( i18n( "Upright" ), 
					   CharacterStyleDialogData::Upright );
  shapeCO->insertItem( i18n( "Italic" ), 
					   CharacterStyleDialogData::Italic );
  shapeCO->insertItem( i18n( "Slanted" ), 
					   CharacterStyleDialogData::Slanted );
  shapeCO->insertItem( i18n( "Small Caps" ), 
					   CharacterStyleDialogData::SmallCaps );
  shapeCO->insertItem( i18n( "Reset" ), 
					   CharacterStyleDialogData::ShapeReset );
  shapeCO->setSizeLimit(shapeCO->count());	// Rocher 981201


  QLabel* sizeLA = new QLabel( i18n( "Size" ), this );
  sizeLA->setGeometry( 10, 130, 60, 30 );
  sizeLA->setAlignment( AlignRight );

  sizeCO = new QComboBox( false, this );
  sizeCO->setGeometry( 80, 130, 150, 30 );
  sizeCO->insertItem( i18n( "Keep" ), 
					  CharacterStyleDialogData::SizeNoChange );
  sizeCO->insertItem( i18n( "Tiny" ), 
					  CharacterStyleDialogData::Tiny );
  sizeCO->insertItem( i18n( "Smallest" ), 
					  CharacterStyleDialogData::Smallest );
  sizeCO->insertItem( i18n( "Smaller" ), 
					  CharacterStyleDialogData::Smaller );
  sizeCO->insertItem( i18n( "Small" ), 
					  CharacterStyleDialogData::Small );
  sizeCO->insertItem( i18n( "Normal" ), 
					  CharacterStyleDialogData::Normal );
  sizeCO->insertItem( i18n( "Large" ), 
					  CharacterStyleDialogData::Large );
  sizeCO->insertItem( i18n( "Larger" ), 
					  CharacterStyleDialogData::Larger );
  sizeCO->insertItem( i18n( "Largest" ), 
					  CharacterStyleDialogData::Largest );
  sizeCO->insertItem( i18n( "Huge" ), 
					  CharacterStyleDialogData::Huge );
  sizeCO->insertItem( i18n( "Huger" ), 
					  CharacterStyleDialogData::Huger );
  sizeCO->insertItem( i18n( "Increase" ), 
					  CharacterStyleDialogData::Increase );
  sizeCO->insertItem( i18n( "Decrease" ), 
					  CharacterStyleDialogData::Decrease );
  sizeCO->insertItem( i18n( "Reset" ), 
					  CharacterStyleDialogData::SizeReset );
  sizeCO->setSizeLimit(sizeCO->count());	// Rocher 981201


  QLabel* miscLA = new QLabel( i18n( "Misc" ), this );
  miscLA->setGeometry( 10, 170, 60, 30 );
  miscLA->setAlignment( AlignRight );

  miscCO = new QComboBox( false, this );
  miscCO->setGeometry( 80, 170, 150, 30 );
  miscCO->insertItem( i18n( "Keep" ), 
					  CharacterStyleDialogData::MiscNoChange );
  miscCO->insertItem( i18n( "Emph" ), 
					  CharacterStyleDialogData::Emph );
  miscCO->insertItem( i18n( "Underbar" ), 
					  CharacterStyleDialogData::Underbar );
  miscCO->insertItem( i18n( "Noun" ), 
					  CharacterStyleDialogData::Noun );
  miscCO->insertItem( i18n( "LaTeX" ), 
					  CharacterStyleDialogData::LaTeXMode );
  miscCO->insertItem( i18n( "Reset" ), 
					  CharacterStyleDialogData::MiscReset );
  miscCO->setSizeLimit(miscCO->count());	// Rocher 981201


  QLabel* colorLA = new QLabel( i18n( "Color" ), this );
  colorLA->setGeometry( 10, 210, 60, 30 );
  colorLA->setAlignment( AlignRight );

  colorCO = new QComboBox( false, this );
  colorCO->setGeometry( 80, 210, 150, 30 );
  colorCO->insertItem( i18n( "Keep" ), 
					   CharacterStyleDialogData::ColorNoChange );
  colorCO->insertItem( i18n( "None" ), 
					   CharacterStyleDialogData::NoColor );
  colorCO->insertItem( i18n( "Black" ), 
					   CharacterStyleDialogData::Black );
  colorCO->insertItem( i18n( "White" ), 
					   CharacterStyleDialogData::White );
  colorCO->insertItem( i18n( "Red" ), 
					   CharacterStyleDialogData::Red );
  colorCO->insertItem( i18n( "Green" ), 
					   CharacterStyleDialogData::Green );
  colorCO->insertItem( i18n( "Blue" ), 
					   CharacterStyleDialogData::Blue );
  colorCO->insertItem( i18n( "Cyan" ), 
					   CharacterStyleDialogData::Cyan );
  colorCO->insertItem( i18n( "Magenta" ), 
					   CharacterStyleDialogData::Magenta );
  colorCO->insertItem( i18n( "Yellow" ), 
					   CharacterStyleDialogData::Yellow );
  colorCO->insertItem( i18n( "Reset" ), 
					   CharacterStyleDialogData::ColorReset );
  colorCO->setSizeLimit(colorCO->count());	// Rocher 981201


  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 270, 80, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ),
		   this, SLOT( okClicked() ) );

  QPushButton* applyPB = new QPushButton( i18n( "Apply" ), 
										  this );
  applyPB->setGeometry( 100, 270, 80, 30 );
  connect( applyPB, SIGNAL( clicked() ),
		   this, SLOT( applyClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 190, 270, 80, 30 );
  connect( cancelPB, SIGNAL( clicked() ),
		   this, SLOT( hide() ) );

  setCaption( i18n( "Character Style" ) );
}


void CharacterStyleDialog::okClicked()
{
  ToggleAndShow( data()->font() );
  hide();
}	


void CharacterStyleDialog::applyClicked()
{
	ToggleAndShow( data()->font() );
}


void CharacterStyleDialog::setData( CharacterStyleDialogData* data )
{
  familyCO->setCurrentItem( data->family );
  seriesCO->setCurrentItem( data->series );
  shapeCO->setCurrentItem( data->shape );
  sizeCO->setCurrentItem( data->size );
  miscCO->setCurrentItem( data->misc );
  colorCO->setCurrentItem( data->color );
}


static CharacterStyleDialogData tempdata;

CharacterStyleDialogData* CharacterStyleDialog::data() const
{
  tempdata.family = (CharacterStyleDialogData::Family)familyCO->currentItem();
  tempdata.series = (CharacterStyleDialogData::Series)seriesCO->currentItem();
  tempdata.shape = (CharacterStyleDialogData::Shape)shapeCO->currentItem();
  tempdata.size = (CharacterStyleDialogData::Size)sizeCO->currentItem();
  tempdata.misc = (CharacterStyleDialogData::Misc)miscCO->currentItem();
  tempdata.color = (CharacterStyleDialogData::Color)colorCO->currentItem();

  return &tempdata;
}



/*
 * $Log: CharacterStyleDialog.C,v $
 * Revision 1.13  1999/01/05 11:16:25  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.12  1998/12/01 13:57:54  rocher
 * *** empty log message ***
 *
 * Revision 1.11  1998/12/01 12:28:11  rocher
 * *** empty log message ***
 *
 * Revision 1.10  1998/06/09 13:08:11  schreter
 *
 *
 * Added support for autodetection of charset, document encoding and
 * document language. tex_babel was changed to contain locale codes for
 * languages for autodetection of language from locale. Somebody please
 * revise it, so that it contains proper locale codes for all languages.
 *
 * Revision 1.9  1998/05/17 15:57:56  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.8  1998/03/17 01:19:28  ettrich
 * Matthias: - resize handling better (important for dynamic toolbars)
 *           - a couple of bugfixes, hopefully some critical, too
 *           - fixes for F(x) on mathtoolbar
 *           - this and that....
 *
 * Revision 1.7  1998/03/15 07:11:07  kalle
 * More Qt-ified
 *
 * Revision 1.6  1998/03/03 15:58:13  ettrich
 * Matthias: - fixed the zoom-zero bug.
 *           - CharacterStyle dialog should have a working apply-button now
 *           - default background color is "white" now (was bisque)
 *
 * Revision 1.5  1998/01/30 00:39:03  ettrich
 * Matthias:
 *      second iteration of the character toolbar / cleanups and bugfixes
 *
 * Revision 1.4  1998/01/28 23:25:26  ettrich
 * Matthias: introduce charToolbar
 *
 * Revision 1.3  1998/01/13 22:10:29  kalle
 * Fax sending, phonebook and logfile
 * (not really functional yet)
 *
 * Revision 1.2  1997/12/26 22:39:51  kalle
 * Kalle:
 * - Changed ScreenOptions dialog to KDE/Qt version
 * - Changed SpellcheckerOptions dialog to KDE/Qt version
 * - Removed old toolbar
 *
 * Revision 1.1.1.1  1997/12/14 21:19:33  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:13  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.2  1997/11/16 22:08:33  kalle
 * Caption for CharacterStyleDialog
 *
 * Revision 1.1  1997/11/16 22:07:28  kalle
 * added CharacterStyleDialog
 *
 *
 */
