/***************************************************************************
                          kashdoc.cpp  -  description
                             -------------------
    begin                : Son Nov 21 15:23:42 CET 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "resource.h"
#include "kashdoc.h"
#include "kash.h"
#include "kashview.h"
#include "kashaccount.h"

QList<KashView> *KashDoc::pViewList = 0L;

KashDoc::KashDoc( QWidget* parent, const char* name) : 
  QObject( parent, name ) {
  if( !pViewList ) {
    pViewList = new QList< KashView >();
  }

  pViewList->setAutoDelete( true );

  account = 0L;
}

KashDoc::~KashDoc() {
}

void KashDoc::addView( KashView* view ) {
  if ( !view ) {
    return;
  }
  pViewList->append( view );

  connect( this, SIGNAL( sigDelModel() ),
	   view, SLOT( slotNewModel() ) );
}

void KashDoc::removeView( KashView* view ) {
  pViewList->remove( view );
}

void KashDoc::setModified( bool _m ) { 
  KashApp* win = ( KashApp* )parent();
  if ( _m ) {
    win->enableCommand( ID_FILE_SAVE );
    win->enableCommand( ID_FILE_SAVE_AS );
  }
  else {
    win->disableCommand( ID_FILE_SAVE );
    win->disableCommand( ID_FILE_SAVE_AS );
  }
  modified=_m; 
}

void KashDoc::setAbsFilePath( const QString& filename ) {
  absFilePath=filename;
}

const QString &KashDoc::getAbsFilePath() const {
  return absFilePath;
}

void KashDoc::setTitle( const QString &_t ) {
  title = _t;
}

const QString &KashDoc::getTitle() const {
  return title;
}

void KashDoc::slotUpdateAllViews( KashView* sender ) {
  KashView *w;
  if( pViewList ) {
    for( w = pViewList->first(); w != 0; w = pViewList->next() ) {
      if( w != sender ) {
        w->repaint();
      }
    }
  }
}

bool KashDoc::saveModified() {
  bool completed = true;

  if ( modified ) {
    KashApp *win = ( KashApp* )parent();
    int want_save = 
      KMessageBox::warningYesNoCancel( win, 
				       i18n( "The current file has been modified.\n"
					     "Do you want to save it?"),
				       i18n( "Warning" ) );
    switch( want_save ) {
    case KMessageBox::Yes:
      if ( title == i18n( UNTITLED_STRING ) ) {
	win->slotFileSaveAs();
      }
      else {
	saveDocument( getAbsFilePath() );
      };

      deleteContents();
      completed=true;
      break;
      
    case KMessageBox::No:
      setModified( false );
      deleteContents();
      completed = true;
      break;	

    case KMessageBox::Cancel:
      completed = false;
      break;

    default:
      completed=false;
      break;
    }
  }
  
  return completed;
}

void KashDoc::closeDocument() {
  deleteContents();
}

bool KashDoc::newDocument() {
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////

  deleteContents();

  addAccount( "My First Bank", "Bank" );
  
  absFilePath=QDir::homeDirPath();
  title=i18n( UNTITLED_STRING );

  return true;
}

bool KashDoc::openDocument( const QString &filename, 
			    const char* /* format =0*/) {

  deleteContents();
  addAccount( "My First Bank", "Bank" );

  QFileInfo fileInfo( filename );
  title = fileInfo.fileName();
  absFilePath = fileInfo.absFilePath();	
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  QFile f( filename );
  if ( ! f.open( IO_ReadOnly ) ) {
    return false;
  }
  QTextStream s( &f );
  s >> *account;
  f.close();

  setModified( false );
  return true;
}

bool KashDoc::saveDocument( const QString &filename, 
			    const char* /* format = 0*/ ) {
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////
  QFile f( filename );
  if ( ! f.open( IO_WriteOnly ) ) {
    return false;
  }
  QTextStream s( &f );
  s << *account;
  f.close();

  setModified( false );
  return true;
}

void KashDoc::deleteContents() {
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////
  if ( account ) {
    delete account;
    account = 0L;
  }
  setModified( false );
  emit sigDelModel();
}

/** adds an account to the account list */
void KashDoc::addAccount( const char* aName, const char* aType, 
			  const char* aNo, const char* aDescr ) {
  account = new KashAccount( aName, aType, aNo, aDescr ); 
  CHECK_PTR( account );

  KashView *w;
  if( pViewList ) {
    for( w = pViewList->first(); w != 0; w = pViewList->next() ) {
      connect( account, SIGNAL( sigNewTransaction( long, StringVector& ) ),
	       w, SLOT( slotListTransaction( long, StringVector& ) ) );
    }
  }
}

void KashDoc::removeAccount( KashAccount* ) {
}

KashAccount* KashDoc::getActAccount() const {
  return account;
}

long KashDoc::addTransaction( StringVector& dataVec ) {
  long retVal = 0;
  if ( ( retVal = account->addTransaction( dataVec ) ) ) {
    setModified();
  }
  return retVal;
}

bool KashDoc::updateTransaction( long transId, StringVector& dataVec ) {
  setModified();
  return account->updateTransaction( transId, dataVec );
}

bool KashDoc::deleteTransaction( long transId ) {
  setModified();
  return account->deleteTransaction( transId );
}












