/* -*- C++ -*-
 * This file declares the main widget for kab II.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#ifndef KAB2_H_INCLUDED
#define KAB2_H_INCLUDED

#include <ktmainwindow.h>

class AddressBook; // kab 2 main class -> libkab(2)
class KDataNavigator;
class QTimer;

/** This class creates kab's main window. */

class KabMainWindow : public KTMainWindow
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  /** The indices of the statusbar parts. */
  enum StatusbarIndex { Text=1, /**< The status text. */
			Number /**< The number of entries. */
  };
  KabMainWindow(const char* name=0); /**< Qt's standard constructor. */
  ~KabMainWindow(); /**< Virtual destructor. */
  // ----------------------------------------------------------------------------
protected:
  // ----- methods:
  void createMenuBar(); /**< Creates the menubar. */
  void createStatusBar(); /**< Creates the statusbar. */
  void createToolBar(); /**< Creates the toolbar. */
  void createConnections(); /**< Creates all static connections centrally. */
  // ----- members:
  AddressBook *kab;  /**< Our main view. */
  KDataNavigator *nav; /**< The navigator in the navigation toolbar. */
  QTimer *timer; /**< Used to reset the status bar. */
  QPopupMenu *edit; /**< The pointer to the \e edit menu. */
  QPopupMenu *file; /**< The pointer to the \e file menu. */
  QPopupMenu *view; /**< The pointer to the \e view menu. */
  int newFileItemID; /**< The ID of the \e new file item. */
  int openItemID; /**< The ID of the \e open \e file item. */
  int saveItemID; /**< The ID of the \e save menu item.*/
  int exportItemID; /**< The ID of the \e export menu item.*/
  int searchItemID; /**< The ID of the \e search \e entries menu item.*/
  int printItemID; /**< The ID of the \e print menu item.*/
  int copyItemID; /**< The ID of the \e copy menu item. */
  int editItemID; /**< The ID of the \e edit menu item. */
  int removeItemID; /**< The ID of the \e remove menu item. */
  int importVCardID; /**< The ID of the \e import \e VCard menu item. */
  int mailItemID; /**< The ID of the \e mail \e VCard menu item. */
  int talkItemID; /**< The ID of the \e talk \e VCard menu item. */
  int browseItemID; /**< The ID of the \e browse \e VCard menu item. */
  // ----------------------------------------------------------------------------
public slots:
  // ----- file management:
  void updateGUI(); /**< The database has changed. */
  // -----
  void entrySelected(int); /**< An entry has been selected in the navigator. */
  // ----- next both used to set and erase statusbar:
  void setStatus(const char*); /**< Set the status bar text. */
  void timeOut(); /**< Erase it after some time. */
  // ----- slots for reacting on menu events:
  void aboutQt(); /**< Show the \e About \e Qt messagebox. */
  void about(); /**< Show kab's about dialog. */
  void browse(); /**< Used to call kfm for browsing. */
  void browse(const char* a); /**< Call kfm. \e a is ignored. */
  void exportHTML(); /**< Grab a file name and export to HTML. */
  void newFile(); /**< Create a new kab database file. */
  void open(); /**< Open an existing kab database file. */
  void save(); /**< Save the file. */
  void search(); /**< Search the entries for patterns. */
  void print(); /**< Print the file. */
  void copy(); /**< Copy the contents to the clipboard. */
  void add(); /**< Add an entry. */
  void editEntry(); /**< Edit this entry. */
  void remove(); /**< Remove this entry. */
  void importVCard(); /**< Import a vCard and create a new entry. */
  void mail(); /**< Send an email. */
  void mail(const char* a); /**< Send an email. \e a is ignored. */
  void talk(); /**< Open a talk connection. */
  // ----- session management:
  void saveOurselfes(); /**< Called by saveYourself signal. */
  // ----- enables or disables menu items:
  void enableWidgets(int noOfEntries);
  // ############################################################################
};

#endif // KAB2_H_INCLUDED
