/***************************************************************************
 newkrnview.cpp  -  description                              
 -------------------                                         
 begin                : Tue Jun  8 12:09:50 /etc/localtime 1999
 
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <newkrnview.h>

#include <qlistview.h>
#include <qpopupmenu.h>
#include <kfm.h>
#include <ktabctl.h>

#include "resource.h"
#include "util.h"
#include "serversroot.h"
#include "connmgrwidget.h"
#include "connmgr.h"
#include "groupreader.h"
#include "basegroup.h"
#include "group.h"
#include "newkrn.h"
#include "kmail/kmreaderwin.h"

NewKrnView::NewKrnView(KApplication*,NewKrnDoc* _doc,QWidget *parent)
        : QSplitter(QSplitter::Vertical,parent)
{
    horiz=new QSplitter(this);
    horiz->setOpaqueResize(true);
    doc=_doc;
    groupTree=new QListView(horiz);

    readers=new KTabCtl (horiz);
    //		readers->setFixedWidth(0);

    groupTree->setRootIsDecorated(true);
    groupTree->addColumn ("Group");
    groupTree->addColumn ("Unread",fontMetrics().width("9999999"));
    groupTree->addColumn ("Local",fontMetrics().width("9999999"));
    groupTree->setAllColumnsShowFocus(true);

    sr=new ServersRoot(groupTree);
    sr->setOpen(true);

    lfroot=new LocalFolder(groupTree,KApplication::localkdedir()+"/share/apps/newkrn/Folders");

    QObject::connect (groupTree,SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
                      this,SLOT(rightClick(QListViewItem *)));

    QObject::connect (groupTree,SIGNAL(doubleClicked(QListViewItem *)),
                      this,SLOT(openGroup(QListViewItem *)));
    QObject::connect (groupTree,SIGNAL(returnPressed(QListViewItem *)),
                      this,SLOT(openGroup(QListViewItem *)));


    connections =new ConnMgrWidget(this);
    QObject::connect (connections,SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
                      this,SLOT(rightClick(QListViewItem *)));

}

NewKrnView::~NewKrnView()
{
}

void NewKrnView::openGroup(QListViewItem *_item)
{
    QObjectLVI *item=(QObjectLVI *)_item;
    if (item->isBusy())
        return;
    if (item->isA("ServerGroup"))
    {
        Group *g=(Group *)(((ServerGroup *)item)->groupObject());
        GroupReader *greader=new GroupReader(readers,doc);
        QObject::connect (greader->body, SIGNAL(statusMsg(const char*)),(NewKrnApp *)parent(),
        SLOT(slotStatusMsg(const char *)));
        readers->addTab(greader,g->name);
        readers->setMinimumWidth(.75*horiz->width());
        qApp->processEvents();
        readers->setMinimumWidth(0);
        doc->openGroup(g,item,greader);
    }
}
void NewKrnView::rightClick(QListViewItem *_item)
{
    groupTree->setSelected(_item,true);
    QObjectLVI *item=(QObjectLVI *)_item;
    debug (item->className());
    if (item->isA("ServersRoot"))
    {
        qApp->processEvents();
        QPopupMenu *popup=item->contextMenu();
        if (popup)
        {
            int command=popup->exec(QCursor::pos());
            delete popup;
            if (command==-1) //no selection
                return;

            switch (command)
            {
            case ID_NEW_SERVER:
                {
                    doc->newServer();
                    bool b=sr->isOpen();
                    sr->setOpen(false);
                    sr->setOpen(b);
                    break;
                }
            default:
                {
                    notImplemented();
                    break;
                }
            }
        }
    }
    else if (item->isA("ServerItem"))
    {
        QPopupMenu *popup=item->contextMenu();
        if (popup)
        {
            int command=popup->exec(QCursor::pos());
            delete popup;
            if (command==-1) //no selection
                return;
            switch (command)
            {
            case ID_GET_ACTIVE:
                {
                    doc->getActive(item->text(0), item);
                    bool b=item->isOpen();
                    item->setOpen(false);
                    item->setOpen(b);
                    break;
                }
            case ID_SERVER_OPEN:
                {
                    item->setOpen(true);
                    break;
                }
            case ID_SERVER_CLOSE:
                {
                    item->setOpen(false);
                    break;
                }
            case ID_SERVER_PROPERTIES:
                {
                    doc->serverProperties(item->text(0));;
                    break;
                }
            default:
                {
                    notImplemented();
                    break;
                }
            }
        }
    }
    else if (item->isA("ServerBranch"))
    {
        QPopupMenu *popup=item->contextMenu();
        if (popup)
        {
            int command=popup->exec(QCursor::pos());
            delete popup;
            if (command==-1) //no selection
                return;
            switch (command)
            {
            case ID_SERVER_OPEN:
                {
                    item->setOpen(true);
                    break;
                }
            case ID_SERVER_CLOSE:
                {
                    item->setOpen(false);
                    break;
                }
            case ID_GET_FAQ:
                {
                    QString name=item->text(0);
                    QString first=name.left(name.find('.'));
                    KFM *kfm=new KFM;
                    kfm->openURL("http://www.faqs.org/faqs/by-newsgroup/"+first);
                    delete kfm;
                    break;
                }
            default:
                {
                    notImplemented();
                    break;
                }
            }
        }
    }
    else if (item->isA("ServerGroup"))
    {
        QPopupMenu *popup=item->contextMenu();
        if (popup)
        {
            int command=popup->exec(QCursor::pos());
            delete popup;
            if (command==-1) //no selection
                return;
            switch (command)
            {
            case ID_GET_HEADERS:
                {
                    BaseGroup *g=((ServerGroup *)item)->groupObject();
                    doc->updateGroup(g,item);
                    break;
                }
            case ID_GROUP_OPEN:
                {
                    openGroup(item);
                    break;
                }
            case ID_GET_FAQ:
                {
                    QString name=item->text(0);
                    QString first=name.left(name.find('.'));
                    KFM *kfm=new KFM;
                    kfm->openURL("http://www.faqs.org/faqs/by-newsgroup/"+first+"/"+name+".html");
                    delete kfm;
                    break;
                }
            case ID_GROUP_SUBSCRIBE:
                {
                    //subscribe
                    doc->subscribeGroup(((ServerGroup *)item)->name);
                    //FIXME go reopen the subscribed branch
                    break;
                }
            default:
                {
                    notImplemented();
                    break;
                }
            }
        }
    }
    else if (item->isA("LocalFolder"))
    {
        QPopupMenu *popup=item->contextMenu();
        if (popup)
        {
            int command=popup->exec(QCursor::pos());
            delete popup;
            if (command==-1) //no selection
                return;
            switch (command)
            {
            case ID_OPEN_FOLDER:
                {
                    item->setOpen(true);
                    break;
                }
            case ID_CLOSE_FOLDER:
                {
                    item->setOpen(false);
                    break;
                }
            case ID_NEW_FOLDER:
                {
                    doc->createFolder(((LocalFolder *)item)->path);
                    item->setOpen(false);
                    item->setOpen(true);
                    break;
                }
            default:
                {
                    notImplemented();
                    break;
                }
            }
        }
    }
}


