/***************************************************************************
 newkrndoc.cpp  -  description                              
 -------------------                                         
 begin                : Tue Jun  8 20:40:39 /etc/localtime 1999
 
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "newkrndoc.h"
#include "nntp.h"
#include "basegroup.h"
#include "resource.h"
#include "util.h"
#include "connmgr.h"
#include "serversroot.h"
#include "groupreader.h"
#include "kfileio.h"
#include "newserverdlg.h"
#include "newfolderdlg.h"
#include "serverpropdlg.h"

#include <kmsgbox.h>
#include <kapp.h>
#include "kmail/kmreaderwin.h"
#include "kmail/kmmessage.h"
#include <qdir.h>
#include <qfile.h>
#include <qlineedit.h>
#include <mimelib/mimepp.h>

NewKrnDoc::NewKrnDoc(QObject *parent):QObject(parent)
{
}

NewKrnDoc::~NewKrnDoc()
{
}

void NewKrnDoc::serverProperties(const char *profile)
{
    new ServerPropDlg(profile);
}

void NewKrnDoc::newServer()
{
    new NewServerDlg();
}

struct getactive_arg
{
    QString server;
    QObjectLVI *blocked;
};

void *thr_GetActive(void *_arg)
{
    getactive_arg *arg=(getactive_arg *)_arg;
    arg->blocked->busy();
    KMTNntpClient *client=connmgr->getConn(arg->server);
    if (client)
    {
        client->getActive();
        connmgr->releaseConn(client);
    }
    arg->blocked->idle();
    return NULL;
}

void NewKrnDoc::getActive(const char *server, QObjectLVI *blocked)
{
    getactive_arg *arg=new getactive_arg;
    arg->server=server;
    arg->blocked=blocked;
    pth_spawn(attr,thr_GetActive,arg);;
}

struct opengroup_arg
{
    BaseGroup *group;
    QObjectLVI *blocked;
    GroupReader *greader;
};

void *thr_openGroup(void *_arg)
{
    opengroup_arg *arg=(opengroup_arg *)_arg;
    arg->blocked->busy();
    arg->group->update();
    arg->greader->setGroup(arg->group);
    arg->blocked->idle();

    /*    QListViewItem * myChild = arg->greader->artList->firstChild();
        ArticleItem *ai;
        //FIXME there is a race condition here, because greader may be deleted
        while( myChild )
        {
            ai=(ArticleItem *)myChild;
            ai->busy();
            arg->group->fetch(ai->ID);
            ai->idle();
            pth_sleep(2);
            myChild = myChild->nextSibling();
        }
        arg->blocked->idle();
        */
    return NULL;
}

void NewKrnDoc::openGroup(BaseGroup *group, QObjectLVI *blocked, GroupReader *greader)
{
    opengroup_arg *arg=new opengroup_arg;
    arg->group=group;
    arg->blocked=blocked;
    arg->greader=greader;
    pth_spawn(attr,thr_openGroup,arg);;
}

struct updategroup_arg
{
    BaseGroup *group;
    QObjectLVI *blocked;
};

void *thr_updateGroup(void *_arg)
{
    updategroup_arg *arg=(updategroup_arg *)_arg;
    arg->blocked->busy();
    arg->group->update();
    arg->blocked->idle();
    return NULL;
}

void NewKrnDoc::updateGroup(BaseGroup *group, QObjectLVI *blocked)
{
    updategroup_arg *arg=new updategroup_arg;
    arg->group=group;
    arg->blocked=blocked;
    pth_spawn(attr,thr_updateGroup,arg);;
}

struct showarticle_arg
{
    BaseGroup *group;
    QObjectLVI *blocked;
    const char *ID;
    KMReaderWin *widget;
};

void *thr_showArticle(void *_arg)
{
    showarticle_arg *arg=(showarticle_arg *)_arg;
    arg->blocked->busy();
    arg->widget->setMsg(0);
    bool b=arg->group->fetch(arg->ID,false);
    if (b)
    {
        QString path=KApplication::localkdedir()+"/share/apps/newkrn/cache/"+arg->ID;
        QString data=kFileToString (path,true,false);
        debug (path.data());
        DwMessage *m=new DwMessage(data.data());
        m->Parse();
        arg->widget->setMsg(new KMMessage(m));
    }
    arg->blocked->idle();
    return NULL;
}

void NewKrnDoc::showArticle(BaseGroup *group, QObjectLVI *blocked,const char *ID,KMReaderWin *widget)
{
    showarticle_arg *arg=new showarticle_arg;
    arg->group=group;
    arg->blocked=blocked;
    arg->ID=ID;
    arg->widget=widget;
    pth_spawn(attr,thr_showArticle,arg);
}

struct setread_arg
{
    const char *ID;
    bool read;
};

void *thr_setRead(void *_arg)
{
    setread_arg *arg=(setread_arg *)_arg;
    Article *art=new Article(arg->ID);
    art->Read=arg->read;
    art->save();
    return NULL;
}

void NewKrnDoc::setRead (const char *ID, bool read)
{
    setread_arg *arg=new setread_arg;
    arg->ID=ID;
    arg->read=read;
    pth_spawn(attr,thr_setRead,arg);
}


/*
struct downloadarticles_arg
{
    Group *group;
		ArticleList list;
};

void *thr_downloadArticles(void *_arg)
{
    downloadarticles_arg *arg=(downloadarticles_arg *)_arg;
		QListIterator <Article> it(arg->list);
		for (;it.current();++it)
		{
			arg->group->fetch(it.current()->ID);
			pth_yield();
		}
    return NULL;
}


void NewKrnDoc::downloadArticles(Group *group,ArticleList list)
{
    downloadarticles_arg *arg=new downloadarticles_arg;
    arg->group=group;
    arg->list=list;
    pth_spawn(NPS_ATTR_NULL,thr_downloadArticles,arg);;
}
*/

/**  */
void NewKrnDoc::createFolder (const char *path)
{
    NewFolderDlg *dlg=new NewFolderDlg();
    QString dname=dlg->name->text();
    if (dname.isEmpty())
        return;
    else
    {
        QString fname=QString(path)+"/"+dname;
        if (QFile::exists(fname))
            return;
        else
            QDir(path).mkdir(dname);
    }
}



/**  */
void NewKrnDoc::subscribeGroup(const char *name)
{
    QString path=KApplication::localkdedir()+"/share/apps/newkrn/subscribed";
    QString data=kFileToString(path,true,false);
    data=data+name;
    //FIXME handle errors and ensure unique
    bool b=kStringToFile(data,path,false,false);
}

