/*
 */

#include "connect.h"
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include "logger.h"

// Error Codes that don't matter 
#define TCP_OK 0
#define TCP_EXIT_AFTER_TIMEOUT 1

// Fatal Error Codes
#define TCP_FATAL 8192+0
#define TCP_TIMEOUT 8192+1


// Timeout for FTP
int ftp_timeout = 30;


// Dummy Handler 
void 
dummy_SIGCHLD_proc (int SIG)
{
}

void 
unmask_SIGCHLD ()
{
  struct sigaction sa;
  sigset_t nbs;

  sa.sa_handler = dummy_SIGCHLD_proc;
  sigfillset (&sa.sa_mask);
  sa.sa_flags = SA_ONESHOT;
  sa.sa_restorer = NULL;
  sigaction (SIGCHLD, &sa, NULL);

  sigemptyset (&nbs);
  sigaddset (&nbs, SIGCHLD);
  sigprocmask (SIG_UNBLOCK, &nbs, NULL);
}

void 
mask_SIGCHLD ()
{
  sigset_t bs;

  sigemptyset (&bs);
  sigaddset (&bs, SIGCHLD);
  sigprocmask (SIG_BLOCK, &bs, NULL);
}


int
advconnect (int s, struct sockaddr *sa, int sa_size)
{
  pid_t r;
  struct timeval tv;
  int child_status;

  unmask_SIGCHLD ();
  switch (r = fork ())
    {
    case 0:			/* we are child */
      if (connect (s, sa, sa_size) == -1)
	{
	  logerror (LC_NONFATAL, "advconnect:connect");
	  _exit (0);
	}
      logit (LC_INFO, "Connected");
      _exit (1);

    case -1:			/* error */
      logerror (LC_FATAL, "advconnect:fork");
      return (TCP_FATAL);

    default:			/* we are parent */
      tv.tv_sec = ftp_timeout;
      tv.tv_usec = 0;
      switch (select (s + 1, NULL, NULL, NULL, &tv))
	{
	case 0:		/* timeout */
	  logit (LC_WARNING, "Timeout");
	  mask_SIGCHLD ();
	  kill (r, SIGTERM);	/* kill child */
	  waitpid (r, NULL, 0);	/* wait for child exit */
	  return (TCP_TIMEOUT);

	case -1:		/* error */
	  if (errno == EINTR)
	    {			/* signal from child */
	      waitpid (r, &child_status, 0);	/* wait for child exit */
	      if (!WIFEXITED (child_status))
		{
		  logit (LC_FATAL, "We are receive non-blocking signal, but child was not exit normally");
		  kill (r, SIGTERM);
		  waitpid (r, NULL, 0);
		  return (TCP_FATAL);
		}
	      if (WEXITSTATUS (child_status) == 0)
		return (TCP_EXIT_AFTER_TIMEOUT);
	      if (WEXITSTATUS (child_status) == 1)
		break;
	      logit (LC_FATAL, "Unknown child exit code");
	      return (TCP_FATAL);
	    }
	  else
	    {
	      logerror (LC_FATAL, "advconnect:select");
	      return (TCP_FATAL);
	    }
	}
    }

  return (TCP_OK);
}
