/**********************************************************************

 *********************************************************************/

#include "downloadDlg.h"
#include "downloadDlg.moc"

#define Inherited QDialog

#include <qpushbt.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <kurl.h>
#include <stdio.h>
#include <kapp.h>
extern int search(char *file, char *pointer, int len);
extern KApplication *TemplateApplication; 
char *
getLine (char *pointer, char *buffer, int buflen)
{
  char *run = pointer;
  int skip;			// Skip "\r\n" or "\n" skip=1 or skip=2

  while (*run++ != 0) {
    if (*run == '\n') {
      if (*(--run) == '\r') {
	skip = 2;
	break;
      }
 else {
	skip = 1;
	run++;
	break;
      }
    }
  }

  int stringlen = run - pointer;
  if (stringlen > buflen)
    return 0L;
 //printf("Stringlen = %i\n", stringlen);
  strncpy (buffer, pointer, stringlen);
  buffer[stringlen] = 0;	// Mark Bufferend

  if (skip == 2) {
    run++;
    run++;
  }

  else
    run++;
  return run;
}
      

downloadDlg::downloadDlg
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE, 0 )
{
	list = new QListT<QString>;
	
	QGroupBox* dlgedit_GroupBox_2;
	dlgedit_GroupBox_2 = new QGroupBox( this, "GroupBox_2" );
	dlgedit_GroupBox_2->setGeometry( 10, 90, 440, 320 );
	dlgedit_GroupBox_2->setMinimumSize( 10, 10 );
	dlgedit_GroupBox_2->setMaximumSize( 32767, 32767 );
	dlgedit_GroupBox_2->setFrameStyle( 49 );
	dlgedit_GroupBox_2->setTitle( "Host Machine" );
	dlgedit_GroupBox_2->setAlignment( 1 );

	QGroupBox* dlgedit_GroupBox_1;
	dlgedit_GroupBox_1 = new QGroupBox( this, "GroupBox_1" );
	dlgedit_GroupBox_1->setGeometry( 10, 10, 440, 70 );
	dlgedit_GroupBox_1->setMinimumSize( 10, 10 );
	dlgedit_GroupBox_1->setMaximumSize( 32767, 32767 );
	dlgedit_GroupBox_1->setFrameStyle( 49 );
	dlgedit_GroupBox_1->setTitle( "File" );
	dlgedit_GroupBox_1->setAlignment( 1 );

	fileURL = new QLineEdit( this, "LineEdit_1" );
	fileURL->setGeometry( 20, 30, 420, 30 );
	fileURL->setMinimumSize( 10, 10 );
	fileURL->setMaximumSize( 32767, 32767 );
	fileURL->setText( "" );
	fileURL->setMaxLength( 32767 );
	fileURL->setEchoMode( QLineEdit::Normal );
	fileURL->setFrame( TRUE );
	
	setupListBox();


	QPushButton* dlgedit_PushButton_1;
	dlgedit_PushButton_1 = new QPushButton( this, "PushButton_1" );
	dlgedit_PushButton_1->setGeometry( 360, 110, 80, 30 );
	dlgedit_PushButton_1->setMinimumSize( 10, 10 );
	dlgedit_PushButton_1->setMaximumSize( 32767, 32767 );
	dlgedit_PushButton_1->setText( "Download" );
	dlgedit_PushButton_1->setAutoRepeat( FALSE );
	dlgedit_PushButton_1->setAutoResize( FALSE );
        connect(dlgedit_PushButton_1, SIGNAL(released()),
		  this, SLOT(startCopy()));

	//QLineEdit* dlgedit_Status;
	dlgedit_Status = new QLineEdit( this, "Status" );
	dlgedit_Status->setGeometry( 20, 370, 330, 30 );
	dlgedit_Status->setMinimumSize( 10, 10 );
	dlgedit_Status->setMaximumSize( 32767, 32767 );
	{
		QColorGroup normal( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(12632256) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(12632256) ) );
		QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(8421504) ), QColor( QRgb(12632256) ) );
		QColorGroup active( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
		QPalette palette( normal, disabled, active );
		dlgedit_Status->setPalette( palette );
	}
	dlgedit_Status->setText( "" );
	dlgedit_Status->setMaxLength( 32767 );
	dlgedit_Status->setEchoMode( QLineEdit::Normal );
	dlgedit_Status->setFrame( TRUE );

	QPushButton* dlgedit_PushButton_2;
	dlgedit_PushButton_2 = new QPushButton( this, "PushButton_2" );
	dlgedit_PushButton_2->setGeometry( 360, 140, 80, 30 );
	dlgedit_PushButton_2->setMinimumSize( 10, 10 );
	dlgedit_PushButton_2->setMaximumSize( 32767, 32767 );
	dlgedit_PushButton_2->setText( "Stop" );
	dlgedit_PushButton_2->setAutoRepeat( FALSE );
	dlgedit_PushButton_2->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_3;
	dlgedit_PushButton_3 = new QPushButton( this, "PushButton_3" );
	dlgedit_PushButton_3->setGeometry( 360, 370, 80, 30 );
	dlgedit_PushButton_3->setMinimumSize( 10, 10 );
	dlgedit_PushButton_3->setMaximumSize( 32767, 32767 );
	dlgedit_PushButton_3->setText( "Cancel" );
	dlgedit_PushButton_3->setAutoRepeat( FALSE );
	dlgedit_PushButton_3->setAutoResize( FALSE );
	dlgedit_PushButton_3->setDefault(TRUE);
	dlgedit_PushButton_3->setFocus();

        connect(dlgedit_PushButton_3, SIGNAL(released()),
		  this, SLOT(accept()));

        setCaption("Download");
	resize( 460,420 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );


    searchSlaveBuffer = (char *)malloc(100*1024);
   
    searchSlaveBufferRun = searchSlaveBuffer;
 
    searchSlave = new KProcess;
    searchSlave->clearArguments();
    *searchSlave << "kzilla.search.slave" << KURL(fileURL->text()).filename();
    connect( searchSlave, SIGNAL(receivedStdout(KProcess *, char *, int)),
   	     this, SLOT(searchSlaveStdout(KProcess *, char *, int)) );
    connect( searchSlave, SIGNAL(processExited(KProcess *)), 
	     this, SLOT(searchSlaveExited(KProcess *)) );
 //   searchSlave->start(KProcess::NotifyOnExit, KProcess::Stdout);
    
    dlgedit_Status->setText("Sent Query to ftpno.nu.no...");
	
	setActiveWindow();
  	setFocus();
	 
}

/* Our KTabListBox */
void
downloadDlg::setupListBox()
{
  ListBox = new KTabListBox(this, "test", 5);
  ListBox->setGeometry( 20, 110, 330, 260 );

  ListBox->setSeparator(' ');
  ListBox->setColumn(0,"Machine",140);
  ListBox->setColumn(1,"Hops",40);
  ListBox->setColumn(2,"Trip",40);
  ListBox->setColumn(3,"Loss",40);
  ListBox->setColumn(4,"Status",120);
}
void
downloadDlg::updateListBox()
{
	char buffer1[1024];
	char buffer2[1024];
	char buffer3[1024];
	char buffer4[1024];
	int z;
	
	char *run=searchSlaveBuffer;


	/* first Line contains Status Information */
	run=getLine(run, (char *)&buffer4, 1024);
	//printf(">>buffer: %s<<\n",buffer4);
	sscanf((char *) &buffer4,"%s",(char *)&buffer1);
	
	/* We search a status OK */
	if ( ! (buffer1[0]=='O' && buffer1[1]=='K') ) return;
	
	/* No we get the number of items for the listbox into z */
	sscanf((char *) &buffer4,"%s%i",(char *)&buffer1,&z);

	/* Now we read in z items, insert them into a List and into a Listbox
	 * 
	 */

	int status;
	for (int i = 0; i < z; i++) {
		run=getLine( run, (char *)&buffer4, 1024);
		status = sscanf((char*)&buffer4, "%s%s%s",(char*)&buffer1,(char*)&buffer2,(char*)&buffer3);
 		/* if havn't 3 converted items we stop */
		if ( status == 3) {
			KURL url = KURL( (char *) &buffer3 );
			list->append(new QString((char *) &buffer3));
			ListBox->insertItem(url.host());
		}else break;
		}
	
}
/* Signal Section */

/* startCopy is the signal receiver from the DOWNLOAD Button 
 * Do what it says
 */
void
downloadDlg::startCopy()
{
	int item;
	/* Get Item in ListBox*/
	
	item = ListBox->currentItem();
	if ( item == -1 )  // No Item selected
		return;
	
	QString *line = list->at(item);
	QString destination = "file:";


        KConfig *kc = TemplateApplication->getConfig();
        kc->setGroup("Configuration");    
	if (  kc->readEntry("Destination") == NULL ) {
	kc->writeEntry("Destination", "/tmp");
        kc->sync();
        }
	destination +=  kc->readEntry("Destination");
	//  FIXME if no '/' at end of destination add /
	if ( destination[destination.length()]  != '/' )
		destination += '/';
	else printf("c = %i\n", destination[destination.length()] );
	
	destination += KURL(line->data()).filename();
	
	urlcopy(KURL(line->data()),KURL(destination.data()));
}

/* Start the actual Download 
 * for now or slave is kfmclient 
 */
void
downloadDlg::urlcopy(KURL source, KURL dest)
{ 
  KProcess *proc;
  proc = new KProcess;
  proc->clearArguments();
  *proc << "kfmclient" << "copy" << source.url().data() << dest.url().data();
  proc->start(KProcess::DontCare, KProcess::NoCommunication);

}
void 
downloadDlg::searchSlaveStdout(KProcess *, char *buffer, int len)
{
	/*
	for ( int i= 0; i < len; i++ )
		searchSlaveBuffer += *(buffer+i);
	*/
	strncpy(searchSlaveBufferRun, buffer,len);
	searchSlaveBufferRun+=len;
	
}
void 
downloadDlg::searchSlaveExited(KProcess *)
{
	printf("%s",searchSlaveBuffer);
	dlgedit_Status->setText("Query Finished");
	searchSlaveBufferRun=searchSlaveBuffer; // Reset
	updateListBox();
}

downloadDlg::~downloadDlg()
{
	delete fileURL;
	delete ListBox;
	delete searchSlave;
	delete dlgedit_Status;
	
	free(searchSlaveBuffer);
}
