/****************************************************************************
** $Id: table.cpp,v 1.7 1998/05/21 19:24:59 agulbra Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include <kapp.h>
#include "userview.h"
#include "userview.moc"
#include <qpainter.h>
#include <qkeycode.h>
//#include <qprinter.h>
#include <qscrollbar.h>
#include <qpalette.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <libXicq.h>
#include <qwidget.h>
#include "kxicq.h"
#include "dialogs.h"
#include "sendDialog.h"


extern mainWin *mainW;
extern int logged_on;
extern KApplication *mainApp;
extern QList < MSG > userMsg;
extern DockView *dockView;
extern struct kxicqConfig KxicqConfig;
extern int stopAll;
extern MSG *askAnyRead();
/*
  Constructs a userView widget.
  */

userView::userView( int t, QWidget *parent, const char *name )
        : QTableView( parent, name )
{
    type = t;
    setMouseTracking( TRUE );
    curRow = curCol = 0; 			// set currently selected cell
    setFocusPolicy( StrongFocus ); 		// we accept keyboard focus
    setBackgroundMode( PaletteMid ) ;    	// set widgets background
    setNumCols( 1 ); 			// set number of col's in table
    setFocusPolicy( QWidget::StrongFocus );
    // set number of rows in table

    QPixmap pixmap;
    KIconLoader *iconL = kapp->getIconLoader(); ;
    menu = new QPopupMenu;
    pixmap = iconL->loadIcon( "send.xpm" );
    menu->insertItem( pixmap, i18n( "&Message" ), this, SLOT( sendMessage() ) );
    menu->insertItem( pixmap, i18n( "&Url" ), this, SLOT( sendUrl() ) );
    menu->insertSeparator();
    menu->insertItem( i18n( "&Send Chat Request" ), this, SLOT( sendChatRequest() ) );
    menu->insertItem( i18n( "R&ead Away Message" ), this, SLOT( askAway() ) );
    menu->insertSeparator();
    menu->insertItem( i18n( "&Delete User" ), this, SLOT( deleteUser() ) );
    menu->insertItem( i18n("&Rename User"), this, SLOT(renameSlot()));
    menu->insertItem( i18n( "&Info" ), this, SLOT( showInfo() ) );


    contents = new QString[ 105 ];
    for ( int y = 0; y < 101; y++ )
    {
        contents[ y ].sprintf( "0" );
    }

    switch ( type )
    {
        case VIEW_OFFLINE:
            CONTACT contact;
            setNumRows( contact_length() );
            for ( int t = 0; t < contact_length(); t++ )
            {
                contact = contact_returnItemNum( t );
                contents[ t ].sprintf( "%d", contact.uin );
            }
            break;
        case VIEW_ONLINE:
            setNumRows( 1 );

            contents[ 0 ].sprintf( "%d", TYPE_SERVER );
            break;
    }

    //QFont f("Helvetica", 16, QFont::Bold);

    //p->setFont(f);

    setupConfig();
    //          setCellHeight( 36 );			// set height of cell in pixels
    setTableFlags( Tbl_autoVScrollBar | 		// always vertical scroll bar
                   //        Tbl_hScrollBar |		// ditto for horizontal
                   Tbl_clipCellPainting | 	// avoid drawing outside cell
                   Tbl_smoothScrolling ); 	// easier to see the scrolling

    userEdit = new QLineEdit( this );
    userEdit->hide();
    connect( userEdit, SIGNAL( returnPressed() ), this, SLOT( updateUserInfo() ) );
    connect( userEdit, SIGNAL( returnPressed() ), userEdit, SLOT( hide() ) );

    
    resize( 400, 200 ); 				// set default size in pixels

}

void userView::setupConfig()
{
    QFont f;
    if ( type == VIEW_ONLINE )
    {
        //p->setFont(KxicqConfig.onlineF);
        f = KxicqConfig.onlineF;
    }
    else
    {
        //p->setFont(KxicqConfig.offlineF);
        f = KxicqConfig.offlineF;
    }

    QFontMetrics fm( f );
    int fh=0;
    if (KxicqConfig.viewSmall)
    {
        fh = fm.height();
    }
    else
    {
        //p->setFont( KxicqConfig.uinF );
        QFontMetrics uinfmt( KxicqConfig.uinF );
        fh = fm.height()+uinfmt.height();
    }
    int viewH = fh + 4;
    setCellHeight( viewH );
}

/*
  Destructor: deallocates memory for contents
*/

userView::~userView()
{
    delete[] contents; 				// deallocation
}


/*
  Return content of cell
*/

const char* userView::cellContent( int row, int col ) const
{
    return contents[ indexOf( row, col ) ]; 	// contents array lookup
}


/*
  Set content of cell
*/

void userView::setCellContent( int row, int col, const char* c )
{
    contents[ indexOf( row, col ) ] = c; 		// contents lookup and assign
    updateCell( row, col ); 			// show new content
}

bool Press=FALSE;

void userView::mouseMoveEvent( QMouseEvent *e )
{
    Press=FALSE;
    int oldRow = curRow; 			// store previous current cell
    int oldCol = curCol;
    curRow = findRow( e->y() ); 		// map to row; set current cell
    curCol = findCol( e->x() ); 		// map to col; set current cell
    if ( ( curRow != oldRow )  			// if current cell has moved,
            || ( curCol != oldCol ) ) {
        setFocus();
        updateCell( oldRow, oldCol ); 		// erase previous marking
        updateCell( curRow, curCol ); 		// show new current cell
    }
}
/*
  Handles cell painting for the userView widget.
*/

void userView::paintCell( QPainter* p, int row, int col )
{
    int w = viewWidth(); //cellWidth( col ); 			// width of cell in pixels
    int h = cellHeight( row ) - 1; 			// height of cell in pixels
    int x2 = w - 1;
    int y2 = h - 1;

    if ( type == VIEW_ONLINE )
    {
        p->setBrush( KxicqConfig.onlineB);
        p->setPen(  KxicqConfig.onlineB);
    }
    else
    {
        p->setBrush( KxicqConfig.offlineB );
        p->setPen(  KxicqConfig.offlineB );
    }
    p->drawRect( 1, 1, x2 - 1, y2 - 1 );
    //p->setPen( DotLine );
    QColorGroup g = colorGroup();
    QColor c;
    if ( type == VIEW_ONLINE )
        c=KxicqConfig.onlineB;
    else
        c=KxicqConfig.offlineB;
    
    p->setPen( c.light() );
    p->drawLine( 0, 0, 0, h );
    p->drawLine( 0, 0, w, 0 );
    p->setPen( black );
    p->drawLine( w, h, 1, h );
    p->drawLine( w, h, w, 1 );

    /*
      Draw extra frame inside if this is the current cell.
      */
    int select = 0;
    if ( type == VIEW_ONLINE )
            {
                p->setPen( KxicqConfig.onlineT );
            }
            else
            {
                p->setPen( KxicqConfig.offlineT );
            }
    if ( ( row == curRow ) && ( col == curCol ) )
    { // if we are on current cell,
        if ( hasFocus() ) {
            if (Press)
            {
                p->setPen( black );
                p->drawLine( 0, 0, 0, h );
                p->drawLine( 0, 0, w, 0 );
                p->setPen( g.light() );
                p->drawLine( w, h, 1, h );
                p->drawLine( w, h, w, 1 );
            }
            else
            {
                p->setPen( g.light() );
                p->drawLine( 0, 0, 0, h );
                p->drawLine( 0, 0, w, 0 );
                p->setPen( black );
                p->drawLine( w, h, 1, h );
                p->drawLine( w, h, w, 1 );
            }
            if ( type == VIEW_ONLINE )
            {
                p->setBrush( KxicqConfig.onlineSB );
                p->setPen( KxicqConfig.onlineSB);
            }
            else
            {
                p->setBrush( KxicqConfig.offlineSB );
                p->setPen(KxicqConfig.offlineSB );
            }
            p->drawRect( 1, 1, x2 - 1, y2 - 1 ); 	// draw rect. along cell edges
            if (Press) select = 2; else select=0;
            if ( type == VIEW_ONLINE )
            {
                p->setPen( KxicqConfig.onlineST );
            }
            else
            {
                p->setPen( KxicqConfig.offlineST );
            }
        }
    }

    QFont f;
    if ( type == VIEW_ONLINE )
    {
        p->setFont( KxicqConfig.onlineF );
        f = KxicqConfig.onlineF;
    }
    else
    {
        p->setFont( KxicqConfig.offlineF );
        f = KxicqConfig.offlineF;
    }
    QFontMetrics fm( f );
    int fh=0;
    if (KxicqConfig.viewSmall)
    {
        fh = fm.height();
    }
    else
    {
        //p->setFont( KxicqConfig.uinF );
        QFontMetrics uinfmt( KxicqConfig.uinF );
        fh = fm.height()+uinfmt.height();
    }
    int viewH = fh + 4;
    //    setCellHeight(viewH);
    
    KIconLoader *loader = kapp->getIconLoader(); ;
    QPixmap icon;
    CONTACT contact = contact_returnContact( atoi( contents[ row ].data() ) );
    if ( contact.uin > 0 )
    {
        QString nick;
        nick.sprintf( "%s", contact.nick );
        p->drawText( viewH + 2 + select, 2 + select, w - ( 2 + select ), fh, AlignLeft, nick.data() );
        //        QFont uinf=KxicqConfig.uinF;
        p->setFont( KxicqConfig.uinF );
        QFontMetrics uinfm( KxicqConfig.uinF );
        fh = uinfm.height();
        if ( KxicqConfig.showUIN && !KxicqConfig.viewSmall)
        {
            if ( KxicqConfig.showTextStatus )
            {
                p->drawText( 2 + select, 2 + select, w - ( 2 + ( select == 0 ? 2 : 0 ) ), fh, AlignRight, contents[ row ] );
            }
            else
            {
                p->drawText( 2 + select, 2 + select + fh + 1, w - ( 2 + ( select == 0 ? 2 : 0 ) ), fh, AlignRight, contents[ row ] );
            }
        }
        QString status;
        status.sprintf( "user is %s", contact_status2str( contact.status ) );
        if ( KxicqConfig.showTextStatus ) p->drawText( 2 + select, 2 + select + fh + 1, w - ( 2 + ( select == 0 ? 2 : 0 ) ), fh, AlignRight, status.data() );


        bool doIcon = TRUE;
        QString tmpstatus;

        tmpstatus.sprintf( "%s", contact_status2str( contact.status ) );
        if ( strcmp( tmpstatus.data(), "Away" ) == 0 )
        {
            icon = loader->loadIcon( "away.xpm" );
        }
        else
        {
            if ( strcmp( tmpstatus.data(), "N/A" ) == 0 )
            {
                icon = loader->loadIcon( "NA.xpm" );
            }
            else
            {
                if ( strcmp( tmpstatus.data(), "Occupied" ) == 0 )
                {
                    icon = loader->loadIcon( "occu.xpm" );
                }
                else
                {
                    if ( strcmp( tmpstatus.data(), "DND" ) == 0 )
                    {
                        icon = loader->loadIcon( "DND.xpm" );
                    }
                    else
                    {
                        if ( strcmp( tmpstatus.data(), "Free for chat" ) == 0 )
                        {
                            icon = loader->loadIcon( "ffc.xpm" );
                        }
                        else
                        {
                            if ( strcmp( tmpstatus.data(), "Invisible" ) == 0 )
                            {
                                icon = loader->loadIcon( "invi.xpm" );
                            }
                            else
                            {
                                doIcon = FALSE;
                            }
                        }
                    }
                }
            }
        }
        int iw = icon.width() / 2;
        int ih = icon.height() / 2;
        if ( doIcon )
        {
            if ( KxicqConfig.rightStatus )
            {
                p->drawPixmap( ( w - icon.width() ) - ( 2 + ( select == 0 ? 2 : 0 ) ), select, icon );
            }
            else
            {
                p->drawPixmap( 2 + select, select + 2, icon );
            }
        }

        doIcon = FALSE;
        if ( askRead( contact.uin ) )
        {
            icon = loader->loadIcon( "filemail.xpm" );
            doIcon = TRUE;
        }
        else
        {
            if ( ifMsg( contact.uin ) )
            {
                icon = loader->loadIcon( "read.xpm" );
                doIcon = TRUE;
            }

        }
        iw = icon.width() / 2;
        ih = icon.height() / 2;
        if ( doIcon ) p->drawPixmap( select + ( ( viewH / 2 ) - iw ), select + ( ( viewH / 2 ) - ih ), icon );


    }
    else
    {
        QString nick;
        nick.sprintf( i18n("Server/Unknown") );
        p->drawText( viewH + 2 + select, 2 + select, w - ( 2 + select ), fh, AlignLeft, nick.data() );
        QFont uinf( "Helvetica", 10 );
        p->setFont( uinf );
        QFontMetrics uinfm( uinf );
        //int fhw = uinfm.height();
        //if (KxicqConfig.viewSmall)
        //    p->drawText( viewH + 2 + select, select + fh, w - ( 2 + select ), fhw, AlignLeft, i18n("this is no normal user !") );
        bool doIcon = FALSE;
        if ( askRead( TYPE_SERVER ) )
        {
            icon = loader->loadIcon( "filemail.xpm" );
            doIcon = TRUE;
        }
        else
        {
            if ( ifMsg( TYPE_SERVER ) )
            {
                icon = loader->loadIcon( "read.xpm" );
                doIcon = TRUE;
            }

        }
        int iw = icon.width() / 2;
        int ih = icon.height() / 2;
        if ( doIcon ) p->drawPixmap( select + ( ( viewH / 2 ) - iw ), select + ( ( viewH / 2 ) - ih ), icon );
    }

}


/*
  Handles mouse press events for the userView widget.
  The current cell marker is set to the cell the mouse is clicked in.
*/

void userView::mousePressEvent( QMouseEvent* e )
{
    setMouseTracking( TRUE );
    userEdit->hide();
    Press=TRUE;

    int oldRow = curRow; 			// store previous current cell
    int oldCol = curCol;
    curRow = findRow( e->y() ); 		// map to row; set current cell
    curCol = findCol( e->x() ); 		// map to col; set current cell
    if ( ( curRow != oldRow )  			// if current cell has moved,
            || ( curCol != oldCol ) ) {
        setFocus();
        updateCell( oldRow, oldCol ); 		// erase previous marking
        updateCell( curRow, curCol ); 		// show new current cell
    }

    
    int x, y;
    x = findCol( e->x() );
    y = findRow( e->y() );
    if ( y >= 0 && x >= 0 && y <= numRows() )
    {

        if ( e->button() == RightButton )
        {
            if ( !stopAll ) menu->popup( QCursor::pos() );

        }
        if ( e->button() == MidButton )
        {
            showMessage();
        }
        if ( e->button() == LeftButton && KxicqConfig.kdestyle )
        {
            showMessage();
        }
        repaint();
    }
    QTableView::mousePressEvent( e );
}


/*
  Handles key press events for the userView widget.
  Allows moving the current cell marker around with the arrow keys
*/

void userView::keyPressEvent( QKeyEvent* e )
{

    int oldRow = curRow; 			// store previous current cell
    int oldCol = curCol;
    int edge = 0;
    switch ( e->key() ) {			// Look at the key code
        case Key_Left: 				// If 'left arrow'-key,
            if ( curCol > 0 ) {			// and cr't not in leftmost col
                curCol--;      			// set cr't to next left column
                edge = leftCell(); 		// find left edge
                if ( curCol < edge ) 		// if we have moved off  edge,
                    setLeftCell( edge - 1 ); 	// scroll view to rectify
            }
            break;
        case Key_Right: 				// Correspondingly...
            if ( curCol < numCols() - 1 ) {
                curCol++;
                edge = lastColVisible();
                if ( curCol >= edge )
                    setLeftCell( leftCell() + 1 );
            }
            break;
        case Key_Up:
            if ( curRow > 0 ) {
                curRow--;
                edge = topCell();
                if ( curRow < edge )
                    setTopCell( edge - 1 );
            }
            break;
        case Key_Down:
            if ( curRow < numRows() - 1 ) {
                curRow++;
                edge = lastRowVisible();
                if ( curRow >= edge )
                    setTopCell( topCell() + 1 );
            }
            break;
        default: 				// If not an interesting key,
            e->ignore(); 			// we don't accept the event
            return;
    }

    if ( ( curRow != oldRow )  			// if current cell has moved,
            || ( curCol != oldCol ) ) {
        updateCell( oldRow, oldCol ); 		// erase previous marking
        updateCell( curRow, curCol ); 		// show new current cell
    }
}


/*
  Handles focus reception events for the userView widget.
  Repaint only the current cell; to avoid flickering
*/

void userView::focusInEvent( QFocusEvent* )
{
    updateCell( curRow, curCol ); 		// draw current cell
}


/*
  Handles focus loss events for the userView widget.
  Repaint only the current cell; to avoid flickering
*/

void userView::focusOutEvent( QFocusEvent* )
{
    updateCell( curRow, curCol ); 		// draw current cell
}


/*
  Utility function for mapping from 2D table to 1D array
*/

int userView::indexOf( int row, int col ) const
{
    return ( row * numCols() ) + col;
}


void userView::resizeEvent( QResizeEvent *e )
{
    QTableView::resizeEvent( e );
    const QScrollBar * vb = verticalScrollBar();
    int sw = -1;
    if ( vb ) if ( vb->isVisible() ) sw = vb->width();
    setCellWidth( width() - sw - 1 );
    QTableView::resizeEvent( e );
}

void userView::changeItem( UIN uin )
{
    int t;
    CONTACT contact;
    int num = numRows();


    switch ( type )
    {
        case VIEW_OFFLINE:
            contact = contact_returnContact( uin );
            if ( contact.uin > 0 )
            {
                if ( contact.status == STATUS_OFFLINE )
                {
                    for ( t = 0; t < num; t++ )
                    {
                        if ( ( UIN ) atoi( contents[ t ] ) == uin )
                        {
                            updateCell( t, 0 );
                            repaint();
                            return;
                        }
                    }
                    setNumRows( num + 1 );
                    contents[ numRows() - 1 ].sprintf( "%d", uin );

                    repaint();
                    return;
                }
                else
                {
                    for ( t = 0; t < num; t++ )
                    {
                        if ( ( UIN ) atoi( contents[ t ] ) == uin )
                        {
                            for ( int y = t; y < num - 1; y++ )
                            {
                                contents[ y ] = contents[ y + 1 ];
                            }
                            contents[ num ].sprintf( "0" );
                            setNumRows( num - 1 );
                            repaint();
                            return;
                        }
                    }
                }
            }
            break;
        case VIEW_ONLINE:
            contact = contact_returnContact( uin );
            if ( contact.uin > 0 )
            {
                if ( contact.status != STATUS_OFFLINE )
                {
                    // update item ( new messge )
                    for ( t = 0; t < num; t++ )
                    {
                        if ( ( UIN ) atoi( contents[ t ] ) == uin )
                        {
                            updateCell( t, 0 );
                            repaint();
                            return;
                        }
                    }
                    setNumRows( num + 1 );
                    contents[ numRows() - 1 ].sprintf( "%d", uin );

                    repaint();
                }
                else
                {
                    for ( t = 0; t < num; t++ )
                    {
                        if ( ( UIN ) atoi( contents[ t ] ) == uin )
                        {
                            for ( int y = t; y < num - 1; y++ )
                            {
                                contents[ y ] = contents[ y + 1 ];
                            }
                            setNumRows( num - 1 );
                            repaint();
                            return;
                        }
                    }
                }
            }
            else
            {
                updateCell( 0, 0 );
                repaint();
            }
            break;
    }

    return;

    for ( t = 0; t < num; t++ )
    {
        if ( (UIN)atoi( contents[ t ] ) == uin )
        {
            contact = contact_returnContact( uin );
            if ( ( type == VIEW_OFFLINE && contact.status != STATUS_OFFLINE ) || ( type == VIEW_ONLINE && contact.status == STATUS_OFFLINE ) )
            {

                for ( int y = t; y < num - 1; y++ )
                {
                    contents[ y ] = contents[ y + 1 ];
                }
                setNumRows( num - 1 );
                //update();
                repaint();
                return;
            }
            else
            {
                updateCell( t, 0 );
                repaint();
                return;
            }
        }
    }

    //    num=numRows();
    if ( logged_on==1 )
    {
        if ( ( type == VIEW_ONLINE && contact.status != STATUS_OFFLINE ) || ( type == VIEW_OFFLINE && contact.status == STATUS_OFFLINE ) )
        {
            contents[ num + 1 ].sprintf( "%d", uin );
            setNumRows( num + 1 );
            repaint();
        }
    }
    //update();
    //repaint();
}

void userView::showMessage()
{
    dockView->setStatus( mainW->currentStatus );
    int row = curRow;
    UIN uin = atoi( contents[ row ] );

    if ( ifMsg( uin ) == 0 )
    {
        return;
    }

    Read *tmpR;
    tmpR = new Read( uin, mainW );
    if ( !tmpR->exec() )
    {
        return;
    }
    mainApp->processEvents();
    mainApp->flushX();

    
    if (tmpR) delete tmpR;
    updateCell( row, 0 );
    dockView->setStatus( mainW->currentStatus );
}
void userView::askAway()
{
    QString tmp;
    tmp = contents[ curRow ];
    if ( atoi( tmp.data() ) <= 0 ) return;
    send_askAway(atoi(tmp.data()));

}
void userView::sendMessage()
{
    QString tmp;
    tmp = contents[ curRow ];
    if ( atoi( tmp.data() ) <= 0 ) return;
    sendDialog *myMsgWin;

    myMsgWin = new sendDialog( atoi( tmp ), SEND_MSG, mainW, "msgedit" );
    myMsgWin->setCaption( i18n( "Send Message to:" ) );
    if ( !myMsgWin->exec() )
    {
        return;
    }
    mainApp->processEvents();
    mainApp->flushX();
    if (myMsgWin) delete myMsgWin;
}
void userView::sendUrl()
{
    QString tmp;
    tmp = contents[ curRow ];
    if ( atoi( tmp.data() ) <= 0 ) return;
    sendDialog *myMsgWin;

    myMsgWin = new sendDialog( atoi( tmp ), SEND_URL, mainW, "msgedit" );
    myMsgWin->setCaption( i18n( "Send URL to:" ) );

    if ( !myMsgWin->exec() )
    {
        return;
    }
    mainApp->processEvents();
    mainApp->flushX();

    if (myMsgWin) delete myMsgWin;
}
void userView::sendChatRequest()
{
    QString tmp;
    tmp = contents[ curRow ];
    if ( atoi( tmp.data() ) <= 0 ) return;

    sendDialog *myMsgWin;

    myMsgWin = new sendDialog( atoi( tmp ), SEND_CHAT, mainW, "msgedit" );
    myMsgWin->setCaption( i18n( "Send Chat Request to:" ) );
    if ( !myMsgWin->exec() )
    {
        return;
    }
    mainApp->processEvents();
    mainApp->flushX();
    if (myMsgWin) delete myMsgWin;

}
void userView::showInfo()
{
    QString tmp;
    tmp = contents[ curRow ]; ;
    if ( atoi( tmp.data() ) <= 0 ) return;
    if ( logged_on==1 ) infoRequest( atoi( tmp.data() ) ); else loggedon();
}
void userView::deleteUser()
{
    const char *tmp = contents[ curRow ];

    if ( atoi( tmp ) != TYPE_SERVER )
    {
        contact_deleteContact( atoi( tmp ) );
        int num = numRows();
        for ( int y = curRow; y < num - 1; y++ )
        {
            contents[ y ] = contents[ y + 1 ];
        }

        setNumRows( num - 1 );
        repaint();

        return;
    }
}
void userView::renameSlot()
{
    const char *tmp = contents[ curRow ];
    int x,y;
    if ( atoi( tmp ) != TYPE_SERVER )
    {
        setMouseTracking( FALSE );
        x=15;
        rowYPos( curRow, &y );
        CONTACT contact = contact_returnContact( atoi( contents[ curRow ].data() ) );
        if ( contact.nick != NULL )
        {
            if ( strlen(contact.nick  ) > 0 )
            {
                userEdit->setText( contact.nick );
            }
            else
            {
                userEdit->setText( "" );
            }
        }
        userEdit->move( x, y );
        userEdit->setFixedWidth( viewWidth()-x);
        userEdit->setFixedHeight( cellHeight( curRow ) );
        userEdit->setFocus();
        userEdit->show();
    }
}

void userView::updateUserInfo()
{
    const char *tmp = contents[ curRow ];
    contact_renameContact( atoi( tmp ), userEdit->text() );
    updateCell( curRow, 0 );
    setMouseTracking( TRUE );
    userEdit->hide();
    stopAll = 0;
}


