
/***************************************************************
 
   Requires the Qt and KDE widget libraries, available at no cost at
   http://www.troll.no and http://www.kde.org respectively
 
   Copyright (C) 1997, 1998 Fester Zigterman ( fzr@dds.nl )
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 
   ***************************************************************/

#include "kpropmledit.h"
#include "kpropmledit.moc"
#include <kapp.h>
#include "kxicq.h"

KPropMLEdit::KPropMLEdit( QWidget *parent, const char *text, int perc, int h, const char *key, const char *group,
                          KConfig *config, const char *name )
        : QLabel( text, parent, name )
{
    setKConfig( config );
    setGroup( group );
    setKey( key );


    //	setText( MLEdit );
    setFontPropagation( QWidget::SameFont );
    lineEdit = new MLEditWrap( TRUE, this );

    percentage = perc;
    height = h;

    sizeUpdate();
}

KPropMLEdit::~KPropMLEdit()
{
    delete lineEdit;
}

MLEditWrap *KPropMLEdit::getLineEdit()
{
    return lineEdit;
}

void KPropMLEdit::sizeUpdate()
{
    QFontMetrics fm( font() );
    int h = fm.height()*height;

    setFixedHeight( h + 8 );
    lineEdit->setFixedHeight( h + 5 );
}

void KPropMLEdit::resizeEvent( QResizeEvent *rev )
{
    int w = width()*percentage / 100;
    lineEdit->setGeometry( width() - w , 2, w - 4, 100 );
}

void KPropMLEdit::fontChange( const QFont & )
{
    sizeUpdate();
}

void KPropMLEdit::setContents( const char *text )
{
    lineEdit->setText( text );
}

const char *KPropMLEdit::getContents()
{
    return lineEdit->text().data();
}

void KPropMLEdit::setConfig()
{
    //	printf("kpropMLEdit::setConfig()\n");
    if ( ConfigObject )
    {
        ConfigObject->setGroup( Group );
        //		printf("kpropMLEdit: group=%s key=%s\n",ConfigObject->group(), Key.data() );
        if ( Key.data() != 0 )
        {
            char * tmp;
            tmp = ( char * ) malloc( 1025 );
            strcpy( tmp, lineEdit->text().data() );
            dos2config( tmp );
            ConfigObject->writeEntry( Key.data(), tmp );
            free( tmp );
        }
        else printf( "kproptext: Null key not allowed\n" );
    }
}

void KPropMLEdit::getConfig()
{
    //	printf("kproptext::getConfig()\n");
    if ( ConfigObject )
    {
        ConfigObject->setGroup( Group );
        //		printf("kproptext: group set.\n");
        QString s = ConfigObject->readEntry( Key.data() );
        //		printf("kproptext: reading config %s = %s\n",Key.data(), s.data() );
        char *tmp;
        tmp = ( char * ) malloc( 1025 );
        strcpy( tmp, s.data() );
        config2dos( tmp, strlen( tmp ) );
        setContents( tmp );
        free( tmp );
    }
}


void KPropMLEdit::setKey( const char *key )
{
    Key = key;
}

void KPropMLEdit::setGroup( const char *group )
{
    Group = group;
}

void KPropMLEdit::setKConfig( KConfig *config )
{
    if ( config == 0 )
        ConfigObject = kapp->getConfig();
    else
        ConfigObject = config;
}

KConfig *KPropMLEdit::getKConfig()
{
    return ConfigObject;
}

const char *KPropMLEdit::getKey()
{
    return Key.data();
}

const char *KPropMLEdit::getGroup()
{
    return Group.data();
}
