/*
   $Id: dialogs.cpp,v 2.25.4.2.2.2 1998/12/20 21:01:58 herwinjs Exp $
*/


#include <errno.h>

#include <unistd.h>
#include <qframe.h>
#include <klocale.h>
#include <kapp.h>
#include <kfm.h>
#include "kxicq.h"
#include "sendDialog.h"
#include "dialogs.h"
#include <qmessagebox.h>
#include <kcolordlg.h>
//#include "users.h"

extern ReadFile readFile;
extern viewSearch *viewS;
extern searchDialog *searchD;
extern userInfo *userI;
extern int isViewSearch ;
extern int isDoSearch ;
extern int logged_on;
extern mainWin *mainW;
extern KApplication *mainApp;
extern QList < MSG > userMsg;
extern struct kxicqConfig KxicqConfig;
extern char *awayMsg;
extern KConfig *totalConfig;
extern DockView *dockView;
////////// READ MSG/URL etc. CLASS /////////////////

Read::Read( UIN u, mainWin *parent, const char *name )
        : QDialog( parent, name, TRUE)
{
    uin = u;
    p = parent;
    
    setFixedSize( 450, 300 );
//    tabbar = new QTabDialog(this,"main tab");
//    tabbar->setGeometry(450,350);

//    QWidget *receiveWidget=new QWidget(this);

    msgView = new QFrame( this );
    urlView = new QFrame( this );
    addView = new QFrame( this );
    buttonView = new QFrame( this );

    
    msgView->setGeometry( 0, 0, 450, 260 );

    msgGroup = new QButtonGroup( msgView );
    msgGroup->setGeometry( 5, 5, 440, 255 );
    msgGroup->setTitle( i18n("Message :") );
    QLabel *uinL = new QLabel( msgView );
    uinL->setGeometry( 15, 25, 40, 20 );
    uinL->setText(  i18n("Uin:") );
    uinL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewUin = new QLabel( msgView );
    msgViewUin->setGeometry( 57, 25, 125, 20 );
    msgViewUin->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *nickL = new QLabel( msgView );
    nickL->setGeometry( 15, 47, 40, 20 );
    nickL->setText(  i18n("Nick:") );
    nickL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewNick = new QLabel( msgView );
    msgViewNick->setGeometry( 57, 47, 125, 20 );
    msgViewNick->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *dateL = new QLabel( msgView );
    dateL->setGeometry( 195, 25, 40, 20 );
    dateL->setText(  i18n("Date:") );
    dateL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewDate = new QLabel( msgView );
    msgViewDate->setGeometry( 237, 25, 75, 20 );
    msgViewDate->setFrameStyle( QFrame::Raised | QFrame::Panel );
    QLabel *timeL = new QLabel( msgView );
    timeL->setGeometry( 195, 47, 40, 20 );
    timeL->setText(  i18n("Time:") );
    timeL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewTime = new QLabel( msgView );
    msgViewTime->setGeometry( 237, 47, 75, 20 );
    msgViewTime->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *readL = new QLabel( msgView );
    readL->setGeometry( 322, 25, 50, 20 );
    readL->setText(  i18n("Read:") );
    readL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewRead = new QCheckBox( msgView );
    msgViewRead->setGeometry( 377, 25, 20, 20 );
    msgViewRead->setEnabled( FALSE );

    QLabel *cL = new QLabel( msgView );
    cL->setGeometry( 322, 47, 50, 20 );
    cL->setText(  i18n("Count:") );
    cL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    msgViewCount = new QLabel( msgView );
    msgViewCount->setGeometry( 377, 47, 55, 20 );
    msgViewCount->setFrameStyle( QFrame::Raised | QFrame::Panel );
    msgViewCount->setAlignment( AlignCenter );

    msgViewMsg = new MLEditWrap( TRUE, msgView );
    msgViewMsg->setGeometry( 15, 73, 420, 180 );
    msgViewMsg->setReadOnly( TRUE );
    /////////////////////////////////////////////////////////////

    urlView->setGeometry( 0, 0, 450, 260 );
    urlGroup = new QButtonGroup( urlView );
    urlGroup->setGeometry( 5, 5, 440, 255 );
    urlGroup->setTitle(  i18n("URL :") );
    QLabel *uinLu = new QLabel( urlView );
    uinLu->setGeometry( 15, 25, 40, 20 );
    uinLu->setText(  i18n("Uin:") );
    uinLu->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewUin = new QLabel( urlView );
    urlViewUin->setGeometry( 57, 25, 125, 20 );
    urlViewUin->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *nickLu = new QLabel( urlView );
    nickLu->setGeometry( 15, 47, 40, 20 );
    nickLu->setText(  i18n("Nick:") );
    nickLu->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewNick = new QLabel( urlView );
    urlViewNick->setGeometry( 57, 47, 125, 20 );
    urlViewNick->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *dateLu = new QLabel( urlView );
    dateLu->setGeometry( 195, 25, 40, 20 );
    dateLu->setText(  i18n("Date:") );
    dateLu->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewDate = new QLabel( urlView );
    urlViewDate->setGeometry( 237, 25, 75, 20 );
    urlViewDate->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *timeLu = new QLabel( urlView );
    timeLu->setGeometry( 195, 47, 40, 20 );
    timeLu->setText(  i18n("Time:") );
    timeLu->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewTime = new QLabel( urlView );
    urlViewTime->setGeometry( 237, 47, 75, 20 );
    urlViewTime->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *readLu = new QLabel( urlView );
    readLu->setGeometry( 322, 25, 50, 20 );
    readLu->setText(  i18n("Read:") );
    readLu->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewRead = new QCheckBox( urlView );
    urlViewRead->setGeometry( 377, 25, 20, 20 );
    urlViewRead->setEnabled( FALSE );

    QLabel *uL = new QLabel( urlView );
    uL->setGeometry( 322, 47, 50, 20 );
    uL->setText(  i18n("Count:") );
    uL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewCount = new QLabel( urlView );
    urlViewCount->setGeometry( 377, 47, 55, 20 );
    urlViewCount->setFrameStyle( QFrame::Raised | QFrame::Panel );
    urlViewCount->setAlignment( AlignCenter );



    urlViewMsg = new MLEditWrap( TRUE, urlView );
    urlViewMsg->setGeometry( 15, 97, 420, 156 );
    urlViewMsg->setReadOnly( TRUE );

    urlViewUrl = new KURLLabel( urlView );
    urlViewUrl->setGeometry( 15, 73, 420, 20 );
    urlViewUrl->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    urlViewUrl->setTipText(  i18n("Open this URL") );
    urlViewUrl->setUseTips( TRUE );
    connect( urlViewUrl, SIGNAL( leftClickedURL( const char* ) ), this, SLOT( processURL( const char* ) ) );



    /////////////////////////////////////////////////////////////
    addView->setGeometry( 0, 0, 450, 260 );

    addGroup = new QButtonGroup( addView );
    addGroup->setGeometry( 5, 5, 440, 255 );
    addGroup->setTitle(  i18n("Uin :") );
    QLabel *uinLa = new QLabel( addView );
    uinLa->setGeometry( 15, 25, 40, 20 );
    uinLa->setText(  i18n("Uin:") );
    uinLa->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewUin = new QLabel( addView );
    addViewUin->setGeometry( 57, 25, 125, 20 );
    addViewUin->setFrameStyle( QFrame::Raised | QFrame::Panel );
    QLabel *nickLa = new QLabel( addView );
    nickLa->setGeometry( 15, 47, 40, 20 );
    nickLa->setText(  i18n("Nick:") );
    nickLa->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewNick = new QLabel( addView );
    addViewNick->setGeometry( 57, 47, 125, 20 );
    addViewNick->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *dateLa = new QLabel( addView );
    dateLa->setGeometry( 195, 25, 40, 20 );
    dateLa->setText(  i18n("Date:") );
    dateLa->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewDate = new QLabel( addView );
    addViewDate->setGeometry( 237, 25, 75, 20 );
    addViewDate->setFrameStyle( QFrame::Raised | QFrame::Panel );
    QLabel *timeLa = new QLabel( addView );
    timeLa->setGeometry( 195, 47, 40, 20 );
    timeLa->setText(  i18n("Time:") );
    timeLa->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewTime = new QLabel( addView );
    addViewTime->setGeometry( 237, 47, 75, 20 );
    addViewTime->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *readLa = new QLabel( addView );
    readLa->setGeometry( 322, 25, 50, 20 );
    readLa->setText(  i18n("Read:") );
    readLa->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewRead = new QCheckBox( addView );
    addViewRead->setGeometry( 377, 25, 20, 20 );
    addViewRead->setEnabled( FALSE );



    QLabel *aL = new QLabel( addView );
    aL->setGeometry( 322, 47, 50, 20 );
    aL->setText(  i18n("Count:") );
    aL->setFrameStyle( QFrame::Sunken | QFrame::Panel );
    addViewCount = new QLabel( addView );
    addViewCount->setGeometry( 377, 47, 55, 20 );
    addViewCount->setFrameStyle( QFrame::Raised | QFrame::Panel );
    addViewCount->setAlignment( AlignCenter );

    addBg = new QButtonGroup( addView );
    addBg->setGeometry( 15, 73, 420, 180 );
    addBg->setTitle(  i18n("You are added by") );



    QLabel *Fa = new QLabel( addView );
    Fa->setGeometry( 25, 93, 63, 20 );
    Fa->setText(  i18n("Nick:") );
    Fa->setFrameStyle( QFrame::Sunken | QFrame::Panel );

    addViewrNick = new QLabel( addView );
    addViewrNick->setGeometry( 95, 93, 150, 20 );
    addViewrNick->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *La = new QLabel( addView );
    La->setGeometry( 25, 118, 63, 20 );
    La->setText(  i18n("Firstname:") );
    La->setFrameStyle( QFrame::Sunken | QFrame::Panel );

    addViewFirst = new QLabel( addView );
    addViewFirst->setGeometry( 95, 118, 150, 20 );
    addViewFirst->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *Lna = new QLabel( addView );
    Lna->setGeometry( 25, 143, 63, 20 );
    Lna->setText(  i18n("Lastname:") );
    Lna->setFrameStyle( QFrame::Sunken | QFrame::Panel );

    addViewLast = new QLabel( addView );
    addViewLast->setGeometry( 95, 143, 150, 20 );
    addViewLast->setFrameStyle( QFrame::Raised | QFrame::Panel );

    QLabel *Ea = new QLabel( addView );
    Ea->setGeometry( 25, 168, 63, 20 );
    Ea->setText(  i18n("E-Mail:") );
    Ea->setFrameStyle( QFrame::Sunken | QFrame::Panel );

    addViewEmail = new QLabel( addView );
    addViewEmail->setGeometry( 95, 168, 150, 20 );
    addViewEmail->setFrameStyle( QFrame::Raised | QFrame::Panel );

    authButton=new QPushButton(addView);
    authButton->setGeometry(255,168, 150,20);
    authButton->setText( i18n("Authorize"));
    connect( authButton, SIGNAL( clicked() ), SLOT( auth_slot() ) );

    authText = new MLEditWrap( TRUE, addView );
    authText->setGeometry( 25, 193, 400, 50 );
    authText->setReadOnly( TRUE );


    /////////////////////////////////////////////////////
    buttonView->setGeometry( 0, 261, 450, 39 );

    okButton = new QPushButton( buttonView );
    okButton->setGeometry( 5, 5, 75, 30 );
    okButton->setText(  i18n("Ok") );
    connect( okButton, SIGNAL( clicked() ), SLOT( ok_slot() ) );

    whoisButton = new QPushButton( buttonView );
    whoisButton->setGeometry( 85, 5, 75, 15 );
    whoisButton->setText(  i18n("Whois") );
    connect( whoisButton, SIGNAL( clicked() ), SLOT( whois_slot() ) );

    addButton = new QPushButton( buttonView );
    addButton->setGeometry( 85, 21, 75, 15 );
    addButton->setText(  i18n("Add user") );
    connect( addButton, SIGNAL( clicked() ), SLOT( addUser() ) );

    replyButton = new QPushButton( buttonView );
    replyButton->setGeometry( 165, 5, 75, 30 );
    replyButton->setText( i18n( "Reply") );
    connect( replyButton, SIGNAL( clicked() ), SLOT( reply_slot() ) );

    nextButton = new QPushButton( buttonView );
    nextButton->setGeometry( 335, 5, 50, 15 );
    nextButton->setText(  i18n("Next") );
    connect( nextButton, SIGNAL( clicked() ), SLOT( next_slot() ) );
    prevButton = new QPushButton( buttonView );
    prevButton->setGeometry( 335, 21, 50, 15 );
    prevButton->setText(  i18n("Prev") );
    connect( prevButton, SIGNAL( clicked() ), SLOT( prev_slot() ) );
    nextUButton = new QPushButton( buttonView );
    nextUButton->setGeometry( 390, 5, 50, 15 );
    nextUButton->setText( i18n( "Next Unread") );
    connect( nextUButton, SIGNAL( clicked() ), SLOT( next_u_slot() ) );
    prevUButton = new QPushButton( buttonView );
    prevUButton->setGeometry( 390, 21, 50, 15 );
    prevUButton->setText( i18n( "Prev Unread") );
    connect( prevUButton, SIGNAL( clicked() ), SLOT( prev_u_slot() ) );

    firstButton = new QPushButton( buttonView );
    firstButton->setGeometry( 280, 5, 50, 15 );
    firstButton->setText( i18n( "First") );
    connect( firstButton, SIGNAL( clicked() ), SLOT( first_slot() ) );
    lastButton = new QPushButton( buttonView );
    lastButton->setGeometry( 280, 21, 50, 15 );
    lastButton->setText(  i18n("Last") );
    connect( lastButton, SIGNAL( clicked() ), SLOT( last_slot() ) );



    urlView->hide();
    addView->hide();
    msgView->show();
    found = 0;
    wait = 0;
    view = 0;

    count = 0;
    aant = countMsg();
    lastMsg();
    if ( found == 0 ) reject();
    else
    {
        showMsg();
        msgView->show();
        buttonView->show();
        //	 show();
    }

//    addTab(receiveWidget,"Reveived Messages");

//    QWidget *sendWidget=new QWidget(this);

//    addTab(sendWidget,"Send Messages");

//    QWidget *historyWidget=new QWidget(this);

//    addTab(historyWidget,"History List");

//    receiveWidget->show();

    
    //tabbar->show();
//    show();

}
Read::~Read()
{
}

void Read::processURL( const char *url )
{
    // printf ("%s\n",url);
    if ( strcmp(KxicqConfig.browser,"kfmclient %u")==0 )
    {
        QString tmp;
        if (strncmp(url,"http",4)!=0 && strncmp(url,"ftp",3)!=0)
        {
            tmp.sprintf( "kfmclient openURL \"http://%s\"", url );
        }
        else
        {
            tmp.sprintf( "kfmclient openURL \"%s\"", url );
        }
        system( tmp.data() );
        return;
    }
    else
    {
        char * tmp;
        tmp = ( char * ) malloc( 1024 );
        sprintf( tmp, "netscape %s &", url );
        system( tmp );
        if (tmp) free( tmp );
    }

}

void Read::showMsg()
{
//    MESSAGE msg;
//    URL url;
    //    ADDED add;
    MSGf msg;
    QString tmp( BUFSIZE + 1 );
    QString tmp1( BUFSIZE + 1 );
    QString tmp2( BUFSIZE + 1 );
    QString tmp3( BUFSIZE + 1 );
    QString tmp4( BUFSIZE + 1 );
    QString tmp5( BUFSIZE + 1 );
    QString tmp6( BUFSIZE + 1 );
    QString C( 50 );
    addButton->setEnabled( True );
    CONTACT contact;
    for ( int t = 0; t < contact_length(); t++ )
    {
        contact = contact_returnItemNum( t );
        if ( uin == contact.uin )
        {
            addButton->setEnabled( False );
        }
    }

    pntMsg->getMessage(&msg);
    if (pntMsg->getRead()==0) pntMsg->setRead( 1 );
    dockView->setStatus( mainW->currentStatus );
    char *tmpmsg=(char *)malloc(strlen(msg.message)*2);

    
    //   printf("VIEW[%d][%d]\n",pntMsg->getType(),pntMsg->getUin());
    switch ( msg.type )
    {
    case TYPE_MSG:
        if (pntMsg->getRead()==2)
        {
            msgGroup->setTitle( i18n("Send Message:") );
            QColor color;
            color.setRgb(255,0,0);
            QColorGroup cg( msgViewMsg->palette().normal().foreground(), msgViewMsg->palette().normal().background(),
                    msgViewMsg->palette().normal().light(),
                    msgViewMsg->palette().normal().dark(),
                    msgViewMsg->palette().normal().mid(),
                            KxicqConfig.messageSendText,
                            KxicqConfig.messageSendBack

                  );
            msgViewMsg->setPalette( QPalette( cg, msgViewMsg->palette().disabled(), cg ) );
            replyButton->setText( i18n( "Send to") );
        }
        else
        {
            msgGroup->setTitle( i18n("Reveived Message:") );
            QColor color;
            color.setRgb(255,0,0);
            QColorGroup cg( msgViewMsg->palette().normal().foreground(), msgViewMsg->palette().normal().background(),
                    msgViewMsg->palette().normal().light(),
                    msgViewMsg->palette().normal().dark(),
                    msgViewMsg->palette().normal().mid(),
                    kapp->textColor,
                    kapp->windowColor
                  );
            msgViewMsg->setPalette( QPalette( cg, msgViewMsg->palette().disabled(), cg ) );
            replyButton->setText( i18n( "Reply") );
        }

            //	 printf("MSG VIEW\n");
            tmp1.sprintf( "%d", pntMsg->getUin() );
            msgViewUin->setText( tmp1.data() );
            msgViewNick->setText( contact_uin2nick( pntMsg->getUin() ) );

            tmp2.sprintf( "%02d/%02d/%d", msg.time.month, msg.time.day, msg.time.year );
            msgViewDate->setText( tmp2.data() );
            tmp3.sprintf( "%2d:%02d", msg.time.hour, msg.time.min );
            msgViewTime->setText( tmp3.data() );
            msgViewRead->setChecked( pntMsg->getRead() == 0 ? FALSE : TRUE );
            addViewrNick->setText( "" );
            C.sprintf( "%d/%d", count, aant );
            msgViewCount->setText( C.data() );
            msgViewMsg->clear();
            
            strcpy(tmpmsg,msg.message);
            config2dos(tmpmsg,strlen(msg.message));
            tmp4.sprintf( "%s", tmpmsg );
            

            msgViewMsg->hide();
            msgViewMsg->append( tmp4.data() );
            msgViewMsg->show();
            //msgView->repaint();
            if ( view != TYPE_MSG )
            {
                urlView->hide();
                msgView->show();
                addView->hide();
                view = TYPE_MSG;
            }
            
            break;

        case TYPE_URL:
            //	 printf("URL VIEW\n");
        if (pntMsg->getRead()==2)
        {
            urlGroup->setTitle( i18n("Send URL:") );
            QColor color;
            color.setRgb(255,0,0);
            QColorGroup cg( urlViewMsg->palette().normal().foreground(), urlViewMsg->palette().normal().background(),
                    urlViewMsg->palette().normal().light(),
                    urlViewMsg->palette().normal().dark(),
                    urlViewMsg->palette().normal().mid(),
                            KxicqConfig.messageSendText,
                            KxicqConfig.messageSendBack

                  );
            urlViewMsg->setPalette( QPalette( cg, urlViewMsg->palette().disabled(), cg ) );
            urlViewUrl->setPalette( QPalette( cg, urlViewMsg->palette().disabled(), cg ) );
            replyButton->setText( i18n( "Send to") );
        }
        else
        {
            urlGroup->setTitle( i18n("Reveived URL:") );
            QColor color;
            color.setRgb(255,0,0);
            QColorGroup cg( urlViewMsg->palette().normal().foreground(), urlViewMsg->palette().normal().background(),
                    urlViewMsg->palette().normal().light(),
                    urlViewMsg->palette().normal().dark(),
                    urlViewMsg->palette().normal().mid(),
                    kapp->textColor,
                    kapp->windowColor
                  );
            urlViewMsg->setPalette( QPalette( cg, urlViewMsg->palette().disabled(), cg ) );
            urlViewUrl->setPalette( QPalette( cg, urlViewMsg->palette().disabled(), cg ) );
            replyButton->setText( i18n( "Reply") );
        }


            tmp1.sprintf( "%d", pntMsg->getUin() );
            urlViewUin->setText( tmp1.data() );

            urlViewNick->setText( contact_uin2nick( pntMsg->getUin() ) );
            tmp2.sprintf( "%02d/%02d/%d", msg.time.month, msg.time.day, msg.time.year );
            urlViewDate->setText( tmp2.data() );
            tmp3.sprintf( "%2d:%02d", msg.time.hour, msg.time.min );
            urlViewTime->setText( tmp3.data() );
            urlViewRead->setChecked( pntMsg->getRead() == 0 ? FALSE : TRUE );
            tmp4.sprintf( "%s", msg.url );
            urlViewUrl->setText( tmp4.data() );
            tmp5.sprintf( "%s", msg.url );
            urlViewUrl->setURL( tmp5.data() );
            addViewrNick->setText( "" );

            C.sprintf( "%d/%d", count, aant );
            urlViewCount->setText( C.data() );

            urlViewMsg->clear();
            //nfig2dos(msg.message,strlen(msg.message));
            tmp.sprintf( "%s", msg.message );
            urlViewMsg->hide();
            urlViewMsg->append( tmp.data() );
            urlViewMsg->show();

            if ( view != TYPE_URL )
            {
                msgView->hide();
                urlView->show();
                addView->hide();
                view = TYPE_URL;
            }

            break;
    case TYPE_ADDED:
    case 4:
            //       printf("ADD VIEW\n");
            tmp.sprintf( "%d", pntMsg->getUin() );
            addViewUin->setText( tmp.data() );
            addViewNick->setText( contact_uin2nick( pntMsg->getUin() ) );
            tmp1.sprintf( "%02d/%02d/%d", msg.time.month, msg.time.day, msg.time.year );
            addViewDate->setText( tmp1.data() );
            tmp2.sprintf( "%2d:%02d", msg.time.hour, msg.time.min );
            addViewTime->setText( tmp2.data() );
            addViewRead->setChecked( pntMsg->getRead() == 0 ? FALSE : TRUE );

            tmp3.sprintf( "%s", msg.firstName );
            addViewFirst->setText( tmp3.data() );
            tmp4.sprintf( "%s", msg.lastName );
            addViewLast->setText( tmp4.data() );
            tmp5.sprintf( "%s", msg.nick );
            addViewrNick->setText( tmp5.data() );
            tmp6.sprintf( "%s", msg.email );
            addViewEmail->setText( tmp6.data() );
            C.sprintf( "%d/%d", count, aant );
            addViewCount->setText( C.data() );

//            ADDED added=pntMsg->getAdded();
            if (msg.type==4)
            {
                authButton->setEnabled(TRUE);
                QString tmp;
                //config2dos(msg.message,strlen(msg.message));
                tmp.sprintf("%s",msg.message);
                authText->clear();
                authText->append(tmp.data());
                authButton->show();
                authText->show();
                addBg->setTitle(  i18n("You are ask to Authorize this person") );
            }
            else
            {
                //authButton->setEnabled(FALSE);
                authButton->hide();
                authText->hide();
                addBg->setTitle(  i18n("You are added by") );
            }
            msgView->hide();
            urlView->hide();
            addView->show();
            view = TYPE_ADDED;

            break;
    }
            if (msg.url) free(msg.url);
            if (msg.nick) free(msg.nick);
            if (msg.firstName) free(msg.firstName);
            if (msg.lastName) free(msg.lastName);
            if (msg.email) free(msg.email);
            if (msg.message) free(msg.message);
            if (tmpmsg) free(tmpmsg);
            if (pntMsg->getRead()==0) pntMsg->setRead( 1 );
}

unsigned long Read::countMsg()
{
    UIN aant = 0;
    MSG *pntMsg2;
    if ( wait == 0 )
    {
        wait = 1;
        if ( uin != TYPE_SERVER )
        {
            for ( pntMsg2 = userMsg.first(); pntMsg2; pntMsg2 = userMsg.next() )
            {
                if ( pntMsg2->getUin() == uin )
                {
                    aant++;
                }
            }
        }
        else
        {
            for ( pntMsg2 = userMsg.first(); pntMsg2; pntMsg2 = userMsg.next() )

            {
                if ( pntMsg2->getUin() == ( UIN ) atoi( contact_uin2nick( pntMsg2->getUin() ) ) )
                {
                    aant++;
                }
            }
        }
        wait = 0;
    }
    return aant;
}

void Read::firstMsg()
{
    count = 1;
    if ( wait == 0 )
    {
        wait = 1;
        if ( uin != TYPE_SERVER )
        {
            for ( pntMsg = userMsg.first(); pntMsg != 0; pntMsg = userMsg.next() )
            {
                if ( pntMsg->getUin() == uin )
                {
                    wait = 0;
                    found = 1;
                    return;
                }
            }
        }
        else
        {
            for ( pntMsg = userMsg.first(); pntMsg != 0; pntMsg = userMsg.next() )
            {
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) )
                {
                    wait = 0;
                    found = 1;
                    return;
                }
            }
        }
            
        found = 0;
        wait = 0;
    }
}

void Read::lastMsg()
{
    count = aant;
    if ( wait == 0 )
    {
        wait = 1;
        if ( uin != TYPE_SERVER )
        {
            if ( KxicqConfig.showLastUnread )
            {
                for ( pntMsg = userMsg.last(); pntMsg != 0; pntMsg = userMsg.prev() )
                {
                    if ( pntMsg->getUin() == uin && pntMsg->getRead() == 0 )
                    {
                        wait = 0;
                        found = 1;
                        return;
                    }
                }
            }
            for ( pntMsg = userMsg.last(); pntMsg != 0; pntMsg = userMsg.prev() )
            {
                if ( pntMsg->getUin() == uin )
                {
                    wait = 0;
                    found = 1;
                    return;
                }
            }

        }
        else
        {
            if ( KxicqConfig.showLastUnread )
            {
                for ( pntMsg = userMsg.last(); pntMsg != 0; pntMsg = userMsg.prev() )
                {
                    if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) && pntMsg->getRead() == 0 )
                    {
                        wait = 0;
                        found = 1;
                        return;
                    }
                }
            }
            for ( pntMsg = userMsg.last(); pntMsg != 0; pntMsg = userMsg.prev() )
            {
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) )
                {
                    wait = 0;
                    found = 1;
                    return;
                }
            }

        }

        found = 0;
        wait = 0;
    }
}

void Read::prevMsg()
{
    if ( wait == 0 )
    {
        userMsg.find( pntMsg );
        wait = 1;
        MSG *old;
        old = pntMsg;
        if ( uin != TYPE_SERVER )
        {
            //	 printf("FF[%d]\n", pntMsg->getUin());
            while ( !( userMsg.current() == userMsg.getFirst() ) )
            {
                //    printf("PREV\n");
                pntMsg = userMsg.prev();
                //    printf("SetPREV[%d]\n",pntMsg->getUin());
                if ( pntMsg->getUin() == uin )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count--;
                    return;
                }
            }
        }
        else
        {
            while ( !( userMsg.current() == userMsg.getFirst() ) )
            {
                pntMsg = userMsg.prev();
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count--;
                    return;
                }
            }
        }


        pntMsg = old;
        found = 0;
        wait = 0;
    }
}

void Read::nextMsg()
{
    if ( wait == 0 )
    {
        userMsg.find( pntMsg );
        wait = 1;
        MSG *old;
        old = pntMsg;
        if ( uin != TYPE_SERVER )
        {
            while ( !( userMsg.current() == userMsg.getLast() ) )
            {
                pntMsg = userMsg.next();
                if ( pntMsg->getUin() == uin )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count++;
                    return;
                }
            }
        }
        else
        {
            while ( !( userMsg.current() == userMsg.getLast() ) )
            {
                pntMsg = userMsg.next();
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                     wait = 0;
                    found = 1;
                    count++;
                    return;
                }
            }
        }
        pntMsg = old;
        found = 0;
        wait = 0;
    }
}
void Read::prevUMsg()
{
    if ( wait == 0 )
    {
        userMsg.find( pntMsg );
        wait = 1;
        MSG *old;
        UIN oc = count;
        old = pntMsg;
        if ( uin != TYPE_SERVER )
        {
            //	 printf("FF[%d]\n", pntMsg->getUin());
            while ( !( userMsg.current() == userMsg.getFirst() ) )
            {
                //    printf("PREV\n");
                pntMsg = userMsg.prev();
                //    printf("SetPREV[%d]\n",pntMsg->getUin());
                if ( pntMsg->getUin() == uin && pntMsg->getRead() == 0 )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count--;
                    return;
                }
                if ( pntMsg->getUin() == uin ) count--;
            }
        }
        else
        {
            while ( !( userMsg.current() == userMsg.getFirst() ) )
            {
                pntMsg = userMsg.prev();
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) && pntMsg->getRead() == 0 )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count--;
                    return;
                }
                if ( pntMsg->getUin() == uin ) count--;
            }
        }


        pntMsg = old;
        count = oc;
        found = 0;
        wait = 0;
    }
}

void Read::nextUMsg()
{
    if ( wait == 0 )
    {
        userMsg.find( pntMsg );
        wait = 1;
        MSG *old;

        UIN oc = count;
        old = pntMsg;
        if ( uin != TYPE_SERVER )
        {
            while ( !( userMsg.current() == userMsg.getLast() ) )
            {
                pntMsg = userMsg.next();
                if ( pntMsg->getUin() == uin && pntMsg->getRead() == 0 )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                     wait = 0;
                    found = 1;
                    count++;
                    return;
                }
                if ( pntMsg->getUin() == uin ) count++;
            }
        }
        else
        {
            while ( !( userMsg.current() == userMsg.getLast() ) )
            {
                pntMsg = userMsg.next();
                if ( pntMsg->getUin() == ( UIN ) atol( contact_uin2nick( pntMsg->getUin() ) ) && pntMsg->getRead() == 0 )
                {
                    if (pntMsg->getRead()==0) old->setRead( 1 );
                    wait = 0;
                    found = 1;
                    count++;
                    return;
                }
                if ( pntMsg->getUin() == uin ) count++;
            }
        }
        count = oc;
        pntMsg = old;
        found = 0;
        wait = 0;
    }
}



////////// SLOTS ///////////////////////////////////

void Read::auth_slot()
{
    if (pntMsg->getUin())
    {
        if ( logged_on==1 ) send_auth(pntMsg->getUin()); else loggedon();
        
    }
}

void Read::addUser()
{
    //  printf("uin: %d, nick: %s\n",pntMsg->getUin(), pntMsg->getrNick());
    MSGf msg;
    pntMsg->getMessage(&msg);
    if ( msg.nick )
    {
        p->addUser( msg.nick, pntMsg->getUin() );
    }
    else
    {
        QString tmp;
        tmp.sprintf( "%d", pntMsg->getUin() );
        p->addUser( tmp.data(), pntMsg->getUin() );
    }
}


void Read::ok_slot()
{
    dockView->setStatus( mainW->currentStatus );

    if (this) delete this;
}
void Read::cancel_slot()
{
    reject();
}
void Read::reply_slot()
{
    sendDialog *myMsgWin;
    myMsgWin = new sendDialog( pntMsg->getUin(), SEND_MSG, mainW, "msgedit" );
    myMsgWin->setCaption( i18n( "Send Message to:" ) );
    if ( !myMsgWin->exec() )
    {
        return;
    }
    mainApp->processEvents();
    mainApp->flushX();

    if (myMsgWin) delete myMsgWin;
}
void Read::whois_slot()
{
    if ( logged_on==1 ) infoRequest( pntMsg->getUin() ); else loggedon();
}
void Read::next_slot()
{
    nextMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}
void Read::prev_slot()
{
    prevMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}
void Read::next_u_slot()
{
    nextUMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}
void Read::prev_u_slot()
{
    prevUMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}
void Read::first_slot()
{
    firstMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}
void Read::last_slot()
{
    lastMsg();
    dockView->setStatus( mainW->currentStatus );
    showMsg();
}

void Read::newMsg()
{
    //   aant=countMsg();
    dockView->setStatus( mainW->currentStatus );
    aant = 0;
    showMsg();
}


viewSearch::viewSearch( QWidget *parent = 0, const char *name = 0 )
        : KTabListBox( parent, name, 5 )
{
    setColumn( 0,  i18n("UIN"), 100 );
    setColumn( 1,  i18n("Nick"), 100 );
    setColumn( 2,  i18n("E-Mail"), 100 );
    setColumn( 3,  i18n("First Name"), 100 );
    setColumn( 4,  i18n("Last Name"), 100 );
    show();
}

viewSearch::~viewSearch()
{
    //  printf("close2\n");
    isViewSearch = 0;
    viewS = NULL;
};

int viewSearch::addItem( UIN uin, const char *email, const char *nick, const char *first, const char *last )
{
    QString tmp;
    tmp.sprintf( "%d", uin );
    KTabListBox::lbox.installEventFilter( this );
    pos = 0;
    pm = new QPopupMenu();
    pm->insertItem(  i18n("&Add user"), this, SLOT( addUser() ) );
    pm->insertItem(  i18n("&View user"), this, SLOT( doSearch() ) );

    insertItem( tmp.data(), -1 );
    setCurrentItem( count() - 1 );
    changeItemPart( nick, currentItem(), 3 );
    changeItemPart( email, currentItem(), 1 );
    changeItemPart( first, currentItem(), 4 );
    changeItemPart( last, currentItem(), 2 );
    connect( this, SIGNAL( selected( int, int ) ), SLOT( mouseDoubleClick( int, int ) ) );
    return 0;
}

void viewSearch::addUser()
{
    int go = 0;
    CONTACT contact;
    for ( int t = 0; t < contact_length(); t++ )
    {
        contact = contact_returnItemNum( t );
        if ( contact.uin == ( UIN ) atol( text( pos, 0 ) ) )
        {
            go = 1;
        }
    }
    if ( !go )
    {
        if ( text( pos, 1 ) )
            mainW->addUser( text( pos, 1 ), atol( text( pos, 0 ) ) );
        else
            mainW->addUser( text( pos, 0 ), atol( text( pos, 0 ) ) );
    }
}

void viewSearch::closeEvent( QCloseEvent * )
{
    //  printf("closeS");
    isViewSearch = 0;
    if (this) delete this;
    viewS = NULL;
}

bool viewSearch::eventFilter( QObject*, QEvent *e )
{
    if ( e->type() == Event_MouseButtonPress )
    {
        QMouseEvent * ev = ( QMouseEvent * ) e;
        doMousePressEvent( ev );
        return TRUE;
    }
    return FALSE;
}

void viewSearch::doSearch()
{
    if ( !isDoSearch && !userI )
    {
        isDoSearch = 1;
        send_infoReply( atol( text( pos, 0 ) ) );
    }
}

void viewSearch::mouseDoubleClick( int e, int )
{
    //   pos=e;
    pos = e;
    if ( !KxicqConfig.kdestyle )
    {
        doSearch();
    }
    //   showMsg();
}


void viewSearch::doMousePressEvent( QMouseEvent *e )
{
    int x, y;
    x = findCol( e->x() );
    y = findRow( e->y() );
    //   printf("%d -> %d\n",e->y(),y);
    //   hide();
    if ( y >= 0 && x >= 0 && y <= numRows() )
    {
        unmarkAll();
        markItem( y );
        //      activate_signal(activated(x,y));
        //      availList->unSelectAll(status);

        if ( e->button() == RightButton )
        {
            pos = y;
            pm->popup( QCursor::pos() );

        }
        if ( e->button() == MidButton )
        {
            // pos=y;
            // showMsg();
        }
        if ( e->button() == LeftButton && KxicqConfig.kdestyle)
        {
            doSearch();
        }
        repaint();
    }

}

searchDialog::searchDialog
(
    QWidget* parent,
    const char* name
)
        :
        QDialog( parent, name, TRUE )
{
    QButtonGroup * qtarch_ButtonGroup_1;
    qtarch_ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
    qtarch_ButtonGroup_1->setGeometry( 10, 10, 300, 200 );
    qtarch_ButtonGroup_1->setMinimumSize( 0, 0 );
    qtarch_ButtonGroup_1->setMaximumSize( 32767, 32767 );
    qtarch_ButtonGroup_1->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_1->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_1->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_1->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_1->setFrameStyle( 49 );
    qtarch_ButtonGroup_1->setAlignment( 1 );

    qtarch_LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
    qtarch_LineEdit_1->setGeometry( 90, 20, 200, 20 );
    qtarch_LineEdit_1->setMinimumSize( 0, 0 );
    qtarch_LineEdit_1->setMaximumSize( 32767, 32767 );
    qtarch_LineEdit_1->setFocusPolicy( QWidget::StrongFocus );
    qtarch_LineEdit_1->setBackgroundMode( QWidget::PaletteBase );
    qtarch_LineEdit_1->setFontPropagation( QWidget::NoChildren );
    qtarch_LineEdit_1->setPalettePropagation( QWidget::NoChildren );
    qtarch_LineEdit_1->setText( "" );
    qtarch_LineEdit_1->setMaxLength( 32767 );
    qtarch_LineEdit_1->setEchoMode( QLineEdit::Normal );
    qtarch_LineEdit_1->setFrame( TRUE );

    QLabel* qtarch_Nick;
    qtarch_Nick = new QLabel( this, "Nick" );
    qtarch_Nick->setGeometry( 20, 20, 40, 20 );
    qtarch_Nick->setMinimumSize( 0, 0 );
    qtarch_Nick->setMaximumSize( 32767, 32767 );
    qtarch_Nick->setFocusPolicy( QWidget::NoFocus );
    qtarch_Nick->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Nick->setFontPropagation( QWidget::NoChildren );
    qtarch_Nick->setPalettePropagation( QWidget::NoChildren );
    qtarch_Nick->setText(  i18n("Nick:") );
    qtarch_Nick->setAlignment( 289 );
    qtarch_Nick->setMargin( -1 );

    QLabel* qtarch_Label_2;
    qtarch_Label_2 = new QLabel( this, "Label_2" );
    qtarch_Label_2->setGeometry( 20, 50, 70, 20 );
    qtarch_Label_2->setMinimumSize( 0, 0 );
    qtarch_Label_2->setMaximumSize( 32767, 32767 );
    qtarch_Label_2->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_2->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_2->setText(  i18n("Firstname:") );
    qtarch_Label_2->setAlignment( 289 );
    qtarch_Label_2->setMargin( -1 );

    QLabel* qtarch_Label_3;
    qtarch_Label_3 = new QLabel( this, "Label_3" );
    qtarch_Label_3->setGeometry( 20, 80, 70, 20 );
    qtarch_Label_3->setMinimumSize( 0, 0 );
    qtarch_Label_3->setMaximumSize( 32767, 32767 );
    qtarch_Label_3->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_3->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_3->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_3->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_3->setText(  i18n("Lastname:") );
    qtarch_Label_3->setAlignment( 289 );
    qtarch_Label_3->setMargin( -1 );

    QLabel* qtarch_Label_4;
    qtarch_Label_4 = new QLabel( this, "Label_4" );
    qtarch_Label_4->setGeometry( 20, 110, 70, 20 );
    qtarch_Label_4->setMinimumSize( 0, 0 );
    qtarch_Label_4->setMaximumSize( 32767, 32767 );
    qtarch_Label_4->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_4->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_4->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_4->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_4->setText(  i18n("E-Mail:") );
    qtarch_Label_4->setAlignment( 289 );
    qtarch_Label_4->setMargin( -1 );
    QLabel* qtarch_Label_5;
    qtarch_Label_5 = new QLabel( this, "Label_5" );
    qtarch_Label_5->setGeometry( 20, 140, 70, 20 );
    qtarch_Label_5->setMinimumSize( 0, 0 );
    qtarch_Label_5->setMaximumSize( 32767, 32767 );
    qtarch_Label_5->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_5->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_5->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_5->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_5->setText(  i18n("UIN:" ));
    qtarch_Label_5->setAlignment( 289 );
    qtarch_Label_5->setMargin( -1 );


    qtarch_LineEdit_2 = new QLineEdit( this, "LineEdit_2" );
    qtarch_LineEdit_2->setGeometry( 90, 50, 200, 20 );
    qtarch_LineEdit_2->setMinimumSize( 0, 0 );
    qtarch_LineEdit_2->setMaximumSize( 32767, 32767 );
    qtarch_LineEdit_2->setFocusPolicy( QWidget::StrongFocus );
    qtarch_LineEdit_2->setBackgroundMode( QWidget::PaletteBase );
    qtarch_LineEdit_2->setFontPropagation( QWidget::NoChildren );
    qtarch_LineEdit_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_LineEdit_2->setText( "" );
    qtarch_LineEdit_2->setMaxLength( 32767 );
    qtarch_LineEdit_2->setEchoMode( QLineEdit::Normal );
    qtarch_LineEdit_2->setFrame( TRUE );
    qtarch_LineEdit_3 = new QLineEdit( this, "LineEdit_3" );
    qtarch_LineEdit_3->setGeometry( 90, 80, 200, 20 );
    qtarch_LineEdit_3->setMinimumSize( 0, 0 );
    qtarch_LineEdit_3->setMaximumSize( 32767, 32767 );
    qtarch_LineEdit_3->setFocusPolicy( QWidget::StrongFocus );
    qtarch_LineEdit_3->setBackgroundMode( QWidget::PaletteBase );
    qtarch_LineEdit_3->setFontPropagation( QWidget::NoChildren );
    qtarch_LineEdit_3->setPalettePropagation( QWidget::NoChildren );
    qtarch_LineEdit_3->setText( "" );
    qtarch_LineEdit_3->setMaxLength( 32767 );
    qtarch_LineEdit_3->setEchoMode( QLineEdit::Normal );
    qtarch_LineEdit_3->setFrame( TRUE );
    qtarch_LineEdit_4 = new QLineEdit( this, "LineEdit_4" );
    qtarch_LineEdit_4->setGeometry( 90, 110, 200, 20 );
    qtarch_LineEdit_4->setMinimumSize( 0, 0 );
    qtarch_LineEdit_4->setMaximumSize( 32767, 32767 );
    qtarch_LineEdit_4->setFocusPolicy( QWidget::StrongFocus );
    qtarch_LineEdit_4->setBackgroundMode( QWidget::PaletteBase );
    qtarch_LineEdit_4->setFontPropagation( QWidget::NoChildren );
    qtarch_LineEdit_4->setPalettePropagation( QWidget::NoChildren );
    qtarch_LineEdit_4->setText( "" );
    qtarch_LineEdit_4->setMaxLength( 32767 );
    qtarch_LineEdit_4->setEchoMode( QLineEdit::Normal );
    qtarch_LineEdit_4->setFrame( TRUE );

    qtarch_LineEdit_5 = new QLineEdit( this, "LineEdit_5" );
    qtarch_LineEdit_5->setGeometry( 90, 140, 200, 20 );
    qtarch_LineEdit_5->setMinimumSize( 0, 0 );
    qtarch_LineEdit_5->setMaximumSize( 32767, 32767 );
    qtarch_LineEdit_5->setFocusPolicy( QWidget::StrongFocus );
    qtarch_LineEdit_5->setBackgroundMode( QWidget::PaletteBase );
    qtarch_LineEdit_5->setFontPropagation( QWidget::NoChildren );
    qtarch_LineEdit_5->setPalettePropagation( QWidget::NoChildren );
    qtarch_LineEdit_5->setText( "" );
    qtarch_LineEdit_5->setMaxLength( 32767 );
    qtarch_LineEdit_5->setEchoMode( QLineEdit::Normal );
    qtarch_LineEdit_5->setFrame( TRUE );


    QPushButton* qtarch_searchButton;
    qtarch_searchButton = new QPushButton( this, "searchButton" );
    qtarch_searchButton->setGeometry( 110, 170, 100, 30 );
    qtarch_searchButton->setMinimumSize( 0, 0 );
    qtarch_searchButton->setMaximumSize( 32767, 32767 );
    qtarch_searchButton->setFocusPolicy( QWidget::TabFocus );
    qtarch_searchButton->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_searchButton->setFontPropagation( QWidget::NoChildren );
    qtarch_searchButton->setPalettePropagation( QWidget::NoChildren );
    qtarch_searchButton->setText(  i18n("Search") );
    qtarch_searchButton->setAutoRepeat( FALSE );
    qtarch_searchButton->setAutoResize( FALSE );

    qtarch_ButtonGroup_1->insert( qtarch_searchButton );
    connect( qtarch_searchButton, SIGNAL( clicked() ) , this, SLOT( startSearch() ) );
    resize( 320, 220 );
    setMinimumSize( 320, 220 );
    setMaximumSize( 320, 220 );
    //      show();
}


searchDialog::~searchDialog()
{
    searchD = NULL;
}

void searchDialog::startSearch()
{
    if ( strlen( qtarch_LineEdit_5->text() ) == 0 )
    {
        if ( !viewS )
        {
            viewS = new viewSearch();
            viewS->seq = send_userSearch(
                             qtarch_LineEdit_4->text(),
                             qtarch_LineEdit_1->text(),
                             qtarch_LineEdit_2->text(),
                             qtarch_LineEdit_3->text() );
        }
        else
            isViewSearch = 0;
    }
    else
    {
        if ( !isDoSearch && !userI )
        {
            isDoSearch = 1;
            send_infoReply( atol( qtarch_LineEdit_5->text() ) );
        }
        isViewSearch = 0;
    }
    close();
    //delete this;
}
void searchDialog::closeEvent( QCloseEvent * )
{
    isViewSearch = 0;
    if (this) delete this;
}

userInfo::userInfo
(
    QWidget* parent,
    const char* name
)
        :
        QDialog( parent, name, TRUE, 0 )
{
    QButtonGroup * qtarch_ButtonGroup_2;
    qtarch_ButtonGroup_2 = new QButtonGroup( this, "ButtonGroup_2" );
    qtarch_ButtonGroup_2->setGeometry( 10, 10, 450, 250 );
    qtarch_ButtonGroup_2->setMinimumSize( 0, 0 );
    qtarch_ButtonGroup_2->setMaximumSize( 32767, 32767 );
    qtarch_ButtonGroup_2->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_2->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setFrameStyle( 49 );
    qtarch_ButtonGroup_2->setAlignment( 1 );


    qtarch_uin = new QLineEdit( this, "uin" );
    qtarch_uin->setGeometry( 90, 20, 100, 20 );
    qtarch_uin->setMinimumSize( 0, 0 );
    qtarch_uin->setMaximumSize( 32767, 32767 );
    qtarch_uin->setFocusPolicy( QWidget::StrongFocus );
    qtarch_uin->setBackgroundMode( QWidget::PaletteBase );
    qtarch_uin->setFontPropagation( QWidget::NoChildren );
    qtarch_uin->setPalettePropagation( QWidget::NoChildren );
    qtarch_uin->setText( "" );
    qtarch_uin->setMaxLength( 32767 );
    qtarch_uin->setEchoMode( QLineEdit::Normal );
    qtarch_uin->setFrame( TRUE );
    //      qtarch_uin->setEchoMode( QLineEdit::NoEcho );

    QLabel* qtarch_Label_5;
    qtarch_Label_5 = new QLabel( this, "Label_5" );
    qtarch_Label_5->setGeometry( 20, 20, 70, 20 );
    qtarch_Label_5->setMinimumSize( 0, 0 );
    qtarch_Label_5->setMaximumSize( 32767, 32767 );
    qtarch_Label_5->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_5->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_5->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_5->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_5->setText(  i18n("UIN:") );
    qtarch_Label_5->setAlignment( 289 );
    qtarch_Label_5->setMargin( -1 );

    qtarch_nick = new QLineEdit( this, "nick" );
    qtarch_nick->setGeometry( 90, 50, 100, 20 );
    qtarch_nick->setMinimumSize( 0, 0 );
    qtarch_nick->setMaximumSize( 32767, 32767 );
    qtarch_nick->setFocusPolicy( QWidget::StrongFocus );
    qtarch_nick->setBackgroundMode( QWidget::PaletteBase );
    qtarch_nick->setFontPropagation( QWidget::NoChildren );
    qtarch_nick->setPalettePropagation( QWidget::NoChildren );
    qtarch_nick->setText( "" );
    qtarch_nick->setMaxLength( 32767 );
    qtarch_nick->setEchoMode( QLineEdit::Normal );
    qtarch_nick->setFrame( TRUE );
    //      qtarch_nick->setEchoMode( QLineEdit::NoEcho );

    QLabel* qtarch_Label_6;
    qtarch_Label_6 = new QLabel( this, "Label_6" );
    qtarch_Label_6->setGeometry( 20, 50, 70, 20 );
    qtarch_Label_6->setMinimumSize( 0, 0 );
    qtarch_Label_6->setMaximumSize( 32767, 32767 );
    qtarch_Label_6->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_6->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_6->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_6->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_6->setText(  i18n("Nick:") );
    qtarch_Label_6->setAlignment( 289 );
    qtarch_Label_6->setMargin( -1 );

    qtarch_firstName = new QLineEdit( this, "firstName" );
    qtarch_firstName->setGeometry( 90, 80, 140, 20 );
    qtarch_firstName->setMinimumSize( 0, 0 );
    qtarch_firstName->setMaximumSize( 32767, 32767 );
    qtarch_firstName->setFocusPolicy( QWidget::StrongFocus );
    qtarch_firstName->setBackgroundMode( QWidget::PaletteBase );
    qtarch_firstName->setFontPropagation( QWidget::NoChildren );
    qtarch_firstName->setPalettePropagation( QWidget::NoChildren );
    qtarch_firstName->setText( "" );
    qtarch_firstName->setMaxLength( 32767 );
    qtarch_firstName->setEchoMode( QLineEdit::Normal );
    qtarch_firstName->setFrame( TRUE );
    //      qtarch_firstName->setEchoMode( QLineEdit::NoEcho );

    qtarch_lastName = new QLineEdit( this, "lastName" );
    qtarch_lastName->setGeometry( 90, 110, 140, 20 );
    qtarch_lastName->setMinimumSize( 0, 0 );
    qtarch_lastName->setMaximumSize( 32767, 32767 );
    qtarch_lastName->setFocusPolicy( QWidget::StrongFocus );
    qtarch_lastName->setBackgroundMode( QWidget::PaletteBase );
    qtarch_lastName->setFontPropagation( QWidget::NoChildren );
    qtarch_lastName->setPalettePropagation( QWidget::NoChildren );
    qtarch_lastName->setText( "" );
    qtarch_lastName->setMaxLength( 32767 );
    qtarch_lastName->setEchoMode( QLineEdit::Normal );
    qtarch_lastName->setFrame( TRUE );
    //      qtarch_lastName->setEchoMode( QLineEdit::NoEcho );

    qtarch_email = new QLineEdit( this, "email" );
    qtarch_email->setGeometry( 90, 140, 140, 20 );
    qtarch_email->setMinimumSize( 0, 0 );
    qtarch_email->setMaximumSize( 32767, 32767 );
    qtarch_email->setFocusPolicy( QWidget::StrongFocus );
    qtarch_email->setBackgroundMode( QWidget::PaletteBase );
    qtarch_email->setFontPropagation( QWidget::NoChildren );
    qtarch_email->setPalettePropagation( QWidget::NoChildren );
    qtarch_email->setText( "" );
    qtarch_email->setMaxLength( 32767 );
    qtarch_email->setEchoMode( QLineEdit::Normal );
    qtarch_email->setFrame( TRUE );
    //      qtarch_email->setEchoMode( QLineEdit::NoEcho );

    qtarch_city = new QLineEdit( this, "city" );
    qtarch_city->setGeometry( 90, 200, 140, 20 );
    qtarch_city->setMinimumSize( 0, 0 );
    qtarch_city->setMaximumSize( 32767, 32767 );
    qtarch_city->setFocusPolicy( QWidget::StrongFocus );
    qtarch_city->setBackgroundMode( QWidget::PaletteBase );
    qtarch_city->setFontPropagation( QWidget::NoChildren );
    qtarch_city->setPalettePropagation( QWidget::NoChildren );
    qtarch_city->setText( "" );
    qtarch_city->setMaxLength( 32767 );
    qtarch_city->setEchoMode( QLineEdit::Normal );
    qtarch_city->setFrame( TRUE );
    //      qtarch_city->setEchoMode( QLineEdit::NoEcho );

    qtarch_auth = new QCheckBox( this, "auth" );
    qtarch_auth->setGeometry( 90, 160, 20, 30 );
    qtarch_auth->setMinimumSize( 0, 0 );
    qtarch_auth->setMaximumSize( 32767, 32767 );
    qtarch_auth->setFocusPolicy( QWidget::TabFocus );
    qtarch_auth->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_auth->setFontPropagation( QWidget::NoChildren );
    qtarch_auth->setPalettePropagation( QWidget::NoChildren );
    qtarch_auth->setText( "" );
    qtarch_auth->setAutoRepeat( FALSE );
    qtarch_auth->setAutoResize( FALSE );
    qtarch_auth->setEnabled( FALSE );

    qtarch_ccode = new QLineEdit( this, "ccode" );
    qtarch_ccode->setGeometry( 90, 230, 40, 20 );
    qtarch_ccode->setMinimumSize( 0, 0 );
    qtarch_ccode->setMaximumSize( 32767, 32767 );
    qtarch_ccode->setFocusPolicy( QWidget::StrongFocus );
    qtarch_ccode->setBackgroundMode( QWidget::PaletteBase );
    qtarch_ccode->setFontPropagation( QWidget::NoChildren );
    qtarch_ccode->setPalettePropagation( QWidget::NoChildren );
    qtarch_ccode->setText( "" );
    qtarch_ccode->setMaxLength( 32767 );
    qtarch_ccode->setEchoMode( QLineEdit::Normal );
    qtarch_ccode->setFrame( TRUE );
    //      qtarch_ccode->setEchoMode( QLineEdit::NoEcho );

    qtarch_state = new QLineEdit( this, "state" );
    qtarch_state->setGeometry( 130, 230, 100, 20 );
    qtarch_state->setMinimumSize( 0, 0 );
    qtarch_state->setMaximumSize( 32767, 32767 );
    qtarch_state->setFocusPolicy( QWidget::StrongFocus );
    qtarch_state->setBackgroundMode( QWidget::PaletteBase );
    qtarch_state->setFontPropagation( QWidget::NoChildren );
    qtarch_state->setPalettePropagation( QWidget::NoChildren );
    qtarch_state->setText( "" );
    qtarch_state->setMaxLength( 32767 );
    qtarch_state->setEchoMode( QLineEdit::Normal );
    qtarch_state->setFrame( TRUE );
    //      qtarch_state->setEchoMode( QLineEdit::NoEcho );

    qtarch_age = new QLineEdit( this, "age" );
    qtarch_age->setGeometry( 300, 20, 40, 20 );
    qtarch_age->setMinimumSize( 0, 0 );
    qtarch_age->setMaximumSize( 32767, 32767 );
    qtarch_age->setFocusPolicy( QWidget::StrongFocus );
    qtarch_age->setBackgroundMode( QWidget::PaletteBase );
    qtarch_age->setFontPropagation( QWidget::NoChildren );
    qtarch_age->setPalettePropagation( QWidget::NoChildren );
    qtarch_age->setText( "" );
    qtarch_age->setMaxLength( 32767 );
    qtarch_age->setEchoMode( QLineEdit::Normal );
    qtarch_age->setFrame( TRUE );
    //      qtarch_age->setEchoMode( QLineEdit::NoEcho );

    qtarch_sex = new QLineEdit( this, "sex" );
    qtarch_sex->setGeometry( 300, 50, 40, 20 );
    qtarch_sex->setMinimumSize( 0, 0 );
    qtarch_sex->setMaximumSize( 32767, 32767 );
    qtarch_sex->setFocusPolicy( QWidget::StrongFocus );
    qtarch_sex->setBackgroundMode( QWidget::PaletteBase );
    qtarch_sex->setFontPropagation( QWidget::NoChildren );
    qtarch_sex->setPalettePropagation( QWidget::NoChildren );
    qtarch_sex->setText( "" );
    qtarch_sex->setMaxLength( 32767 );
    qtarch_sex->setEchoMode( QLineEdit::Normal );
    qtarch_sex->setFrame( TRUE );
    //      qtarch_sex->setEchoMode( QLineEdit::NoEcho );

    qtarch_phone = new QLineEdit( this, "phone" );
    qtarch_phone->setGeometry( 300, 80, 100, 20 );
    qtarch_phone->setMinimumSize( 0, 0 );
    qtarch_phone->setMaximumSize( 32767, 32767 );
    qtarch_phone->setFocusPolicy( QWidget::StrongFocus );
    qtarch_phone->setBackgroundMode( QWidget::PaletteBase );
    qtarch_phone->setFontPropagation( QWidget::NoChildren );
    qtarch_phone->setPalettePropagation( QWidget::NoChildren );
    qtarch_phone->setText( "" );
    qtarch_phone->setMaxLength( 32767 );
    qtarch_phone->setEchoMode( QLineEdit::Normal );
    qtarch_phone->setFrame( TRUE );
    //      qtarch_phone->setEchoMode( QLineEdit::NoEcho );

    qtarch_homePage = new QLineEdit( this, "homePage" );
    qtarch_homePage->setGeometry( 300, 110, 150, 20 );
    qtarch_homePage->setMinimumSize( 0, 0 );
    qtarch_homePage->setMaximumSize( 32767, 32767 );
    qtarch_homePage->setFocusPolicy( QWidget::StrongFocus );
    qtarch_homePage->setBackgroundMode( QWidget::PaletteBase );
    qtarch_homePage->setFontPropagation( QWidget::NoChildren );
    qtarch_homePage->setPalettePropagation( QWidget::NoChildren );
    qtarch_homePage->setText( "" );
    qtarch_homePage->setMaxLength( 32767 );
    qtarch_homePage->setEchoMode( QLineEdit::Normal );
    qtarch_homePage->setFrame( TRUE );
    //      qtarch_homePage->setEchoMode( QLineEdit::NoEcho );

    qtarch_about = new QLineEdit( this, "about" );
    qtarch_about->setGeometry( 300, 140, 150, 20 );
    qtarch_about->setMinimumSize( 0, 0 );
    qtarch_about->setMaximumSize( 32767, 32767 );
    qtarch_about->setFocusPolicy( QWidget::StrongFocus );
    qtarch_about->setBackgroundMode( QWidget::PaletteBase );
    qtarch_about->setFontPropagation( QWidget::NoChildren );
    qtarch_about->setPalettePropagation( QWidget::NoChildren );
    qtarch_about->setText( "" );
    qtarch_about->setMaxLength( 32767 );
    qtarch_about->setEchoMode( QLineEdit::Normal );
    qtarch_about->setFrame( TRUE );
    //      qtarch_about->setEchoMode( QLineEdit::NoEcho );

    QLabel* qtarch_Label_7;
    qtarch_Label_7 = new QLabel( this, "Label_7" );
    qtarch_Label_7->setGeometry( 20, 80, 70, 20 );
    qtarch_Label_7->setMinimumSize( 0, 0 );
    qtarch_Label_7->setMaximumSize( 32767, 32767 );
    qtarch_Label_7->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_7->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_7->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_7->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_7->setText(  i18n("Firstname:") );
    qtarch_Label_7->setAlignment( 289 );
    qtarch_Label_7->setMargin( -1 );

    QLabel* qtarch_Label_8;
    qtarch_Label_8 = new QLabel( this, "Label_8" );
    qtarch_Label_8->setGeometry( 20, 110, 70, 20 );
    qtarch_Label_8->setMinimumSize( 0, 0 );
    qtarch_Label_8->setMaximumSize( 32767, 32767 );
    qtarch_Label_8->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_8->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_8->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_8->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_8->setText(  i18n("Lastname:") );
    qtarch_Label_8->setAlignment( 289 );
    qtarch_Label_8->setMargin( -1 );

    QLabel* qtarch_Label_9;
    qtarch_Label_9 = new QLabel( this, "Label_9" );
    qtarch_Label_9->setGeometry( 20, 140, 70, 20 );
    qtarch_Label_9->setMinimumSize( 0, 0 );
    qtarch_Label_9->setMaximumSize( 32767, 32767 );
    qtarch_Label_9->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_9->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_9->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_9->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_9->setText(  i18n("E-Mail:") );
    qtarch_Label_9->setAlignment( 289 );
    qtarch_Label_9->setMargin( -1 );

    QLabel* qtarch_Label_10;
    qtarch_Label_10 = new QLabel( this, "Label_10" );
    qtarch_Label_10->setGeometry( 20, 170, 70, 20 );
    qtarch_Label_10->setMinimumSize( 0, 0 );
    qtarch_Label_10->setMaximumSize( 32767, 32767 );
    qtarch_Label_10->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_10->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_10->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_10->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_10->setText(  i18n("Auth:") );
    qtarch_Label_10->setAlignment( 289 );
    qtarch_Label_10->setMargin( -1 );

    QLabel* qtarch_Label_11;
    qtarch_Label_11 = new QLabel( this, "Label_11" );
    qtarch_Label_11->setGeometry( 20, 200, 70, 20 );
    qtarch_Label_11->setMinimumSize( 0, 0 );
    qtarch_Label_11->setMaximumSize( 32767, 32767 );
    qtarch_Label_11->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_11->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_11->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_11->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_11->setText(  i18n("City:") );
    qtarch_Label_11->setAlignment( 289 );
    qtarch_Label_11->setMargin( -1 );

    QLabel* qtarch_Label_12;
    qtarch_Label_12 = new QLabel( this, "Label_12" );
    qtarch_Label_12->setGeometry( 20, 230, 70, 20 );
    qtarch_Label_12->setMinimumSize( 0, 0 );
    qtarch_Label_12->setMaximumSize( 32767, 32767 );
    qtarch_Label_12->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_12->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_12->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_12->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_12->setText(  i18n("Country:") );
    qtarch_Label_12->setAlignment( 289 );
    qtarch_Label_12->setMargin( -1 );

    QLabel* qtarch_Label_14;
    qtarch_Label_14 = new QLabel( this, "Label_14" );
    qtarch_Label_14->setGeometry( 230, 20, 60, 20 );
    qtarch_Label_14->setMinimumSize( 0, 0 );
    qtarch_Label_14->setMaximumSize( 32767, 32767 );
    qtarch_Label_14->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_14->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_14->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_14->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_14->setText(  i18n("Age:") );
    qtarch_Label_14->setAlignment( 289 );
    qtarch_Label_14->setMargin( -1 );

    QLabel* qtarch_Label_15;
    qtarch_Label_15 = new QLabel( this, "Label_15" );
    qtarch_Label_15->setGeometry( 230, 50, 60, 20 );
    qtarch_Label_15->setMinimumSize( 0, 0 );
    qtarch_Label_15->setMaximumSize( 32767, 32767 );
    qtarch_Label_15->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_15->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_15->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_15->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_15->setText(  i18n("Sex:") );
    qtarch_Label_15->setAlignment( 289 );
    qtarch_Label_15->setMargin( -1 );

    QLabel* qtarch_Label_16;
    qtarch_Label_16 = new QLabel( this, "Label_16" );
    qtarch_Label_16->setGeometry( 230, 80, 60, 20 );
    qtarch_Label_16->setMinimumSize( 0, 0 );
    qtarch_Label_16->setMaximumSize( 32767, 32767 );
    qtarch_Label_16->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_16->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_16->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_16->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_16->setText(  i18n("Phone:") );
    qtarch_Label_16->setAlignment( 289 );
    qtarch_Label_16->setMargin( -1 );

    QLabel* qtarch_Label_17;
    qtarch_Label_17 = new QLabel( this, "Label_17" );
    qtarch_Label_17->setGeometry( 230, 110, 70, 20 );
    qtarch_Label_17->setMinimumSize( 0, 0 );
    qtarch_Label_17->setMaximumSize( 32767, 32767 );
    qtarch_Label_17->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_17->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_17->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_17->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_17->setText(  i18n("Home page:" ));
    qtarch_Label_17->setAlignment( 289 );
    qtarch_Label_17->setMargin( -1 );

    QLabel* qtarch_Label_18;
    qtarch_Label_18 = new QLabel( this, "Label_18" );
    qtarch_Label_18->setGeometry( 230, 140, 60, 20 );
    qtarch_Label_18->setMinimumSize( 0, 0 );
    qtarch_Label_18->setMaximumSize( 32767, 32767 );
    qtarch_Label_18->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_18->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_18->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_18->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_18->setText(  i18n("About" ));
    qtarch_Label_18->setAlignment( 289 );
    qtarch_Label_18->setMargin( -1 );

    QPushButton* qtarch_PushButton_2;
    qtarch_PushButton_2 = new QPushButton( this, "PushButton_2" );
    qtarch_PushButton_2->setGeometry( 250, 220, 90, 30 );
    qtarch_PushButton_2->setMinimumSize( 0, 0 );
    qtarch_PushButton_2->setMaximumSize( 32767, 32767 );
    connect( qtarch_PushButton_2, SIGNAL( pressed() ), SLOT( okSlot() ) );
    qtarch_PushButton_2->setFocusPolicy( QWidget::TabFocus );
    qtarch_PushButton_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_PushButton_2->setFontPropagation( QWidget::NoChildren );
    qtarch_PushButton_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_PushButton_2->setText( i18n( "Ok" ));
    qtarch_PushButton_2->setAutoRepeat( FALSE );
    qtarch_PushButton_2->setAutoResize( FALSE );

    QPushButton* qtarch_PushButton_3;
    qtarch_PushButton_3 = new QPushButton( this, "PushButton_3" );
    qtarch_PushButton_3->setGeometry( 360, 220, 90, 30 );
    qtarch_PushButton_3->setMinimumSize( 0, 0 );
    qtarch_PushButton_3->setMaximumSize( 32767, 32767 );
    connect( qtarch_PushButton_3, SIGNAL( pressed() ), SLOT( addUserSlot() ) );
    qtarch_PushButton_3->setFocusPolicy( QWidget::TabFocus );
    qtarch_PushButton_3->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_PushButton_3->setFontPropagation( QWidget::NoChildren );
    qtarch_PushButton_3->setPalettePropagation( QWidget::NoChildren );
    qtarch_PushButton_3->setText( i18n( "Adduser") );
    qtarch_PushButton_3->setAutoRepeat( FALSE );
    qtarch_PushButton_3->setAutoResize( FALSE );

    qtarch_ButtonGroup_2->insert( qtarch_auth );
    qtarch_ButtonGroup_2->insert( qtarch_PushButton_2 );
    qtarch_ButtonGroup_2->insert( qtarch_PushButton_3 );

    resize( 470, 270 );
    setMinimumSize( 470, 270 );
    setMaximumSize( 470, 270 );
    setCaption(  i18n("User Information") );
}


userInfo::~userInfo()
{
    userI = NULL;
    //printf("close..info(%d, %d)\n", isViewSearch, isDoSearch);
    isDoSearch = 0;
}
void userInfo::insertInfo( SEARCH_RESULT *result )
{
    QString tmp;
    tmp.sprintf( "%d\n", result->uin );
    qtarch_uin->setText( tmp.data() );
    if ( strlen( result->nick ) > 0 )
        qtarch_nick->setText( result->nick );
    else
        qtarch_nick->setText( result->firstName );
    qtarch_firstName->setText( result->firstName );
    qtarch_lastName->setText( result->lastName );
    qtarch_email->setText( result->email );
    printf("result: %d\n",result->auth);
    if (result->auth==1)
        qtarch_auth->setChecked(TRUE);
    else
        qtarch_auth->setChecked(FALSE);
}
void userInfo::insertExtInfo( EXT_SEARCH_RESULT *result )
{
    //  printf("??do??\n");
    //  printf("city:%s\n", result->city);
    //  printf("state:%s\n", result->state);
    //  printf("phone:%s\n", result->phone);

    qtarch_city->setText( result->city );
    qtarch_state->setText( result->state );
    qtarch_phone->setText( result->phone );
    qtarch_homePage->setText( result->home_page );
    qtarch_about->setText( result->about );
    QString tmp;
    tmp.sprintf( "%d", result->country_code );
    qtarch_ccode->setText( tmp );
    tmp.sprintf( "%d", result->age );
    qtarch_age->setText( tmp );
    switch ( result->sex )
    {
        case 1:
            qtarch_sex->setText(  i18n("Female") );
            break;
        case 2:
            qtarch_sex->setText(  i18n("Male" ));
            break;
        default:
            qtarch_sex->setText( "?" );
            break;
    }
}
void userInfo::okSlot()
{
    if (this) delete this;
}
void userInfo::addUserSlot()
{
    int go = 0;
    CONTACT contact;
    for ( int t = 0; t < contact_length(); t++ )
    {
        contact = contact_returnItemNum( t );
        if ( contact.uin == ( UIN ) atol( qtarch_uin->text() ) )
        {
            go = 1;
        }
    }
    if ( !go ) mainW->addUser( qtarch_nick->text(), atol( qtarch_uin->text() ) );
    if (this ) delete this;
}
void userInfo::closeEvent( QCloseEvent * )
{
    if (this) delete this;
}

registerDialog::registerDialog
(
    QWidget* parent,
    const char* name
) : QDialog( parent, name, TRUE )
{
    // printf("w1\n");
    QButtonGroup * qtarch_ButtonGroup_3;
    qtarch_ButtonGroup_3 = new QButtonGroup( this, "ButtonGroup_3" );
    qtarch_ButtonGroup_3->setGeometry( 10, 220, 270, 100 );
    qtarch_ButtonGroup_3->setMinimumSize( 0, 0 );
    qtarch_ButtonGroup_3->setMaximumSize( 32767, 32767 );
    qtarch_ButtonGroup_3->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_3->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_3->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_3->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_3->setFrameStyle( 49 );
    qtarch_ButtonGroup_3->setAlignment( 1 );

    QButtonGroup* qtarch_ButtonGroup_2;
    qtarch_ButtonGroup_2 = new QButtonGroup( this, "ButtonGroup_2" );
    qtarch_ButtonGroup_2->setGeometry( 10, 10, 270, 200 );
    qtarch_ButtonGroup_2->setMinimumSize( 0, 0 );
    qtarch_ButtonGroup_2->setMaximumSize( 32767, 32767 );
    qtarch_ButtonGroup_2->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_2->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setFrameStyle( 49 );
    qtarch_ButtonGroup_2->setAlignment( 1 );

    QLabel* qtarch_Label_2;
    qtarch_Label_2 = new QLabel( this, "Label_2" );
    qtarch_Label_2->setGeometry( 20, 20, 250, 40 );
    qtarch_Label_2->setMinimumSize( 0, 0 );
    qtarch_Label_2->setMaximumSize( 32767, 32767 );
    qtarch_Label_2->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_2->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_2->setText(  i18n("Welcom to KXicq. If you are new to ICQ enter everything except the UIN!" ));
    qtarch_Label_2->setAlignment( 1289 );
    qtarch_Label_2->setMargin( -1 );

    QLabel* qtarch_Label_3;
    qtarch_Label_3 = new QLabel( this, "Label_3" );
    qtarch_Label_3->setGeometry( 20, 60, 100, 20 );
    qtarch_Label_3->setMinimumSize( 0, 0 );
    qtarch_Label_3->setMaximumSize( 32767, 32767 );
    qtarch_Label_3->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_3->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_3->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_3->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_3->setText(  i18n("Password:") );
    qtarch_Label_3->setAlignment( 289 );
    qtarch_Label_3->setMargin( -1 );

    QLabel* qtarch_Label_4;
    qtarch_Label_4 = new QLabel( this, "Label_4" );
    qtarch_Label_4->setGeometry( 20, 90, 100, 20 );
    qtarch_Label_4->setMinimumSize( 0, 0 );
    qtarch_Label_4->setMaximumSize( 32767, 32767 );
    qtarch_Label_4->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_4->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_4->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_4->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_4->setText(  i18n("Nick:") );
    qtarch_Label_4->setAlignment( 289 );
    qtarch_Label_4->setMargin( -1 );

    QLabel* qtarch_Label_5;
    qtarch_Label_5 = new QLabel( this, "Label_5" );
    qtarch_Label_5->setGeometry( 20, 120, 100, 20 );
    qtarch_Label_5->setMinimumSize( 0, 0 );
    qtarch_Label_5->setMaximumSize( 32767, 32767 );
    qtarch_Label_5->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_5->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_5->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_5->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_5->setText(  i18n("Firstname:") );
    qtarch_Label_5->setAlignment( 289 );
    qtarch_Label_5->setMargin( -1 );

    QLabel* qtarch_Label_6;
    qtarch_Label_6 = new QLabel( this, "Label_6" );
    qtarch_Label_6->setGeometry( 20, 150, 100, 20 );
    qtarch_Label_6->setMinimumSize( 0, 0 );
    qtarch_Label_6->setMaximumSize( 32767, 32767 );
    qtarch_Label_6->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_6->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_6->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_6->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_6->setText(  i18n("Lastname:") );
    qtarch_Label_6->setAlignment( 289 );
    qtarch_Label_6->setMargin( -1 );

    qtarch_password = new QLineEdit( this, "password" );
    qtarch_password->setGeometry( 90, 60, 170, 20 );
    qtarch_password->setMinimumSize( 0, 0 );
    qtarch_password->setMaximumSize( 32767, 32767 );
    qtarch_password->setFocusPolicy( QWidget::StrongFocus );
    qtarch_password->setBackgroundMode( QWidget::PaletteBase );
    qtarch_password->setFontPropagation( QWidget::NoChildren );
    qtarch_password->setPalettePropagation( QWidget::NoChildren );
    qtarch_password->setText( "" );
    qtarch_password->setMaxLength( 32767 );
    qtarch_password->setEchoMode( QLineEdit::Password );
    qtarch_password->setFrame( TRUE );

    qtarch_nick = new QLineEdit( this, "nick" );
    qtarch_nick->setGeometry( 90, 90, 170, 20 );
    qtarch_nick->setMinimumSize( 0, 0 );
    qtarch_nick->setMaximumSize( 32767, 32767 );
    qtarch_nick->setFocusPolicy( QWidget::StrongFocus );
    qtarch_nick->setBackgroundMode( QWidget::PaletteBase );
    qtarch_nick->setFontPropagation( QWidget::NoChildren );
    qtarch_nick->setPalettePropagation( QWidget::NoChildren );
    qtarch_nick->setText( "" );
    qtarch_nick->setMaxLength( 32767 );
    qtarch_nick->setEchoMode( QLineEdit::Normal );
    qtarch_nick->setFrame( TRUE );

    qtarch_firstName = new QLineEdit( this, "firstName" );
    qtarch_firstName->setGeometry( 90, 120, 170, 20 );
    qtarch_firstName->setMinimumSize( 0, 0 );
    qtarch_firstName->setMaximumSize( 32767, 32767 );
    qtarch_firstName->setFocusPolicy( QWidget::StrongFocus );
    qtarch_firstName->setBackgroundMode( QWidget::PaletteBase );
    qtarch_firstName->setFontPropagation( QWidget::NoChildren );
    qtarch_firstName->setPalettePropagation( QWidget::NoChildren );
    qtarch_firstName->setText( "" );
    qtarch_firstName->setMaxLength( 32767 );
    qtarch_firstName->setEchoMode( QLineEdit::Normal );
    qtarch_firstName->setFrame( TRUE );

    qtarch_lastName = new QLineEdit( this, "lastName" );
    qtarch_lastName->setGeometry( 90, 150, 170, 20 );
    qtarch_lastName->setMinimumSize( 0, 0 );
    qtarch_lastName->setMaximumSize( 32767, 32767 );
    qtarch_lastName->setFocusPolicy( QWidget::StrongFocus );
    qtarch_lastName->setBackgroundMode( QWidget::PaletteBase );
    qtarch_lastName->setFontPropagation( QWidget::NoChildren );
    qtarch_lastName->setPalettePropagation( QWidget::NoChildren );
    qtarch_lastName->setText( "" );
    qtarch_lastName->setMaxLength( 32767 );
    qtarch_lastName->setEchoMode( QLineEdit::Normal );
    qtarch_lastName->setFrame( TRUE );

    QLabel* qtarch_Label_7;
    qtarch_Label_7 = new QLabel( this, "Label_7" );
    qtarch_Label_7->setGeometry( 20, 180, 100, 20 );
    qtarch_Label_7->setMinimumSize( 0, 0 );
    qtarch_Label_7->setMaximumSize( 32767, 32767 );
    qtarch_Label_7->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_7->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_7->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_7->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_7->setText(  i18n("Email:") );
    qtarch_Label_7->setAlignment( 289 );
    qtarch_Label_7->setMargin( -1 );

    qtarch_email = new QLineEdit( this, "email" );
    qtarch_email->setGeometry( 90, 180, 170, 20 );
    qtarch_email->setMinimumSize( 0, 0 );
    qtarch_email->setMaximumSize( 32767, 32767 );
    qtarch_email->setFocusPolicy( QWidget::StrongFocus );
    qtarch_email->setBackgroundMode( QWidget::PaletteBase );
    qtarch_email->setFontPropagation( QWidget::NoChildren );
    qtarch_email->setPalettePropagation( QWidget::NoChildren );
    qtarch_email->setText( "" );
    qtarch_email->setMaxLength( 32767 );
    qtarch_email->setEchoMode( QLineEdit::Normal );
    qtarch_email->setFrame( TRUE );

    QLabel* qtarch_Label_8;
    qtarch_Label_8 = new QLabel( this, "Label_8" );
    qtarch_Label_8->setGeometry( 20, 230, 250, 60 );
    qtarch_Label_8->setMinimumSize( 0, 0 );
    qtarch_Label_8->setMaximumSize( 32767, 32767 );
    qtarch_Label_8->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_8->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_8->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_8->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_8->setText(  i18n("So, if you are a excisting ICQ user, enter here your UIN, but if you are new DON'T"
                             "enter the UIN !!!" ));
    qtarch_Label_8->setAlignment( 1313 );
    qtarch_Label_8->setMargin( -1 );

    QPushButton* qtarch_PushButton_1;
    qtarch_PushButton_1 = new QPushButton( this, "PushButton_1" );
    qtarch_PushButton_1->setGeometry( 90, 330, 100, 30 );
    qtarch_PushButton_1->setMinimumSize( 0, 0 );
    qtarch_PushButton_1->setMaximumSize( 32767, 32767 );
    connect( qtarch_PushButton_1, SIGNAL( clicked() ), SLOT( doRegister() ) );
    qtarch_PushButton_1->setFocusPolicy( QWidget::TabFocus );
    qtarch_PushButton_1->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_PushButton_1->setFontPropagation( QWidget::NoChildren );
    qtarch_PushButton_1->setPalettePropagation( QWidget::NoChildren );
    qtarch_PushButton_1->setText(  i18n("register") );
    qtarch_PushButton_1->setAutoRepeat( FALSE );
    qtarch_PushButton_1->setAutoResize( FALSE );

    QLabel* qtarch_Label_9;
    qtarch_Label_9 = new QLabel( this, "Label_9" );
    qtarch_Label_9->setGeometry( 20, 290, 100, 20 );
    qtarch_Label_9->setMinimumSize( 0, 0 );
    qtarch_Label_9->setMaximumSize( 32767, 32767 );
    qtarch_Label_9->setFocusPolicy( QWidget::NoFocus );
    qtarch_Label_9->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Label_9->setFontPropagation( QWidget::NoChildren );
    qtarch_Label_9->setPalettePropagation( QWidget::NoChildren );
    qtarch_Label_9->setText(  i18n("UIN:" ));
    qtarch_Label_9->setAlignment( 289 );
    qtarch_Label_9->setMargin( -1 );

    qtarch_uin = new QLineEdit( this, "uin" );
    qtarch_uin->setGeometry( 90, 290, 170, 20 );
    qtarch_uin->setMinimumSize( 0, 0 );
    qtarch_uin->setMaximumSize( 32767, 32767 );
    qtarch_uin->setFocusPolicy( QWidget::StrongFocus );
    qtarch_uin->setBackgroundMode( QWidget::PaletteBase );
    qtarch_uin->setFontPropagation( QWidget::NoChildren );
    qtarch_uin->setPalettePropagation( QWidget::NoChildren );
    qtarch_uin->setText( "" );
    qtarch_uin->setMaxLength( 32767 );
    qtarch_uin->setEchoMode( QLineEdit::Normal );
    qtarch_uin->setFrame( TRUE );



    resize( 290, 370 );
    setMinimumSize( 290, 370 );
    setMaximumSize( 290, 370 );
    //  printf("w3\n");
    setCaption(  i18n("Register KXicq user") );
    //   printf("w2\n");
}


registerDialog::~registerDialog()
{
}

void registerDialog::doRegister()
{
    if ( strlen( qtarch_password->text() ) > 0 &&  strlen( qtarch_nick->text() ) > 0)
    {
        accept();
    }
}
void registerDialog::closeEvent( QCloseEvent * )
{
    if ( strlen( qtarch_password->text() ) > 0 &&  strlen( qtarch_nick->text() ) > 0)
    {
        accept();
    }
}

void registerDialog::getInfo( UIN *uin, char **nick, char **firstName, char **lastName, char **email , char **password )
{
    *uin = atol( qtarch_uin->text() );
    asprintf( nick, "%s", qtarch_nick->text() );
    asprintf( lastName, "%s", qtarch_lastName->text() );
    asprintf( firstName, "%s", qtarch_firstName->text() );
    asprintf( email, "%s", qtarch_email->text() );
    asprintf( password, "%s", qtarch_password->text() );
    //  printf("%s<-\n",qtarch_password->text());

}

awayDialog::awayDialog
(
    QWidget* parent,
    const char* name
)
        :
        QDialog( parent, name, TRUE )
{

    qtarch_Message = new QMultiLineEdit( this, "Message" );
    qtarch_Message->setGeometry( 10, 10, 380, 90 );
    qtarch_Message->setMinimumSize( 0, 0 );
    qtarch_Message->setMaximumSize( 32767, 32767 );
    qtarch_Message->setFocusPolicy( QWidget::StrongFocus );
    qtarch_Message->setBackgroundMode( QWidget::PaletteBase );
    qtarch_Message->setFontPropagation( QWidget::SameFont );
    qtarch_Message->setPalettePropagation( QWidget::SameFont );
    qtarch_Message->insertLine( awayMsg );
    qtarch_Message->setReadOnly( FALSE );
    qtarch_Message->setOverwriteMode( FALSE );

    QPushButton* qtarch_PushButton_1;
    qtarch_PushButton_1 = new QPushButton( this, "PushButton_1" );
    qtarch_PushButton_1->setGeometry( 140, 110, 100, 30 );
    qtarch_PushButton_1->setMinimumSize( 0, 0 );
    qtarch_PushButton_1->setMaximumSize( 32767, 32767 );
    connect( qtarch_PushButton_1, SIGNAL( pressed() ), SLOT( setMsg() ) );
    qtarch_PushButton_1->setFocusPolicy( QWidget::TabFocus );
    qtarch_PushButton_1->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_PushButton_1->setFontPropagation( QWidget::NoChildren );
    qtarch_PushButton_1->setPalettePropagation( QWidget::NoChildren );
    qtarch_PushButton_1->setText(  i18n("Set Message" ));
    qtarch_PushButton_1->setAutoRepeat( FALSE );
    qtarch_PushButton_1->setAutoResize( FALSE );

    resize( 400, 150 );
    setMinimumSize( 400, 150 );
    setMaximumSize( 400, 150 );
}


awayDialog::~awayDialog()
{
}

void awayDialog::setMsg()
{
    strcpy( awayMsg, qtarch_Message->text() );
    // printf("new msg: %s\n",awayMsg);
    setawaymsg( awayMsg );
    accept();
}

Chat::Chat( UIN uin, QWidget *p = NULL, char *n = NULL )
        : KTopLevelWidget( n )
{
    cuin = uin;
    split = new QSplitter( this );
    split->setOrientation( QSplitter::Vertical );
    stop = 0;
    remotec = new MLEditWrap( true, split );
    remotec->setReadOnly( true );
    local = new MLEditWrap( true, split );
    //      QPushButton

    KIconLoader *iconL = kapp->getIconLoader(); ;
    KToolBar *toolBar = new KToolBar( this );
    QPixmap pixmap;

    pixmap = iconL->loadIcon( "mini_text.xpm" );
    toolBar->insertButton( pixmap, 0, SIGNAL( clicked( int ) ), this, SLOT( setFGColor( int ) ), TRUE,  i18n("Set Text color" ));
    pixmap = iconL->loadIcon( "mini_picture.xpm" );
    toolBar->insertButton( pixmap, 1, SIGNAL( clicked( int ) ), this, SLOT( setBGColor( int ) ), TRUE,  i18n("Set Background color") );
    pixmap = iconL->loadIcon( "exit.xpm" );
    toolBar->insertButton( pixmap, 2, SIGNAL( clicked( int ) ), this, SLOT( closeSlot( int ) ), TRUE, i18n( "Close Chat") );

    setView( split );
    addToolBar( toolBar );

    QColor tmpc;
    tmpc.setRgb( 255, 255, 255 );
    totalConfig->setGroup( "Chat Settings" );
    fg = totalConfig->readColorEntry( "Chat Foreground Color",  &tmpc);
    totalConfig->writeEntry( "Chat Foreground Color", fg );
    //fg = color;
    char data[ 5 ];
    int len = 0 ;
    data[ 0 ] = 0x00;
    int r, g, b;
    fg.rgb( &r, &g, &b );
    data[ 1 ] = ( unsigned char ) r;
    data[ 2 ] = ( unsigned char ) g;
    data[ 3 ] = ( unsigned char ) b;
    data[ 4 ] = 0x00;
    len = 5;
    if ( len >= 1 )
    {
        if ( send_Chat( cuin, data, len ) < 0 )
        {
            // close connection...
            if (this) delete this;
        }
    }

    
    tmpc.setRgb( 0, 0, 0 );
    bg = totalConfig->readColorEntry( "Chat Background Color",  &tmpc);
    totalConfig->writeEntry( "Chat Background Color", bg );
    totalConfig->sync();
    //bg = color;
    //char data[ 5 ];
    //int len = 0 ;
    data[ 0 ] = 0x01;
    //int r, g, b;
    bg.rgb( &r, &g, &b );
    data[ 1 ] = ( unsigned char ) r;
    data[ 2 ] = ( unsigned char ) g;
    data[ 3 ] = ( unsigned char ) b;
    data[ 4 ] = 0x00;
    len = 5;
    if ( len >= 1 )
    {
        if ( send_Chat( cuin, data, len ) < 0 )
        {
            // close connection...
            if (this) delete this;
        }
    }

    
//    fg.setRgb( 255, 255, 255 );
//    bg.setRgb( 0, 0, 0 );
    QColorGroup cg( local->palette().normal().foreground(), local->palette().normal().background(),
                    local->palette().normal().light(),
                    local->palette().normal().dark(),
                    local->palette().normal().mid(),
                    fg,
                    bg
                  );
    local->setPalette( QPalette( cg, local->palette().disabled(), cg ) );


    connect( local, SIGNAL( keyPressed( QKeyEvent * ) ), this, SLOT( sendKey( QKeyEvent * ) ) );

    QString tmp( 40 );
    CONTACT c;
    c = contact_returnContact( uin );
    tmp.sprintf(  i18n("Chat with %s"), c.nick );
    setCaption( tmp.data() );
}

Chat::~Chat()
{
}

void Chat::resizeEvent( QResizeEvent *e )
{
    KTopLevelWidget::resizeEvent( e );
    local->repaint( TRUE );
    remotec->repaint( TRUE );

}

void Chat::sendKey( QKeyEvent *e )
{
    if ( stop == 0 )
    {
        char data[ 5 ];
        int len = 0 ;
        if ( isprint( e->ascii() ) )
        {
            data[ 0 ] = ( char ) e->ascii();
            len = 1;
            data[ 1 ] = 0;
        }
        else if ( e->key() == Key_Enter || e->key() == Key_Return )
        {
            data[ 0 ] = 0x0D;
            data[ 1 ] = 0;
            len = 1;
        }
        else if ( e->key() == Key_Backspace )
        {
            data[ 0 ] = 0x08;
            data[ 1 ] = 0;
            len = 1;
        }

        if ( len >= 1 )
        {
            if ( send_Chat( cuin, data, len ) < 0 )
            {
                // close connection...
                if (this) delete this;
            }
        }
    }
}
void Chat::getRecv( char *data, int len )
{
    if ( stop == 0 )
    {
        int l = 0;
        unsigned char r, g, b, n;
        QColorGroup cg;
        QColor color;
        unsigned short int *lenl;
        while ( l < len )
        {
            switch ( data[ l ] )
            {
                case 0x08:
                    remotec->backspace();
                    break;
                case 0x0d:
                    remotec->newLine();
                    break;
                case 0x00:
                    {
                        r = data[ ++l ];
                        g = data[ ++l ];
                        b = data[ ++l ];
                        n = data[ ++l ];
                        if (KXDEBUG) printf("F: %d, %d, %d\n",r,g,b);
                        l++;
                        color.setRgb( r, g, b );
                        QColorGroup cg1( remotec->palette().normal().foreground(),
                                         remotec->palette().normal().background(),
                                         remotec->palette().normal().light(),
                                         remotec->palette().normal().dark(),
                                         remotec->palette().normal().mid(),
                                         color,
                                         remotec->palette().normal().base()
                                       );
                        remotec->setPalette( QPalette( cg1, remotec->palette().disabled(), cg1 ) );
                    }
                    break;
                case 0x01:
                    {
                        r = data[ ++l ];
                        g = data[ ++l ];
                        b = data[ ++l ];
                        n = data[ ++l ];
                        if (KXDEBUG) printf("B: %d, %d, %d\n",r,g,b);
                        l++;
                        color.setRgb( r, g, b );
                        QColorGroup cg1( remotec->palette().normal().foreground(),
                                         remotec->palette().normal().background(),
                                         remotec->palette().normal().light(),
                                         remotec->palette().normal().dark(),
                                         remotec->palette().normal().mid(),
                                         remotec->palette().normal().text(),
                                         color
                                       );
                        remotec->setPalette( QPalette( cg1, remotec->palette().disabled(), cg1 ) );
                    }
                    break;
                case 0x04:  //stop
                case 0x03:  //start
                    break;
                case 0x10:

                    lenl = ( unsigned short int * ) ( data + ( l + 1 ) );
                    l += *lenl + 4;
                    l += 2;
                    break;
                case 0x11:
                    l += 4;
                    break;
                case 0x12:
                    l += 4;
                    break;
                case 0x07:  //beep
                    break;
                default:
                    remotec->appendChar( data[ l ] );
                    if ( KxicqConfig.autoRaise ) raise();
            }
            l++;
        }
        if (data) free( data );
    }
}
void Chat::closeChat()
{
    if ( stop == 0 )
    {
        stop = 1;
        QString tmp( 120 );
        CONTACT c;
        c = contact_returnContact( cuin );
        tmp.sprintf(  i18n("%s had ended this Chat session."), c.nick );
        QMessageBox::warning( this,  i18n("KXicq chat"), tmp.data(),  i18n("Ok") );

    }
}

void Chat::closeEvent( QCloseEvent *t = NULL )
{
    if ( stop == 0 ) chat_close( cuin );
    totalConfig->setGroup( "Chat Settings" );
    totalConfig->writeEntry( "Chat Foreground Color", fg );
    totalConfig->writeEntry( "Chat Background Color", bg );
    totalConfig->sync();

    if (this) delete this;
    //accept();
}

void Chat::setFGColor( int )
{
    QColor color = fg;
    KColorDialog::getColor( color );
    QColorGroup cg( local->palette().normal().foreground(), local->palette().normal().background(),
                    local->palette().normal().light(),
                    local->palette().normal().dark(),
                    local->palette().normal().mid(),
                    color,
                    local->palette().normal().base()
                  );
    local->setPalette( QPalette( cg, local->palette().disabled(), cg ) );
    fg = color;
    unsigned char data[ 5 ];
    int len = 0 ;
    data[ 0 ] = 0x00;
    int r, g, b;
    fg.rgb( &r, &g, &b );
    data[ 1 ] = ( unsigned char ) r;
    data[ 2 ] = ( unsigned char ) g;
    data[ 3 ] = ( unsigned char ) b;
    data[ 4 ] = 0x00;
    len = 5;
    if ( len >= 1 )
    {
        if ( send_Chat( cuin, (char *)data, len ) < 0 )
        {
            // close connection...
            if (this) delete this;
        }
    }

}
void Chat::setBGColor( int )
{
    QColor color = bg;
    KColorDialog::getColor( color );
    QColorGroup cg( local->palette().normal().foreground(), local->palette().normal().background(),
                    local->palette().normal().light(),
                    local->palette().normal().dark(),
                    local->palette().normal().mid(),
                    local->palette().normal().text(),
                    color
                  );
    local->setPalette( QPalette( cg, local->palette().disabled(), cg ) );
    bg = color;
    unsigned char data[ 5 ];
    int len = 0 ;
    data[ 0 ] = 0x01;
    int r, g, b;
    bg.rgb( &r, &g, &b );
    data[ 1 ] = ( unsigned char ) r;
    data[ 2 ] = ( unsigned char ) g;
    data[ 3 ] = ( unsigned char ) b;
    data[ 4 ] = 0x00;
    len = 5;
    if ( len >= 1 )
    {
        if ( send_Chat( cuin, (char *)data, len ) < 0 )
        {
            // close connection...
            if (this) delete this;
        }
    }

}
void Chat::closeSlot( int )
{
    close();
}

//#include "mail.moc"
