/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* v2_codes.h                                                              *
* Command codes for the ICQ protocol v2                                   *
**************************************************************************/


#ifndef _V2_CODES_H
#define _V2_CODES_H


/* ICQ client commands */
#define C_ACK               0x000A      /* acknowledgement */
#define C_ACK_MSG           0x0442	/* Ack message (delete from server) */
#define C_SEND_MESSAGE      0x010E      /* send message to offline user */
#define C_LOGIN             0x03E8      /* login on server */
#define C_CONTACT_LIST      0x0406      /* Inform the server of cont. list */
#define C_SEARCH_UIN        0x041A      /* search for user by UIN */
#define C_SEARCH_USER       0x0424      /* search for user by name/email */
#define C_KEEP_ALIVE        0x042E      /* keep alive */
#define C_SEND_TEXT_CODE    0x0438      /* send special message to server */
#define C_LOGIN_1           0x044C      /* Sent during login */
#define C_INFO_REQ          0x0460      /* Request basic information */
#define C_EXT_INFO_REQ      0x046A      /* Request extended information */
#define C_CHANGE_PASSWORD   0x049C      /* Change the user's password */
#define C_STATUS_CHANGE     0x04D8      /* Change status of user (Away etc.) */
#define C_LOGIN_2           0x0528      /* Sent during Login */


#define S_INVALID_UIN	    0x012C
#define S_WRONG_PASSWORD    0x0064
#define C_UPDATE_INFO       0x050A      /* Update my basic information */
#define C_UPDATE_EXT_INFO   0x04B0      /* Update my extended information */
#define C_ADD_TO_LIST       0x053C      /* Add user to contact list (clist)*/
#define C_REQ_ADD_TO_LIST   0x0456      /* Request auth to add to clist */
#define C_QUERY_STATUS      0x04BA      /* Query about other servers */
#define C_QUERY_ADDONS      0x04C4      /* Query about global add-ons */
#define C_NEW_USER_1        0x04EC      /* Ask for permission to add new usr */
#define C_NEW_USER_REG      0x03Fc      /* Register a new user */
#define C_CMD_X1            0x0442      /* Uknown */
#define C_MSG_TO_NEW_USER   0x0456      /* Send a message to not in clist */
#define C_WEB               0x064A
#define C_WEB_FINISCH       0x04D8

#define S_TRY_AGAIN	    0x00FA	/* try again */



/* ICQ server commands */
#define S_ACK               0x000A      /* Ack */
#define S_LOGIN_REPLY       0x005A      /* Login reply */
#define S_USER_ONLINE       0x006E      /* user in clist changed status */
#define S_USER_OFFLINE      0x0078      /* user in clist has gone offline */
#define S_USER_FOUND        0x008C      /* user record found matching query */
#define S_RECEIVE_MESSAGE   0x00DC      /* message sent while offline */
#define S_GET_MESSAGE       0x0104	/* message from user (sent throu server) */
#define S_END_OF_SEARCH     0x00A0      /* No more USER_FOUND will be sent */
#define S_INFO_REPLY        0x0118      /* Return basic information */
#define S_EXT_INFO_REPLY    0x0122      /* Return extended information */
#define S_STATUS_UPDATE     0x01A4      /* User on contact list changed stat */
#define S_GO_AWAY           0x0028	/* Been idle, logging you out */
#define S_DISCONNECTED      0x00F0      /* We got disconnected? */
/**/
#define S_REPLY_X1          0x021C      /* Unknown (returned during login) */
#define S_REPLY_X2          0x00E6      /* Unknown (confirm my UIN?) */
#define S_UPDATE_REPLY      0x01E0      /* Confirmation of basic update */
#define S_UPDATE_EXT_REPLY  0x00C8      /* Confirmation of extended update */
#define S_NEW_USER_UIN      0x0046      /* Confirmation of new user with UIN */
#define S_NEW_USER_REPLY    0x00B4      /* Confirmation of new user info */
#define S_QUERY_REPLY       0x0082      /* Response to QUERY_SERVERS or QUERY_A*/
#define S_SYSTEM_MESSAGE    0x01C2      /* System message with URL button */

#define S_WEB_ACK           0x03DE

#define LOCALHOST	0x0100007f	/* localhost IP ( 127.0.0.1 ) ;) */

// TCP commands

#define TCP_START	0x07EE
#define TCP_CANCEL	0x07D0
#define TCP_ACK		0x07DA
#define TCP_MSG		0x0001
#define TCP_FILE	0x0003
#define TCP_CHAT	0x0002
#define TCP_URL		0x0004
#define TCP_READAWAYMSG	0x03E8
#define TCP_READOCCMSG	0x03E9
#define TCP_READNAMSG	0x03EA
#define TCP_READDNDMSG	0x03EB
#define TCP_HANDSHAKE	0x03ff
#define TCP_HANDSHAKE1	0x04FF
#define TCP_HANDSHAKE2	0x02FF

#define TCP_ONLINE 	0x0000
#define TCP_AWAY	0x0004
#define TCP_NA		0x000E
#define TCP_DND		0x000A
#define TCP_OCC		0x0009
#define TCP_REFUSE	0x0001

#define FONT_PLAIN	0x00000000
#define FONT_BOLD	0x00000001
#define FONT_ITALIC	0x00000002
#define FONT_UNDERLINE	0x00000004


#endif
