/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* net.h                                                                   *
* network functions                                                       *
**************************************************************************/


#ifndef _NET_H
#define _NET_H

#include <fcntl.h>

#include <sys/types.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include "config.h"
#include "structs.h"
#include "v2_codes.h"
#include "misc.h"
#include "ui2lib.h"
#include "parse.h"
#include "net.h"

int net_init( USER_CONFIGURATION *user_cfg );
int net_udpGetSocket();
int net_udpSend( unsigned char *mesg, int length );
int net_tcpSend( unsigned char *mesg, unsigned short type, int y, unsigned int command, unsigned int seq );
int net_udpRecv( unsigned char *mesg, int length );
int net_tcpRecv( int y );
int net_newtcpRecv( int y );
int net_tcpSetup();
void tcp_openConnection( UIN uin );

void setnonblocking( int sock );
unsigned int ipToIcq( unsigned int l );
unsigned int icqToIp( unsigned int l );

int net_TcpChatAcceptSend( int y, unsigned int seq );
int net_sendChatFunctions( int y );
int net_ChatServer( int y );
int net_ChatRead( int y, int len );
int net_send2chat( int sock, char *data, int len );
int net_sendChatColors( int y );
int net_sendRequest( int y, char *mesg );
int net_doChatClient( int i );
int net_sendChatCancel( int y );
#endif

