#include <kwvdial.h>
#include <kwvdial.moc>

Kwvdial::Kwvdial(QWidget *parent, const char *name)
        : KTMainWindow(name)
                       ,cfg("/etc/wvdial.conf")
	    	       ,dialer(NULL)
                       ,log("KWvDial",WvLog::Info)
		       ,timeonline(0)
{
    QPixmap *kwvdialicon = new QPixmap(kwvdial);
    
    setIcon(*kwvdialicon);
    
    QPopupMenu *file_menu = new QPopupMenu();
    
    file_menu->insertItem(i18n("Configure"), this, SLOT(wvconfig()));
    file_menu->insertSeparator();
    
    file_menu->insertItem(i18n("E&xit"), kapp, SLOT(quit()));
    
    QPopupMenu *view_menu = new QPopupMenu();
    
    view_menu->insertItem(i18n("Log"),this,SLOT(viewlog()));
    view_menu->insertItem(i18n("Graph"),this,SLOT(viewgraph()));
    view_menu->insertItem(i18n("Hide"),this,SLOT(viewiconic()));

    connect_menu = new QPopupMenu();
    
    connect(connect_menu, SIGNAL(activated(int)), this, SLOT(wvconnect(int)));
    connect(connect_menu, SIGNAL(aboutToShow()), this, SLOT(fillmenu()));
        
    QPopupMenu *help_menu = new QPopupMenu();
    help_menu->insertItem(i18n("&Help"), this, SLOT(invokeHelp()));
    help_menu->insertSeparator();
    help_menu->insertItem(i18n("&About"), this, SLOT(wvabout()));

    menuBar = new KMenuBar(this, "menubar");
    menuBar->insertItem(i18n("&File"), file_menu);
    menuBar->insertItem(i18n("&View"), view_menu);
    menuBar->insertItem(i18n("&Connect"), connect_menu);
    menuBar->insertItem(i18n("&Help"), help_menu);
    
    setMenu(menuBar);
    
    statusBar = new KStatusBar(this);
    statusBar->message("Offline",0);
    setStatusBar(statusBar);

    QTimer *timer = new QTimer(this);
    connect(timer,SIGNAL(timeout()),this,SLOT(wvtimer()));
    timer->start(1000,FALSE);

    logview = new KwvdialWidget(this);
    graphview = new KwvdialGraph(this);
    
    graphview->hide();
    
    setView(logview);
    
    enableStatusBar();

    log("Welcome to KWvDial Version %s\n\n",VERSION);
}

Kwvdial::~Kwvdial()
{
    // If the modem is still connected, hangup before we quit
    if ((dialer != NULL) && (dialer->status() == WvDialer::Online))
    {
	dialer->hangup();
	delete dialer;
    }

    delete statusBar;
    delete menuBar;
}

void Kwvdial::invokeHelp()
{
    kapp->invokeHTMLHelp("kwvdial/kwvdial.html", "");
}

void Kwvdial::wvabout()
{
    QMessageBox::information(this,"KWvDial " VERSION,
			     "\nKWvDial Version "
			     VERSION "\n\n"
			     "Written by:\n\tPatrick Patterson\n"
			     "\tppatters@cnss.ca\n and\n"
			     "\tAvery Pennarun\n"
			     "\tapenwarr@worldvisions.ca\n"); 
}

void Kwvdial::viewlog()
{
    if (!logview->isVisible())
    {
	graphview->hide();
	setView(logview);
	logview->show();
    }
}

void Kwvdial::viewgraph()
{
    QMessageBox::information(this,"KWvDial - In Progress",
			     " Feature Not Implemented Yet");

/*    if (!graphview->isVisible())
    {
	logview->hide();
	setView(graphview);
	graphview->show();
    }
*/
}

void Kwvdial::viewiconic()
{
/* First Shot at doing the dockable app thing - I hope this works....
 */
    log("Docking....\n");
    hide();

    // Create the KwvdialDock Widget with a null parent
    KWVDock = new KwvdialDock("KWVDock",this);
}

void Kwvdial::fillmenu()
{    
    connect_menu->clear();
    
    WvConf::Iter i(cfg);
    
    for(i.rewind();i.next();)
	connect_menu->insertItem(i().name, -1);
    connect_menu->insertSeparator();
    connect_menu->insertItem(i18n("&Disconnect"), this, SLOT(wvdisconnect()));
}

void Kwvdial::wvconnect(int id)
{
    if (dialer==NULL)
    {
	if (id >= 0)
	{
	    sections = new WvStringList;
	    sections->append(new WvString(connect_menu->text(id)),true);
	    
	    dialer= new WvDialer(cfg,sections);
	    dialer->dial();
	    statusBar->message("Dialing....");
	}
    } else {
	log("*** In Use, Please disconnect first\n");
    }
}

void Kwvdial::wvdisconnect()
{
    int hours,minutes,seconds;
    char statustext[1024];
    
    if (dialer !=NULL)
    {
	dialer->hangup();
	delete dialer;
	dialer = NULL;
	statusBar->message("Offline");
	if ( (timeonline/60) > 0)
	{
	    if ( (timeonline/360) > 0)
	    {   
		hours = (timeonline / 360) ;
		minutes = (timeonline % 360) / 60 ;
		seconds = (timeonline % 360) % 60 ;
	    } else {
		hours = 0;
		minutes = timeonline / 60;
		seconds = timeonline % 60;
	    }
	} else {
	    seconds = timeonline;
	    minutes = 0;
	    hours = 0;
	}
	sprintf(statustext,"Online for: %d:%02d:%02d",hours,minutes,seconds);
	log("%s\n",statustext);
        timeonline = 0;
    } else {
	log("Not Connected...\n");

    }
}

void Kwvdial::wvconfig()
{
    config = new KwvdialConfig(NULL,"Config",cfg);
    config->show();
    repaint();
}

void Kwvdial::wvtimer()
{
    int hours = 0;
    int minutes = 0;
    int seconds = 0;
    char statustext[1024];
			
    if (dialer != NULL && dialer->isok() && (dialer->status() != WvDialer::Online))
	// If it is dialling... have it keep dialling....
	if (dialer->select(2))
	    dialer->callback();
    
    if (dialer != NULL && dialer->status() == WvDialer::Online)
    {
	// If it is online - advance the timer - eventually do something with QTime
	if (timeonline == 0)
	{
	    // If it just stopped dialling then initialize the timer
	    connecttime = time((time_t *)0);
	    timeonline = 1;
	    statusBar->message("Online");
	    log("Connected....\n\n");
	} else {
	    // Weve been online for at least a second... so display length of time
	    currenttime = time((time_t *)0);
	    timeonline = (int)difftime(currenttime,connecttime);
	    if ( (timeonline/60) > 0)
	    {
		if ( (timeonline/360) > 0)
		{   
		    hours = (timeonline / 360) ;
		    minutes = (timeonline % 360) / 60 ;
		    seconds = (timeonline % 360) % 60 ;
		} else {
		    hours = 0;
		    minutes = timeonline / 60;
		    seconds = timeonline % 60;
		}
	    } else {
		seconds = timeonline;
		minutes = 0;
		hours = 0;
	    }
	    sprintf(statustext,"Online for: %d:%02d:%02d",hours,minutes,seconds);
	    statusBar->message(statustext);
	}
    }
    
}
