#include <qslider.h>

#include <kiconloader.h>
#include <kfiledialog.h> 

#include "main.h"
#include "main.moc"

#include <kapp.h>

datenclass *daten;

MyWidget::MyWidget (int argc, char **argv, QWidget *, const char * name) : KTopLevelWidget (name) 
{
        maindialog_widget = new MyMainTable(this ,"_page1");
	setMinimumSize(350,200);
	setView(maindialog_widget);

	ConfigFile = kapp->getConfig();

        filemenu = new QPopupMenu;
        filemenu->insertItem( i18n("&New File..."), this, SLOT( new_smbconf()) );
        filemenu->insertItem( i18n("&Open File..."), this,  SLOT( open_smbconf()) );
        saveID = filemenu->insertItem( i18n("&Save File"), this,  SLOT( save_smbconf()) );
	filemenu->setItemEnabled(saveID,false);
        filemenu->insertSeparator();
	ConfigFile->setGroup("recent_files");
	file1ID = filemenu->insertItem( ConfigFile->readEntry("File_1","empty"), this, SLOT( open_file1()) );
	file2ID = filemenu->insertItem( ConfigFile->readEntry("File_2","empty"), this, SLOT( open_file2()) );
	file3ID = filemenu->insertItem( ConfigFile->readEntry("File_3","empty"), this, SLOT( open_file3()) );
	file4ID = filemenu->insertItem( ConfigFile->readEntry("File_4","empty"), this, SLOT( open_file4()) );
        filemenu->insertSeparator();
        filemenu->insertItem( klocale->translate("E&xit"), this, SLOT( quit() ) );

        parametermenu = new QPopupMenu;

        globalID = parametermenu->insertItem( i18n("&Global settings..."),
		this , SLOT( globalsettings() ) );
	parametermenu->setItemEnabled(globalID,false);

        serviceID = parametermenu->insertItem( i18n("&Service settings..."),
		this , SLOT( servicesettings() ) );
	parametermenu->setItemEnabled(serviceID,false);

        newserviceID = parametermenu->insertItem( i18n("&Add service..."),
		this , SLOT( add_service() ) );
	parametermenu->setItemEnabled(newserviceID,false);

        copyID = parametermenu->insertItem( i18n("&Remove service"),
		this , SLOT( delete_service() ) );
	parametermenu->setItemEnabled(copyID,false);

	QPopupMenu* helpmenu = kapp->getHelpMenu(true, 
		"KSamba v0.3.3\t (c) 1998\n
		Lars Kneschke\t Lars.Kneschke@kiel.netsurf.de
		Jan Kneschke\t Jan Kneschke@kiel.netsurf.de");

	KMenuBar *menu = new KMenuBar( this );
	menu->insertItem( i18n("&File"), filemenu );
	menu->insertItem( i18n("&Edit"), parametermenu );        
	menu->insertSeparator();
	menu->insertItem( i18n("&Help"),helpmenu );
	setMenu( menu );

	KIconLoader *iconloader = kapp->getIconLoader();
        tb = new KToolBar( this, "toolbar" );

        tb->setFullWidth(TRUE);

	tb->insertButton( iconloader->loadIcon("fileopen.xpm") , 0, SIGNAL( clicked() ),
		this, SLOT(open_smbconf()),TRUE,klocale->translate("Open smb.conf") );
	tb->insertButton( iconloader->loadIcon("filefloppy.xpm"), 1, SIGNAL( clicked() ),
		this, SLOT(save_smbconf()),FALSE,klocale->translate("Save smb.conf") );
	tb->insertButton( iconloader->loadIcon("mini/www.xpm"), 2, SIGNAL( clicked() ),
		this, SLOT(globalsettings()),FALSE,klocale->translate("Edit global settings") );
	tb->insertButton( iconloader->loadIcon("folder.xpm"), 3, SIGNAL( clicked() ),
		this, SLOT(servicesettings()),FALSE,klocale->translate("Edit service settings") );
 	tb->insertButton( iconloader->loadIcon("pageadd.xpm") , 4, SIGNAL( clicked() ),
		this, SLOT(add_service()),FALSE,klocale->translate("Add service") );
 	tb->insertButton( iconloader->loadIcon("pageremove.xpm") , 5, SIGNAL( clicked() ),
		this, SLOT(delete_service()),FALSE,klocale->translate("Remove service") );

        tb->setBarPos( KToolBar::Top );
        enableToolBar( KToolBar::Toggle, addToolBar( tb ));

        
        sb = new KStatusBar( this );
	sb->insertItem( klocale->translate("This is KSamba 0.3.3..."), 0 );
	setStatusBar( sb );

	setCaption(kapp->getCaption());
	resize(650,405);        
	show();
	resize(650,405);  
	if (argc > 1)
	{
		if (strcmp(argv[1],"-caption") > 0)
		{
		filename = argv[1];
		process_smbconf(filename);
		}
	}

}

void MyWidget::add_service()
{
	newservice NewServiceWidget; 
	if ( NewServiceWidget.exec() ) 
	{
		daten->newService(NewServiceWidget.newservice_name,
				  NewServiceWidget.newservice_type,
				  NewServiceWidget.newservice_path);
		maindialog_widget->SetListValues(daten);
	}
}

void MyWidget::delete_service()
{
	daten->deleteService(maindialog_widget->getCurrentItem());
	maindialog_widget->SetListValues(daten);
}

void MyWidget::globalsettings()
{
		myglobalwidget GlobalWidget; 
		GlobalWidget.setData(daten->getGlobalDataPointer());
		if ( GlobalWidget.exec() ) 
		{
			GlobalWidget.saveData(daten->getGlobalDataPointer());
		}
}

void MyWidget::new_smbconf()
{
}

void MyWidget::open_file1()
{
	if(strcmp(ConfigFile->readEntry("File_1"),"empty") != 0)
	process_smbconf(ConfigFile->readEntry("File_1"));
}

void MyWidget::open_file2()
{
	if(strcmp(ConfigFile->readEntry("File_2"),"empty") != 0)
	process_smbconf(ConfigFile->readEntry("File_2"));
}

void MyWidget::open_file3()
{
	if(strcmp(ConfigFile->readEntry("File_3"),"empty") != 0)
	process_smbconf(ConfigFile->readEntry("File_3"));
}

void MyWidget::open_file4()
{
	if(strcmp(ConfigFile->readEntry("File_4"),"empty") != 0)
	process_smbconf(ConfigFile->readEntry("File_4"));
}

void MyWidget::open_smbconf()
{
        filename = KFileDialog::getOpenFileName("/etc","smb.conf");
        if( !filename.isNull() ) 
        {
		process_smbconf(filename);
        }
}

void MyWidget::process_smbconf(QString _FileName)
{
		printf("open %s\n",_FileName.data() );
                sb->changeItem( _FileName.data() , 0 );
                daten = new datenclass(&_FileName);
		maindialog_widget->SetListValues(daten);
		filemenu->setItemEnabled(saveID,true);
		parametermenu->setItemEnabled(newserviceID,true);
		parametermenu->setItemEnabled(copyID,true);
		parametermenu->setItemEnabled(globalID,true);
		parametermenu->setItemEnabled(serviceID,true);
		tb->setItemEnabled(1,true);
		tb->setItemEnabled(2,true);
		tb->setItemEnabled(3,true);
		tb->setItemEnabled(4,true);
		tb->setItemEnabled(5,true);
		if (strcmp(_FileName.data(),ConfigFile->readEntry("File_1")) != 0)
		{
		ConfigFile->setGroup("recent_files");
		ConfigFile->writeEntry("File_4",ConfigFile->readEntry("File_3","empty") );
		ConfigFile->writeEntry("File_3",ConfigFile->readEntry("File_2","empty") );
		ConfigFile->writeEntry("File_2",ConfigFile->readEntry("File_1","empty") );
		ConfigFile->writeEntry("File_1",_FileName.data());
		ConfigFile->sync();
		filemenu->changeItem(ConfigFile->readEntry("File_1"),file1ID);
		filemenu->changeItem(ConfigFile->readEntry("File_2"),file2ID);
		filemenu->changeItem(ConfigFile->readEntry("File_3"),file3ID);
		filemenu->changeItem(ConfigFile->readEntry("File_4"),file4ID);
		}
}

void MyWidget::save_smbconf()
{
	daten->saveSmbconfFile();
	maindialog_widget->SetListValues(daten);
}

void MyWidget::servicesettings()
{
	emit EditService();
	maindialog_widget->edit_service_from_outside();
}

void MyWidget::quit()
{
        kapp->quit();
}

int main (int argc, char **argv)

{
        KApplication* TestApp = new KApplication(argc,argv);

        MyWidget* TestWid = new MyWidget(argc,argv);
        TestApp->setMainWidget (TestWid);
        TestWid->show();
        return TestApp->exec();
}


