#ifndef data2_included
#define data2_included

#include <stdlib.h>
#include <unistd.h>
#include <qobject.h>
#include <qfile.h>
#include <qtstream.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qdir.h>
#include <ksimpleconfig.h>
#include <qdict.h>

#define DICT_SIZE	67
#define ARRAY_SIZE	59
#define QCharDict QDict<char>

class datenclass:public QObject 
{
//	Q_OBJECT
public:
	datenclass (QString *filename);
	~datenclass();

	QStrList services_list;
	QStrList delete_list;

	void getGlobalData();
	void getServiceData();
	void saveSmbconfFile();
	void newService(QString servicename, QString servicetype, QString servicepath);
	void deleteService(int index);
	QCharDict *getGlobalDataPointer();
	QCharDict *getGlobalDefaultsPointer();
	QCharDict *getServiceDataPointer(int index);

	QList<QCharDict>	filesrvlist;
	QString 		*charString;
	QCharDict		*service2daten;

	char 			*language;		//getenv LANG...
	char 			*kdedir;		//getenv KDEDIR...

private:
	void		getServices();
	void 		SetupGlobalDefaults();
	void 		SetupServiceDefaults();

	KSimpleConfig	*confdata;
	QTextStream	*tmp_line;
	QString		*tmpstring;
	QString		tmp2_string;
	QCharDict	*globaldaten;
	QCharDict	*globaldefaults;
	QCharDict	*servicedefaults;

	int		index;
	char*		str;

};

#endif // data_included
