/***************************************************************************
                     knlistview.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNLISTVIEW_H
#define KNLISTVIEW_H

#include <qlistview.h>



class KNListView : public QListView  {

	Q_OBJECT

	public:
		KNListView(QWidget *parent, const char *name=0);
		~KNListView();
		
		int sortColumn()	{ return sCol; }
		bool ascending() 	{ return sAsc; }
	
		
	public slots:
		void slotSortList(int col);			
	
		
	protected:
		void keyPressEvent(QKeyEvent *e);
		void mousePressEvent(QMouseEvent *e);
		
		bool sAsc;
		int sCol;	
	
		
	signals:
		void sortingChanged(int, int);	
			
};

#endif






