/***************************************************************************
                     knlistview.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knlistview.h"
#include "utilities.h"
#include <qheader.h>
#include <qkeycode.h>

KNListView::KNListView(QWidget *parent, const char *name=0) : QListView(parent,name)
{
	sAsc=true;
	sCol=-1;
	connect(this->header(), SIGNAL(sectionClicked(int)),
		this, SLOT(slotSortList(int)));
		
	this->header()->setMovingEnabled(false);
	
}


KNListView::~KNListView()
{
}



void KNListView::slotSortList(int col)
{ 	
			
	if(col==sCol) sAsc=!sAsc;
	else {
		emit sortingChanged(sCol, col);
		sCol=col;
		sAsc=true;
	
	}
			
	this->setSorting(sCol, sAsc);
	
}



void KNListView::keyPressEvent(QKeyEvent *e)
{
		
	switch(e->key()) {
	
		case Key_PageDown: 	this->verticalScrollBar()->addPage(); break;
		
		case Key_PageUp:		this->verticalScrollBar()->subtractPage(); break;
		
		case Key_Up:				this->verticalScrollBar()->subtractLine(); break;
		
		case Key_Down:			this->verticalScrollBar()->addLine(); break;
		
		case Key_Home:			this->verticalScrollBar()->setValue(
													this->verticalScrollBar()->minValue()); break;
		
		case Key_End:				this->verticalScrollBar()->setValue(
													this->verticalScrollBar()->maxValue()); break;
		
		
		default: e->ignore();
	};
	
	
}



void KNListView::mousePressEvent(QMouseEvent *e)
{
	this->setFocus();
	QListView::mousePressEvent(e);
}
	









