/***************************************************************************
                     knheaderlistbase.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include "knheaderlistbase.h"
#include "utilities.h"

KNHeaderListBase::KNHeaderListBase()
{
	lastID=0;
	len=0;
	siz=0;
	list=0;
	incr=50;
}

KNHeaderListBase::~KNHeaderListBase()
{
	if(list){
		for(uint i=0; i<len; i++)
			delete list[i];
							
		free(list);}	
}

bool KNHeaderListBase::append(KNHeaderBase *en)
{
  if(len+1>siz)  //array too small
		if (!resize()) return false; //try to realloc

	if(en->id==-1) en->id=++lastID;
	list[len]=en;
	len++;
	
	return true;		 		
}

bool KNHeaderListBase::resize(uint s=0)
{
	KNHeaderBase **bak=list;
	uint nSize;
	
	if(s==0) nSize=siz+incr;
	else nSize=((s/incr)+1)*incr;
	
	list=(KNHeaderBase**) realloc(list,sizeof(KNHeaderBase*)*nSize);

  if(!list) {
		MBox(err,i18n("Memory allocation failed !!\nYou should close this application now\n, to avoid data loss"));
		list=bak;
		return false;}
	else {
		siz=nSize;
		//debug("size : %d\n",siz);
		return true;}
}




void KNHeaderListBase::clear()
{
	if(list){
		for(uint i=0; i<len; i++)
			delete list[i];
							
		free(list);
		list=0; len=0; siz=0; lastID=0;}
}









