/***************************************************************************
                     kngroupdialog.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kngroupdialog.h"
#include "knglobals.h"
#include <stdlib.h>
#include <qlayout.h>

KNGroupDialog::KNGroupDialog(QWidget *parent=0, const char *name=0) :
	QDialog(parent, name, true)
{
	
	mSub=new QStrList(true);
	mSub->setAutoDelete(true);
	
	mUnsub=new QStrList(true);
	mUnsub->setAutoDelete(true);
	
	mActive=new QStrList(true);
	mActive->setAutoDelete(true);
	QStrList *tmp=xTop->gManager()->activeList();
	for(char *var=tmp->first(); var; var=tmp->next())
		mActive->append(var);		
	
		
	glw=new KNGroupListWidget(this, 0, mActive);
	glw->setMinimumSize(glw->sizeHint());
	
	ok=new QPushButton(i18n("OK"), this);
	ok->setMinimumSize(ok->sizeHint());
	
	cancel=new QPushButton(i18n("Cancel"), this);
	cancel->setMinimumSize(cancel->sizeHint());
	
	newList=new QPushButton(i18n("New list"), this);
	newList->setMinimumSize(newList->sizeHint());
	
	help=new QPushButton(i18n("Help"), this);
	help->setEnabled(false);
	help->setMinimumSize(help->sizeHint());
	
	QVBoxLayout *topLayout=new QVBoxLayout(this, 10);
	QHBoxLayout *buttons=new QHBoxLayout(10);
	
	topLayout->addWidget(glw,1);
	topLayout->addLayout(buttons,0);
	
	buttons->addWidget(help);
	buttons->addStretch(1);
	buttons->addWidget(newList);
	buttons->addSpacing(10);
	buttons->addWidget(ok);
	buttons->addWidget(cancel);
	
	topLayout->activate();
	
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	
	connect(newList, SIGNAL(clicked()), this, SLOT(slotNewList()));
	
	connect(glw, SIGNAL(itemSelected(const char*)), this,
	SLOT(slotItemSelected(const char*)));
		
	setCaption(i18n("Newsgroups"));
		
}



KNGroupDialog::~KNGroupDialog()
{
	delete mActive;
	delete mSub;
	delete mUnsub;
}



bool KNGroupDialog::slotNewList()
{
	QStrList *tmp;
	bool ret=false;
	
	xTop->setStatusMsg(i18n("reading grouplist from server ..."));
	xTop->setCursorBusy();
		
	tmp=xTop->nntpClient()->cmdList();
	
	if(tmp) {
		
		QString fName=knDir();
		fName+="groups";
		QFile f(fName);
		
		if(f.open(IO_WriteOnly)) {
			QTextStream ts(&f);
	
			for (char *str=tmp->first(); str; str=tmp->next())
				ts << strtok(str, " ") << endl;
			
			f.close();
		}
		glw->newList();
		ret=true;
	}
				
	xTop->setCursorBusy(false);
	xTop->setStatusMsg();
		
	return ret;	
}



void KNGroupDialog::slotItemSelected(const char *text)
{
		
	if(mActive->remove(text)) {
  	if(!mSub->remove(text)) mUnsub->append(text);
  	glw->setPixmap(-1,false);}
  else {
		mActive->append(text);
		if(!mUnsub->remove(text)) mSub->append(text);
		glw->setPixmap(-1,true);}	
	
	
}
















