/***************************************************************************
                          knfilterwidget.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "knfilterwidget.h"
#include <kapp.h>
#include <qlayout.h>


KNFilterWidget::KNFilterWidget(QWidget *parent=0, const char *name=0) :
	QWidget(parent,name)
{
	status=new KNStatusFilterWidget(this);
	
	subject=new KNStringFilterWidget(this, i18n("Subject"));
	from=new KNStringFilterWidget(this, i18n("From"));
	
	score=new KNRangeFilterWidget(this, i18n("Score"), 0,100);
	age=new KNRangeFilterWidget(this, i18n("Age"), 0,999);
	lines=new KNRangeFilterWidget(this, i18n("Lines"), 0,999);
	
	QVBoxLayout *topL=new QVBoxLayout(this,10);
	
	topL->addWidget(status);
	topL->addWidget(subject);
	topL->addWidget(from);
	topL->addWidget(score);
	topL->addWidget(age);
	topL->addWidget(lines);
	
	topL->activate();
		
}



KNFilterWidget::~KNFilterWidget()
{
}





