/* ------------------------------------------------------------- 

    toplevel.h (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: toplevel.h,v 1.5 1999/05/03 18:04:43 ctuztas Exp $

   ------------------------------------------------------------- */

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include <kapp.h>
#include <view.h>

class TopLevel : public KTMainWindow
{
  Q_OBJECT
    
public:
  
  TopLevel();

protected:

  void setupMenuBar();
  void setupStatusBar();
  void setupToolBar();

private slots:

  void aboutApp();
  void confirmQuit();
  void dummy();

private:

  KMenuBar *menubar;
  KStatusBar *statusbar;
  KToolBar *toolbar;
  QPopupMenu *fileMenu, *optionsMenu, *helpMenu;
  // Menu File
  int newgrpID, delgrpID, modgrpID, prcgrpID, prcallID, schedID, quitID;
  int ID_NEWGRP, ID_DELGRP, ID_MODGRP, ID_PRCGRP, ID_PRCALL, ID_SCHED, ID_QUIT;
  // Menu Options
  int settID, clrID;
  int ID_SETT, ID_CLR;
  // Menu Help
  int contentsID, aboutID, aboutKDEID;
  int ID_HELP;
  // For Testing
  int testID;
  int ID_TEST;
   
  View *mainView;
  KIconLoader *iconLoader;
};

#endif
