/* ------------------------------------------------------------- 

    kngoptiondialog.h (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: kngoptiondialog.h,v 1.7 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#ifndef _KNGOPTIONDIALOG_H_
#define _KNGOPTIONDIALOG_H_

#include <kng.h>

class KNGOptionDialog : public QTabDialog
{
Q_OBJECT

 public:
  
  KNGOptionDialog( QWidget *parent = 0, const char *name = 0, bool modal = false, WFlags f = 0);

  ~KNGOptionDialog();

  void showTab( int, QStrList *strlist = 0 );

 protected slots: 

 void applyAction();

 private slots:
 
 void enableauth( bool );
 void browseit();
 void scheduleitems( );
 void writeSchedule();
 void discardSchedule();
  
 private:
 
 void readConfig();
 void writeConfig();
 void addsettings();
 void addschedule();

 // TABS
  QWidget *tab1;
  QWidget *tab2;

  // Layout for TAB1
  QBoxLayout *box1;
  QGridLayout *grid1;
  QGroupBox *grpbx1;

  // Descriptive Text for TAB1
  QLabel *tab1desc;

  // Elements of TAB1
  QLabel *lservername;
  QLineEdit *servername;

  QLabel *lportname;
  QLineEdit *portname;

  QCheckBox *authreq;

  QLabel *lusername;
  QLineEdit *username;

  QLabel *lpasswd;
  QLineEdit *passwd;

  QLabel *lpath;
  QLineEdit *path;
  QPushButton *pb1;

  QCheckBox *tmbnail;

  // Layout for TAB2
  QBoxLayout *box2;
  QGridLayout *grid2;
  QGroupBox *grpbx2;

  // Descriptive for TAB2
  QLabel *tab2desc;

  // Elements for TAB2
  QListBox *lbox;
  QPushButton *pb2;
  QPushButton *pb3;
  QLabel *ltime;
  QLineEdit *time;
  
};

#endif
