/* ------------------------------------------------------------- 

    kngoptiondialog.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: kngoptiondialog.cpp,v 1.9 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#include <kngoptiondialog.h>

KNGOptionDialog::KNGOptionDialog( QWidget *parent = 0, const char *name = 0, 
				  bool modal = FALSE, WFlags f = 0 )
  :QTabDialog( 0, name, true, f )
{

  setCaption( "K News Grabber" );

  addsettings();
  addschedule();

  readConfig();

  setOkButton( );
  setCancelButton();
  
  connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( applyAction() ) );
  connect( authreq, SIGNAL( toggled( bool ) ), this, SLOT( enableauth(bool) ) );
  
  resize(415,475);
  
}


void
KNGOptionDialog::addsettings()
{

  tab1 = new QWidget( this , "Page One");
  box1 = new QBoxLayout( tab1, QBoxLayout::TopToBottom, 4 );

  grpbx1 = new QGroupBox( i18n( "Server Settings" ), tab1 );
  box1->addWidget( grpbx1 );

  grid1 = new QGridLayout( grpbx1, 7, 3, 20, 4 );
  tab1desc = new QLabel( i18n( "Set your news Server and Port" ), grpbx1 );
  tab1desc->adjustSize();
  tab1desc->setMinimumSize( 100, tab1desc->size().height() );
  grid1->setRowStretch( 0, 10 );
  grid1->addMultiCellWidget( tab1desc, 0, 0, 0, 2 );
  
  lservername = new QLabel( grpbx1 );
  lservername->setText( i18n( "Servername" ) );
  lservername->adjustSize();
  lservername->resize((int)lservername->sizeHint().width(),lservername->sizeHint().height() + 6);
  lservername->setMinimumSize(lservername->size());
  grid1->addWidget( lservername, 2, 0 );

  servername = new QLineEdit( grpbx1 );
  servername->setMinimumSize(100, lservername->height()+2);
  servername->setMaximumSize(1000, lservername->height()+2);
  grid1->addWidget(servername, 2, 1);

  lportname = new QLabel( grpbx1 );
  lportname->setText( i18n( "Port" ) ); 
  lportname->adjustSize(); 
  lportname->resize((int)lportname->sizeHint().width(),lportname->sizeHint().height() + 6); 
  lportname->setMinimumSize(lportname->size()); 
  grid1->addWidget( lportname, 3, 0 ); 

  portname = new QLineEdit( grpbx1 ); 
  portname->setMinimumSize( 100, lportname->height() + 2 ); 
  portname->setMaximumSize( 1000, lportname->height() + 2 ); 
  grid1->addWidget( portname, 3, 1 ); 

  grid1->setColStretch(0,1);
  grid1->setColStretch(1,10);
  grid1->setColStretch(2,0);
  grid1->activate();

  grpbx1 = new QGroupBox( i18n( "Authentification" ), tab1 );
  box1->addWidget( grpbx1 );
  grid1 = new QGridLayout( grpbx1, 7, 3, 20, 4 );

  authreq = new QCheckBox( i18n( "Authentification required" ), grpbx1 );
  authreq->adjustSize();
  authreq->setMinimumSize(authreq->sizeHint() );
  grid1->addMultiCellWidget(authreq, 0, 0, 0, 1);

  lusername = new QLabel( grpbx1 );
  lusername->setText( i18n( "Username   " ) );
  lusername->adjustSize();
  lusername->resize((int)lusername->sizeHint().width(),lusername->sizeHint().height() + 6);
  lusername->setMinimumSize(lusername->size());
  grid1->addWidget( lusername, 2, 0 );

  username = new QLineEdit( grpbx1 );
  username->setMinimumSize(100, lusername->height()+2);
  username->setMaximumSize(1000, lusername->height()+2);
  grid1->addWidget( username, 2, 1);
  
  lpasswd = new QLabel( grpbx1 );
  lpasswd->setText( i18n( "Password" ) );
  lpasswd->adjustSize();
  lpasswd->resize((int)lpasswd->sizeHint().width(),lpasswd->sizeHint().height() + 6);
  lpasswd->setMinimumSize(lpasswd->size());
  grid1->addWidget( lpasswd, 3, 0 );

  passwd = new QLineEdit( grpbx1 );
  passwd->setEchoMode( QLineEdit::Password );
  passwd->setMinimumSize(100, lpasswd->height()+2);
  passwd->setMaximumSize(1000, lpasswd->height()+2);
  grid1->addWidget( passwd, 3, 1);

  username->setEnabled( false );
  passwd->setEnabled( false );

  grid1->setColStretch(0,1);
  grid1->setColStretch(1,10);
  grid1->setColStretch(2,0);
  grid1->activate();

  grpbx1 = new QGroupBox( i18n( "Local Settings" ), tab1 );
  box1->addWidget( grpbx1 );
  grid1 = new QGridLayout( grpbx1, 7, 3, 20, 4 );

  lpath = new QLabel( grpbx1 );
  lpath->setText( i18n( "Save to     " ) );
  lpath->adjustSize();
  lpath->resize( ( int ) lpath->sizeHint().width(), lpath->sizeHint().height() + 6 );
  lpath->setMinimumSize( lpath->size() );
  grid1->addWidget( lpath, 2, 0 );

  path = new QLineEdit( grpbx1 );
  path->setMinimumSize( 100, lpath->height() + 2 );
  path->setMaximumSize( 1000, lpath->height() + 2 );
  grid1->addWidget( path, 2, 1 );

  pb1 = new QPushButton( i18n( "Browse..." ), grpbx1 );
  pb1->setMinimumSize( pb1->sizeHint().width(), path->height() + 2 );
  grid1->addWidget( pb1, 2, 2 );

  tmbnail = new QCheckBox( i18n( "Enable Thumbnail-View" ), grpbx1 );
  tmbnail->adjustSize();
  tmbnail->setMinimumSize( tmbnail->sizeHint() );
  grid1->addMultiCellWidget( tmbnail, 4, 4, 0, 1 );

  grid1->setColStretch(0,1);
  grid1->setColStretch(1,10);
  grid1->setColStretch(2,0);
  grid1->activate();
  
  box1->addStretch(10);
  box1->activate();

  connect( pb1, SIGNAL( clicked() ), this, SLOT( browseit() ) );
  
  addTab( tab1, i18n( "&Settings" ) );
}

void
KNGOptionDialog::addschedule()
{

  tab2 = new QWidget( this, "Page Two" );
  box2 = new QBoxLayout( tab2, QBoxLayout::TopToBottom, 4 );
  
  grpbx2 = new QGroupBox( i18n( "Schedule Settings" ), tab2 );
  box2->addWidget( grpbx2 );
  
  grid2 = new QGridLayout( grpbx2, 9, 3, 20, 4 );
  tab2desc = new QLabel( i18n( "Select groups for schedule" ), grpbx2 );
  tab2desc->adjustSize();
  tab2desc->setMinimumSize( 100, tab2desc->size().height() );
  grid2->setRowStretch( 0, 10 );
  grid2->addMultiCellWidget( tab2desc, 0, 0, 0, 2);
  
  lbox = new QListBox( grpbx2 );
  lbox->setMultiSelection( true );
  connect( lbox, SIGNAL( selectionChanged ( ) ), this, SLOT( scheduleitems ( ) ) );
  // To be deleted
  // End of to be deleted
  grid2->addMultiCellWidget( lbox, 1, 4 , 0, 2);
  grid2->addRowSpacing( 1, 30 );
  grid2->addRowSpacing( 2, 30 );
  grid2->setRowStretch( 1, 20 );
  grid2->addRowSpacing( 5, 20 );

  ltime = new QLabel( grpbx2 );
  ltime->setText( i18n( "Start at" ) );
  ltime->adjustSize();
  ltime->resize((int)ltime->sizeHint().width(),ltime->sizeHint().height() + 6);
  ltime->setMinimumSize(ltime->size());
  grid2->addWidget( ltime, 6, 0 );

  time = new QLineEdit( grpbx2 );
  time->setMinimumSize(100, ltime->height()+2);
  time->setMaximumSize(1000, ltime->height()+2);
  //grid2->addMultiCellWidget( time, 6, 6, 1, 2);
  grid2->addWidget( time, 6, 1 );

  pb2 = new QPushButton( i18n( "Schedule" ), grpbx2 );
  pb2->setMinimumSize( pb2->sizeHint().width() - 5 , time->height() + 2 );
  connect( pb2, SIGNAL( clicked() ), this, SLOT( writeSchedule() ) );
  grid2->addWidget( pb2, 6, 2 );

  pb3 = new QPushButton( i18n( "Remove" ), grpbx2 );
  pb3->setMinimumSize( pb3->sizeHint().width() - 5, time->height() + 2 );
  connect( pb3, SIGNAL( clicked() ), this, SLOT( discardSchedule () ) );
  pb3->setEnabled( false );
  grid2->addWidget( pb3, 7, 2 );

  grid2->setColStretch(0,1);
  grid2->setColStretch(1,10);
  grid2->setColStretch(2,0);
  grid2->activate();
  
  box2->addStretch(10);
  box2->activate();

  addTab( tab2, "Schedule" );
}

void
KNGOptionDialog::showTab( int id, QStrList *strlist = 0)
{
  QString lstr;
  QTime ltm = ( QTime::currentTime() ).addSecs( 3600 );
  lstr.sprintf( "%.2d:%.2d", ltm.hour(), ltm.minute() );

  switch (id)
    {
    case 1:
      setTabEnabled( i18n( "Settings" ), true );
      showPage( tab1 );
      show();
      break;
    case 2:
      setTabEnabled( i18n( "Schedule" ), true );
      lbox->clear();
      showPage( tab2 );
      lbox->insertStrList( strlist );
      time->setText( lstr );
      show();
      break;
    default:
      // False
      break;
    }
    
}

KNGOptionDialog::~KNGOptionDialog()
{

}

void
KNGOptionDialog::applyAction()
{
  writeConfig();
  ( kapp->getConfig() )->sync();
}

void 
KNGOptionDialog::readConfig()
{
  KConfig *config = kapp->getConfig();

  
  const char *defserver = getenv( "NNTPSERVER" );
  config->setGroup("Settings");
  if ( config->hasKey( "nntpserver" ) )
    {
      // We assume, if he has one he has all
      servername->setText( config->readEntry( "nntpserver", defserver ) );
      portname->setText( config->readEntry( "nntpport", "119" ) );

      if ( config->hasKey( "authreq" ) &&  
	   ( (config->readEntry( "authreq", "false" ) ) == "true" ) )
	{
	  // Authentification required
	  authreq->setChecked( true );
	  username->setText( config->readEntry( "username", "" ) );
	  passwd->setText( config->readEntry( "passwd", "" ) );
	  enableauth( true );
	}
      path->setText( config->readEntry( "path", "" ) );
      if ( config->hasKey( "tmbview" )  &&
	   ( ( config->readEntry( "tmbview" , "false" )) == "true" ) )
	tmbnail->setChecked( true );
      else
	tmbnail->setChecked( false );
    }
  else
    {
      // No Config Settings yet fill in the defaults
      servername->setText( defserver );
      portname->setText( "119" );
      delete defserver;
    }
}

void 
KNGOptionDialog::writeConfig()
{

  KConfig *config = kapp->getConfig();

  config->setGroup( "Settings" );
  config->writeEntry( "nntpserver", servername->text() );
  config->writeEntry( "nntpport", portname->text() );
  
  if ( authreq->isChecked() )
    {
      config->writeEntry( "authreq", "true" );
      config->writeEntry( "username", username->text() );
      config->writeEntry( "passwd", passwd->text() );
    }
  else
    {
      // have to delete manually ?
      config->writeEntry( "authreq", "false" );
      config->writeEntry( "username", "" );
      config->writeEntry( "passwd", "" );
    }
  
  if ( tmbnail->isChecked() )
    config->writeEntry( "tmbview", "true" );
  else
    config->writeEntry( "tmbview", "false" );

  QRegExp r = QRegExp( "/$", FALSE, FALSE );
  QString str = path->text();
  if ( ! str.contains( r ) )
    {
      str.append( "/" );
      path->setText( str );
      config->writeEntry( "path", path->text() );
    }
}

void
KNGOptionDialog::enableauth( bool enable )
{
  username->setEnabled( !username->isEnabled() );
  passwd->setEnabled( !passwd->isEnabled() );
}

void
KNGOptionDialog::browseit()
{
  path->setText( KFileDialog::getSaveFileName() );
}

void
KNGOptionDialog::scheduleitems( )
{ 
  debug( "Item is %d state is %d ", lbox->currentItem(), lbox->isSelected( lbox->currentItem() ));
}

void 
KNGOptionDialog::writeSchedule()
{
  debug( "Write schedule execed" );
  
  int ctr = 1;
  int lstd = 0;
  QString stime;
  QString str = kapp->localkdedir();
  str.append( "/share/apps/kng/job" );

  QString file( str );

  if ( ( stime = time->text() ).isEmpty() )
    {
      QMessageBox::warning( 0, "K News Grabber", "You did not enter a start time" );
      return;
    }

  debug ( "Start time is %s", ( const char * ) stime );
  do {
      file = file.sprintf( "%s_%d", ( const char * ) str, ctr );
      ctr++;
  } while ( QFile::exists( file ) );

  QFile f( file );
  if ( ! f.open( IO_WriteOnly) )
    debug ( "Could not open file %s to write", ( const char * ) file );
  else
    {
      QTextStream ts( &f );
      ts << "at " << stime << " << EOF\n";
      ts << "kng -c " << ( kapp->localconfigdir() ).append( "/kngrc" );
      ts << " -j ";
      for ( uint i = 0; i < lbox->count(); i++ )
	if ( lbox->isSelected( i ) )
	  {
	    lstd = 1;
	    ts << lbox->text( i ) << " ";
	  }
      ts << "\nrm -f " << file << "\nEOF\n";
    }
  f.close();
  // Asume we did it correct
  if ( ! lstd )
    {
      f.remove();
      debug( "No group selected" );
      hide();
      return;
    }
  chmod ( ( const char *) file, S_IRUSR | S_IWUSR | S_IXUSR );

  system( ( const char * ) file );
  hide();
}

void 
KNGOptionDialog::discardSchedule()
{
  debug( "Discard schedule execed" );
}
