  /*

  knat v 1.1.2

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include <kmsgbox.h>
#include <kiconloader.h>
#include <klocale.h>

#include "knat.moc"

#include "version.h"

knetfilter::knetfilter( QWidget *, const char *name )
  : KTMainWindow( name )
{
  
    interfaceChoice = "eth";
    interfacenrChoice = 0;
    interfacenrChoicedmp = "0";
    masqinterfaceChoice = "eth";
    masqinterfacenrChoice = 0;
    masqinterfacenrChoicedmp = "0";
    chainChoice = "INPUT";
    policyChoice = "DROP";
    flagChoice = "-v";
    polchainChoice = "INPUT";
    chainpolicyChoice = "ACCEPT";
    natchainChoice= "PREROUTING";
    natchainResult="DNAT";
    natpolchainChoice = "PREROUTING";
    natchainpolicyChoice = "ACCEPT";
    natprotocolChoice = "tcp";
    masqprotocolChoice = "all";
    manglechainChoice = "PREROUTING";
    manglepolchainChoice ="PREROUTING";
    manglechainpolicyChoice = "ACCEPT";
    mangleprotocolChoice = "tcp";
    mangleactionChoice = "TOS";
    mangletosChoice = "0";
    mangleSyn = "-v";
    logLevel = "0";
    log1="-v";
    log2="-v";
    log3="-v";
	
    setupMenuBar();
    setupToolBar();
    setupStatusBar();

    setupknetfilterWidget();

    setupConnect();
    startprobeInterface();

    statusbar->message(i18n("Welcome to knetfilter"), 2000);
 

	/* 
	 * Initialize pointers -- this is necassary for
	 * *List == NULL test to work later.
	 */
	polList = NULL;
	natList = NULL;
	natpolList = NULL;
	masqList = NULL;
	mangleList = NULL;
	manglepolList = NULL;
	dumpList = NULL;
	masqWin = NULL;
};


knetfilter::~knetfilter() {

  delete file;
  delete tables;
  delete nat_tables;
  delete mangle;
  delete options;
  delete help;
  delete toolbar;

};

// creating menubar
void knetfilter::setupMenuBar() {

  file = 	new QPopupMenu();
  tables = 	new QPopupMenu();
  nat_tables =  new QPopupMenu();
  mangle =      new QPopupMenu();
  options = 	new QPopupMenu();

/*----- REMOVE LATER ----------
  polcheck = 0; 
  rulecheck = 0;
  dumpcheck = 0;
  natcheck = 0;
  natpolcheck = 0;
  masqcheck = 0;
-------------------------------*/

  file->insertItem(i18n("&Save all rules"), 
  				this, SLOT(saveAll()));
  file->insertItem(i18n("&Load all rules"), 
  				this, SLOT(loadAll()));
  file->insertSeparator();
  file->insertItem(i18n("&Exit"), 
  				this, SLOT(slotExit()), CTRL+Key_E);

  tables->insertItem(i18n("Define Tables Chain policy"),
			        this, SLOT(polRules()));
  tables->insertSeparator();
  tables->insertItem(i18n("&Add rule to all"), 
  				this, SLOT(addRule()), CTRL+Key_A);
  tables->insertItem(i18n("&Del rule to all"), 
  				this, SLOT(delRule()), CTRL+Key_D);
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to tcp"), 
  				this, SLOT(addRule_tcp()));
  tables->insertItem(i18n("Del rule to tcp"), 
  				this, SLOT(delRule_tcp()));
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to udp"), 
  				this, SLOT(addRule_udp()));
  tables->insertItem(i18n("Del rule to udp"), 
  				this, SLOT(delRule_udp()));
  tables->insertSeparator();
  tables->insertItem(i18n("Add rule to icmp"), 
  				this, SLOT(addRule_icmp()));
  tables->insertItem(i18n("Del rule to icmp"), 
  				this, SLOT(delRule_icmp()));
  tables->insertSeparator();
  tables->insertItem(i18n("Flush iptables &rules"), 
		                this, SLOT(stopAll()), CTRL+Key_R);

  
  useMasq = nat_tables->insertItem(i18n("Masquerade"), 
				this, SLOT(masqRules()));
   nat_tables->insertItem(i18n("Redirections"),
  			        this, SLOT(natRules()));
   nat_tables->insertItem(i18n("Define Nat Chain policy"),
			        this, SLOT(natpolRules()));
   nat_tables->insertItem(i18n("Flush Nat Rules"),
			        this, SLOT(stopNAT()), CTRL+Key_N);
   mangle->insertSeparator();
   mangle->insertItem(i18n("Mangle"),
                		this, SLOT(mangleRules())); 
   mangle->insertItem(i18n("Define Mangle Chain policy"),
                		this, SLOT(manglepolRules())); 
   mangle->insertItem(i18n("Flush Mangle Rules"),
                		this, SLOT(stopMangle()), CTRL+Key_M); 

  options->insertSeparator();
  options->insertItem(i18n("List Rules, Masquerading & Mangle entries"),
  				this, SLOT(iptablesRules()));
  options->insertSeparator();
  options->insertItem(i18n("TcpDump"),
  				this, SLOT(tcpDump()));
  options->insertSeparator();
  options->insertItem(i18n("Probe interface"),
	  			this, SLOT(startprobeInterface()));
  options->insertSeparator();
  options->insertItem(i18n("&Clear list"), 
  				this, SLOT(clearLog()));
  //  isMasqon = FALSE;

  QString about;
  about.sprintf ("knetfilter %s\n\n"
	  	"original kfirewall has been created by Kim Andre Norheim\n"
		"knetfilter for 2.4.x kernels has been done by Luigi Genoni\n"
		"all addons to the original kfirewall have been done by Luigi Genoni\n"
		"please send feedback to venom@DarkStar.sns.it", KNETFILTER_VERSION);
		
  help = kapp->getHelpMenu(TRUE, about);

  menubar = new KMenuBar( this, "menubar" );

  menubar->insertItem(i18n("&File"), file);
  menubar->insertItem(i18n("&TablesPolicy"), tables);
  menubar->insertItem(i18n("&NatPolicy"), nat_tables);
  menubar->insertItem(i18n("&ManglePolicy"), mangle);
  menubar->insertItem(i18n("&Options"), options);
  menubar->insertItem(i18n("&Help"), help);

  setMenu(menubar);

};


// creating toolbar
void knetfilter::setupToolBar() {

  KIconLoader *loader = kapp->getIconLoader();
  toolbar = new KToolBar( this );

  toolbar->insertButton(loader->loadIcon("play.xpm"),add,SIGNAL(clicked()),
			this,SLOT(addRule()),TRUE,i18n("Add rule to both tcp & udp")); 
  toolbar->insertButton(loader->loadIcon("stop.xpm"),del,SIGNAL(clicked()),
			this,SLOT(delRule()),TRUE,i18n("Delete rule to both tcp & udp"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("play_tcp.xpm"),add,SIGNAL(clicked()),
			this,SLOT(addRule_tcp()),TRUE,i18n("Add rule to tcp")); 
  toolbar->insertButton(loader->loadIcon("stop_tcp.xpm"),del,SIGNAL(clicked()),
			this,SLOT(delRule_tcp()),TRUE,i18n("Delete rule to tcp"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("play_udp.xpm"),add,SIGNAL(clicked()),
			this,SLOT(addRule_udp()),TRUE,i18n("Add rule to udp")); 
  toolbar->insertButton(loader->loadIcon("stop_udp.xpm"),del,SIGNAL(clicked()),
			this,SLOT(delRule_udp()),TRUE,i18n("Delete rule to udp"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("play_icmp.xpm"),add,SIGNAL(clicked()),
			this,SLOT(addRule_icmp()),TRUE,i18n("Add rule to icmp")); 
  toolbar->insertButton(loader->loadIcon("stop_icmp.xpm"),del,SIGNAL(clicked()),
			this,SLOT(delRule_icmp()),TRUE,i18n("Delete rule to icmp"));
  toolbar->insertButton(loader->loadIcon("probe.xpm"),del,SIGNAL(clicked()),
			this,SLOT(startprobeInterface()),TRUE,i18n("Probe Network Interface"));
  toolbar->setBarPos( KToolBar::Top );

  toolbar1 = addToolBar(toolbar);

};


// creating statusbar
void knetfilter::setupStatusBar() {

  statusbar = new KStatusBar( this );
  statusbar->setBorderWidth(1);

  setStatusBar( statusbar );

};

// exit
void knetfilter::slotExit() {

  close();
  exit(0);
};
