#include "kmodem.h"
#include "kmodem.moc.cpp"

#include <stdlib.h>

#include <kapp.h>
#include <kwm.h>

#include <qtooltip.h>

KApplication * mykapp;

KModem::KModem(Bool Dock)
: modemoff((const char*)(QString(mykapp->kde_datadir())+"/kmodem/pics/kmodem.xpm")), 
     modemidle((const char*)(QString(mykapp->kde_datadir())+"/kmodem/pics/kmodemon.xpm")), 
     modemrd((const char*)(QString(mykapp->kde_datadir())+"/kmodem/pics/kmodemr.xpm")), 
     modemwr((const char*)(QString(mykapp->kde_datadir())+"/kmodem/pics/kmodemrw.xpm")),
     modemrw((const char*)(QString(mykapp->kde_datadir())+"/kmodem/pics/kmodemw.xpm"))
{
   if ((sock=socket(AF_INET, SOCK_DGRAM, 0)) < 0 )
   {
        	perror("Could not create socket");
                exit(1);
   }
   startTimer(200);
   KConfig * cfg=mykapp->getConfig();
   device=new QString(cfg->readEntry("Device","ppp0"));
   io_recv=io_trans=0;
   if (Dock) KWM::setDockWindow(winId());
   resize(modemoff.size());
}

void KModem::timerEvent(QTimerEvent*)
{
   memset(&ifreq,0,sizeof(ifreq));
   strcpy(ifreq.ifr_ifrn.ifrn_name, device->data());
   ifreq.ifr_ifru.ifru_data=(caddr_t)&stats;
   int io=ioctl(sock,SIOCDEVPRIVATE,(caddr_t)&ifreq);
   io_recv=stats.p.ppp_ibytes;
   io_trans=stats.p.ppp_obytes;

   if (io==-1||!(io_recv||io_trans)) 
   {
      status=OFF;
      if (status==old_status) return;
      old_status=status;
      QToolTip::remove(this);
      QToolTip::add(this,"Offline...");
   }
   else
   {
      status=0;
      if (io_recv > old_recv) status|=RECEIVED;
      if (io_trans > old_trans) status|=TRANSMITED;
      old_recv=io_recv;
      old_trans=io_trans;
      if (status==old_status) return;
      old_status=status;
      QToolTip::remove(this);
      QString tip=QString().sprintf("RD %.2f KB WR %.2f KB", (float)io_recv/1024, (float)io_trans/1024);
      QToolTip::add(this,(const char*)tip);
   }
   
   repaint();
}

void KModem::closeEvent(QCloseEvent*)
{
   KConfig * cfg=mykapp->getConfig();
   cfg->writeEntry("Device",device->data());
   cfg->sync();
   printf("KModem v%s (c) by Taylor\n", VERSION);
   mykapp->quit();
}

void KModem::resizeEvent(QResizeEvent* evt)
{
   static int i=1;
   if (i) {i=0;return;}
   float w=((float)evt->size().width())/((float)evt->oldSize().width());
   float h=((float)evt->size().height())/((float)evt->oldSize().height());
   matrix.scale(w,h);
   repaint();
}


void KModem::paintEvent(QPaintEvent*)
{
   
  // Bernd?! is this more like it?!?
  // ;-) Thank's a lot!!! 


  switch (status)
   {
      case OFF:
      {
      	bitBlt(this,0,0,&modemoff.xForm(matrix));
        break;
      }
      case IDLE:
      {
      	bitBlt(this,0,0,&modemidle.xForm(matrix));
        break;
      }
      case TRANSMITED :
      {
      	bitBlt(this,0,0,&modemwr.xForm(matrix));
        break;
      }
      case RECEIVED :
      {
      	bitBlt(this,0,0,&modemrd.xForm(matrix));
        break;
      }
      case RECVTRANS :
      {
      	bitBlt(this,0,0,&modemrw.xForm(matrix));
        break;
      }
   }
}



int main(int argc, char**argv)
{
   mykapp=new KApplication(argc, argv);
   Bool Dock = !((argc == 2) && ! strcmp(argv[1], "nodock"));
   KModem modem(Dock);
   modem.show();
   mykapp->exec();
}
