/***************************************************************************
                          kdockdialer.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kdockdialer.h"


KDockDialer::KDockDialer() : QWidget()
{
  docked = FALSE;
  doRemove = FALSE;
  dockPopup = new QPopupMenu();
  dockID = dockPopup->insertItem("Restore", this, SLOT(showWindow()));
	dialID = dockPopup->insertItem("Dial", this, SLOT(emitDial()));
  dockPopup->insertItem("Quit", this, SLOT(emitQuit()));
  QToolTip::add(this, "KMasqDialer");
}

KDockDialer::~KDockDialer()
{
}

void KDockDialer::dock()
{
  if(!docked)
  {
    KWM::setDockWindow(this->winId());
    this->setFixedSize(24, 24);
    show();
    paintIcon();
    update();
    docked = TRUE;
  }
}

void KDockDialer::undock()
{
  if(docked)
  {
    // the widget's window has to be destroyed in order
    // to undock from the panel. Simply using hide() is
    // not enough.
    this->destroy(TRUE, TRUE);
    // recreate window for further dockings
    this->create(0, TRUE, FALSE);
    docked = FALSE;
  }
}

const int KDockDialer::isDocked()
{
  return docked;
}

void KDockDialer::paintEvent(QPaintEvent*)
{
  paintIcon();
}

void KDockDialer::paintIcon()
{
  bitBlt(this, (24-dockIcon.width())/2, (24-dockIcon.height())/2, &dockIcon);
}

void KDockDialer::mouseDoubleClickEvent(QMouseEvent *e)
{
  if(e->button() == LeftButton)
  {
      showWindow();
  }
}

void KDockDialer::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton || e->button() == MidButton)
  {
    int x = e->x();
    int y = e->y();
    QString text;
      if(doRemove)
      {
        dockPopup->removeItemAt(1);
        dockPopup->removeItemAt(0);
        doRemove = FALSE;
      }
    if(((Kmasqdialer*)(kapp->topWidget()))->isVisible())
    {
      text = "Dock";
      dockPopup->disconnectItem(dockID, this, SLOT(showWindow()));
      dockPopup->connectItem(dockID, this, SLOT(hideWindow()));
    }
    else
    {
      text = "Restore";
      dockPopup->disconnectItem(dockID, this, SLOT(hideWindow()));
      dockPopup->connectItem(dockID, this, SLOT(showWindow()));
    }
    dockPopup->changeItem(text, dockID);
    dockPopup->popup(mapToGlobal(QPoint(x, y)));
    dockPopup->exec();
  }
}

void KDockDialer::slotChangeDialButton(bool dial){

	if (dial == true)
	{
		printf("Testing... 1...\n");
		dockPopup->disconnectItem(dialID, this, SLOT(emitDial()));
		dockPopup->connectItem(dialID, this, SLOT(emitHangup()));
		dockPopup->changeItem("Hangup", dialID);
		
		
	}
	else
	{
		printf("testing... 2...\n");
		dockPopup->disconnectItem(dialID, this, SLOT(emitHangup()));
		dockPopup->connectItem(dialID, this, SLOT(emitDial()));
		dockPopup->changeItem("Dial", dialID);
	}

}

void KDockDialer::hideWindow()
{
  if(((Kmasqdialer*)(kapp->topWidget()))->isVisible())
    ((Kmasqdialer*)(kapp->topWidget()))->hide();
}

void KDockDialer::showWindow()
{
  if(!((Kmasqdialer*)(kapp->topWidget()))->isVisible())
    ((Kmasqdialer*)(kapp->topWidget()))->show();
}

void KDockDialer::emitQuit()
{
  emit quitClicked();
}

void KDockDialer::emitDial()
{
 	emit dialClicked();
}

void KDockDialer::emitHangup()
{
 	emit hangupClicked();
}

void KDockDialer::setIcon(QPixmap icon)
{
  dockIcon = icon;
  update();
}

void KDockDialer::setToolTip(QString text)
{
  QToolTip::remove(this);
  QToolTip::add(this, (const char*)text);
}


















