// $Id: userlist.cpp,v 1.14 1998/12/08 16:35:50 denis Exp $
// $Log: userlist.cpp,v $
// Revision 1.14  1998/12/08 16:35:50  denis
// Cleaned up a little before releasing
//
// Revision 1.13  1998/11/25 12:04:34  denis
// Trying to catch QGDict::look: Attempt to insert null item
//
// Revision 1.12  1998/11/23 10:11:36  denis
// recvRequest support added
//

#include <qpopmenu.h>
#include <qpainter.h>
#include <kiconloader.h>
#include <kapp.h>
#include <icq.h>
#include "mainwindow.h"
#include "userlist.h"

#include "userlist.moc"

UserList::UserList(QWidget *parent, const char *name, WFlags f) : WBlinkListBox(parent, name, f)
{
  oldCurrent = -1;
  doRemove = FALSE ;
  QPalette pal = palette();
  QColorGroup colgrp = pal.normal();
  pal.setNormal(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),
                            colgrp.dark(),colgrp.mid(),colgrp.text(),colgrp.background()));
  colgrp = pal.active();
  pal.setActive(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),
                            colgrp.dark(),colgrp.mid(),colgrp.text(),colgrp.background()));
  setPalette(pal);

  connect(this, SIGNAL(selected(int)), kapp->topWidget() ,SLOT(recvRequest(int)));

  KIconLoader *il = kapp->getIconLoader();
  alertpopup = new QPopupMenu();
  onlineID = alertpopup->insertItem("Online Alert", kapp->topWidget(), SLOT(onlineAlert()));
  alertpopup->insertSeparator();
  visibleID = alertpopup->insertItem("Visible To User", kapp->topWidget(), SLOT(visibleUser()));
  alertpopup->setCheckable(TRUE);
  popup = new QPopupMenu();
  popup->insertItem(il->loadIcon("receive.xpm"),"Receive Message", 0);
  popup->connectItem(0, kapp->topWidget(), SLOT(recvRequest()));
  popup->insertItem(il->loadIcon("message.xpm"),"Send Message", kapp->topWidget(), SLOT(messageRequest()));
  popup->insertItem(il->loadIcon("url.xpm"),"Send URL", kapp->topWidget(), SLOT(urlRequest()));
  popup->insertItem(il->loadIcon("file.xpm"),"Send File (N/A)", 1);
  popup->insertItem(il->loadIcon("chat.xpm"),"ICQ Chat (N/A)", 2);
  popup->insertSeparator() ;
  popup->insertItem(il->loadIcon("history.xpm"),"View Message History",kapp->topWidget(), SLOT(historyRequest())) ;
  popup->insertSeparator();
  popup->insertItem(il->loadIcon("alert.xpm"), "Alert/Accept Modes", alertpopup);
  popup->insertItem(il->loadIcon("info.xpm"),"Info", kapp->topWidget(), SLOT(infoRequest()));
  popup->insertItem(il->loadIcon("rename.xpm"),"Rename", kapp->topWidget(), SLOT(renameRequest()));
  popup->insertItem(il->loadIcon("delete.xpm"),"Delete", kapp->topWidget(), SLOT(delUserRequest()));
//  popup->insertSeparator();
//  popup->insertItem("Add Test Message", kapp->topWidget(), SLOT(debug1Request()));
//  popup->insertItem("Add Test URL", kapp->topWidget(), SLOT(debug2Request()));
  popup->setItemEnabled(0,FALSE);
  popup->setItemEnabled(1,FALSE);
  popup->setItemEnabled(2,FALSE);

  onlineList.setAutoDelete(FALSE);
  offlineList.setAutoDelete(FALSE);
  notInList.setAutoDelete(FALSE);
  authorizeList.setAutoDelete(FALSE);
  setBlinkInterval(1000);
}

UserList::~UserList()
{
  onlineList.clear();
  offlineList.clear();
  notInList.clear();
  authorizeList.clear();
  clear();
  if(alertpopup)
  {
    alertpopup->clear();
    delete alertpopup;
  }
  if(popup)
  {
    popup->clear();
    delete popup;
  }
}

void UserList::paintCell(QPainter *p, int row, int col)
{
  UserItem *lbi = (UserItem*)item(row);
  if(!lbi)
    return;

  QColorGroup g = colorGroup();
  if(isSelected(row) && lbi->type()!=tpOnSeparator && lbi->type()!=tpOffSeparator &&
     lbi->type()!=tpNILSeparator && lbi->type()!=tpAuthSeparator)
  {
    QColor fc(blue);
    p->fillRect(0, 0, cellWidth(col), cellHeight(row), fc);
    p->setPen(QColor(white));
    p->setBackgroundColor(fc);
  }
  else
  {
    p->setBackgroundColor(g.base());
    if(isUINNotInList(lbi->getInfo().uin))
    {
      p->setPen(QColor(darkGreen));
    }
    else
    {
      switch(lbi->getStatus() & 0x01FF) // 0xFFFF
      {
        case 0x01FF: // 0xFFFF
          p->setPen(QColor(red));
          break;
        case STATUS_ONLINE:
        case STATUS_AWAY:
        case STATUS_NA:
        case STATUS_DND:
        case STATUS_OCCUPIED:
        case STATUS_FREE_CHAT:
        case STATUS_INVISIBLE:
        case STATUS_INVISIBLE_2:
          p->setPen(QColor(blue));
          break;
        default:
          p->setPen(g.text());
          break;
      }
    }
  }
  lbi->paint(p);
  p->setBackgroundColor(g.base());
  p->setPen(g.text());
}

void UserList::mousePressEvent(QMouseEvent *e)
{
  int t;
  WBlinkListBox::mousePressEvent(e);
  if(currentItem()!=-1)
    t=getItem(currentItem())->type();
  else
    return;
  if(t!=tpOnSeparator && t!=tpOffSeparator && t!=tpNILSeparator && t!=tpAuthSeparator)
    if(e->button()==RightButton)
    {
      if(getItem(currentItem())->getNumUnreadMsgs())
        popup->setItemEnabled(0,TRUE);
      else
        popup->setItemEnabled(0,FALSE);
      ContactItem *info = getItem(currentItem())->getInfoPtr();
      alertpopup->setItemChecked(onlineID, info->onlineAlert);
      alertpopup->setItemChecked(visibleID, info->visibleUser);
      if(!isUINInContactList(getItem(currentItem())->getInfo().uin))
      {
        if(!doRemove)
        {
          KIconLoader *l = kapp->getIconLoader() ;
          popup->insertSeparator() ;
          popup->insertItem(l->loadIcon("add.xpm"),"Add to Contact List",this,SLOT(addRequest()));
          doRemove = TRUE;
        }
      }
      else
        if(doRemove)
        {
          popup->removeItemAt(popup->count() - 1) ;
          popup->removeItemAt(popup->count() - 1) ;
          doRemove = FALSE;
        }
      popup->popup(mapToGlobal(QPoint(e->x(),e->y())));
    }
}

void UserList::addRequest()
{
  ContactItem *item;
  unsigned long uin;
  uin = getItem(currentItem())->getInfo().uin;
  item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(uin);
  if(item)
  {
    ((MainWindow*)(kapp->topWidget()))->saveUser(*item);
    addToContactListByUIN(item->uin);
    if(((MainWindow*)(kapp->topWidget()))->isLogged())
      icq_SendNewUser(item->uin);
    ((MainWindow*)(kapp->topWidget()))->updateContact();
  }
}

UserItem *UserList::getItem(int i)
{
  return (UserItem*)item(i);
}

void UserList::setStatus(unsigned long uin, unsigned long status)
{
  UserItem *ptr, *usritem;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
    {
      ptr->setStatus(status);
      if(status!=(unsigned long)STATUS_OFFLINE)
      {
        usritem = new UserItem(ptr);
        onlineList.insert(0, usritem);
        offlineList.remove(ptr);
      }
    }
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
    {
      ptr->setStatus(status);
      if(status==(unsigned long)STATUS_OFFLINE)
      {
        usritem = new UserItem(ptr);
        offlineList.insert(0, usritem);
        onlineList.remove(ptr);
      }
    }
  changeList();
}

void UserList::addMsg(unsigned long uin, TimeStr time, const char *body)
{
  icqMessage *msg = new icqMessage(uin,time,body,MSG_RECV);
  addMsg(uin, msg);
}

void UserList::addMsg(unsigned long uin, TimeStr time, const char *url, const char *desc)
{
  icqMessage *msg = new icqMessage(uin,time,url,desc,MSG_URL_RECV);
  addMsg(uin, msg);
}

void UserList::addMsg(unsigned long uin, icqMessage *msg)
{
  if(!msg)
    printf("UserList::addMsg(uin=%lu, msg=0L)\n", uin);
  UserItem *ptr;
  for(ptr = offlineList.first(); ptr != 0L; ptr = offlineList.next())
    if(ptr->getInfo().uin == uin)
    {
      ptr->addMsg(msg);
      changeList();
      return;
    }
  for(ptr = onlineList.first(); ptr != 0L; ptr = onlineList.next())
    if(ptr->getInfo().uin == uin)
    {
      ptr->addMsg(msg);
      changeList();
      return;
    }
  /* User is not in the list */
  for(ptr = notInList.first(); ptr != 0L; ptr = notInList.next())
    if(ptr->getInfo().uin == uin)
    {
      ptr->addMsg(msg);
      changeList();
      return;
    }
  /* User is not even in the 'Not in list' list :) */
  ContactItem ci;

  ci.uin = uin;
  ci.nick.setNum(uin);
  ci.status = (unsigned long)STATUS_OFFLINE;
  ptr = new UserItem(ci);
  notInList.append(ptr);

  if(((MainWindow*)(kapp->topWidget()))->isLogged())
    icq_SendInfoReq(uin);

  ptr->addMsg(msg);
  changeList();
}

void UserList::allOffline()
{
  UserItem *ptr;
  ptr=onlineList.first();
  while(ptr != 0L)
  {
    ptr->setStatus((unsigned long)STATUS_OFFLINE);
    offlineList.insert(0, ptr);
    onlineList.removeRef(ptr);
    ptr=onlineList.first();
  }
  changeList();
}

void UserList::appendItem(UserItem *item)
{
  item->setStatus((unsigned long)STATUS_OFFLINE);
  offlineList.append(item);
}

void UserList::changeList()
{
  UserItem *ptr, *item;
  unsigned long cur_uin = 0;
  unsigned int i;
  setAutoUpdate(FALSE);
  if(currentItem()>=0)
    cur_uin = getItem(currentItem())->UIN();
  WBlinkListBox::clear();

  if(onlineList.count()>0)
  {
    item = new UserItem(tpOnSeparator);
    insertItem(item);
    for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    {
      item = new UserItem(ptr);
      insertItem(item);
      if(item->getNumUnreadMsgs() > 0)
      {
        item->updatePixmap() ;
        setBlinking(count() - 1, TRUE);
      }
    }
  }
  if(notInList.count()>0)
  {
    item = new UserItem(tpNILSeparator);
    insertItem(item);
    for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    {
      item = new UserItem(ptr);
      insertItem(item);
      if(item->getNumUnreadMsgs() > 0)
      {
        item->updatePixmap() ;
        setBlinking(count() - 1, TRUE);
      }
    }
  }
  if(authorizeList.count()>0)
  {
    item = new UserItem(tpAuthSeparator);
    insertItem(item);
    for(ptr=authorizeList.first(); ptr != 0L; ptr=authorizeList.next())
    {
      item = new UserItem(ptr);
      insertItem(item);
      if(item->getNumUnreadMsgs() > 0)
      {
        item->updatePixmap() ;
        setBlinking(count() - 1, TRUE);
      }
    }
  }
  if(offlineList.count()>0)
  {
    item = new UserItem(tpOffSeparator);
    insertItem(item);
    for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    {
      item = new UserItem(ptr);
      insertItem(item);
      if(item->getNumUnreadMsgs() > 0)
      {
        item->updatePixmap() ;
        setBlinking(count() - 1, TRUE);
      }
    }
  }
  if(cur_uin)
    for(i=0; i<count(); i++)
      if(getItem(i)->UIN()==cur_uin)
        setCurrentItem(i);
  setAutoUpdate(TRUE);
  update();
}

void UserList::clear()
{
  WBlinkListBox::clear();
  onlineList.clear();
  offlineList.clear();
  notInList.clear();
  authorizeList.clear();
}

const char *UserList::getNickByUIN(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->nick();
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->nick();
  for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->nick();
  return "Unknown";
}

const char *UserList::getEMailByUIN(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->email();
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->email();
  for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->email();
  return "Unknown";
}

ContactItem *UserList::getInfoByUIN(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->getInfoPtr();
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->getInfoPtr();
  for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    if(ptr->getInfo().uin==uin)
      return ptr->getInfoPtr();
  return 0L;
}

void UserList::deleteByUIN(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
    {
      offlineList.removeRef(ptr);
    }
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
    {
      onlineList.removeRef(ptr);
    }
}

void UserList::updateInfoByUIN(unsigned long uin,const char *nick, const char *first,const char *last, const char *email, char auth)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      ptr->updateInfo(nick,first,last,email,auth);
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      ptr->updateInfo(nick,first,last,email,auth);
  for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    if(ptr->getInfo().uin==uin)
      ptr->updateInfo(nick,first,last,email,auth);
  changeList();
}

int UserList::isUINInContactList(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      return TRUE;
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      return TRUE;
  return FALSE;
}

int UserList::isUINOffline(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=offlineList.first(); ptr != 0L; ptr=offlineList.next())
    if(ptr->getInfo().uin==uin)
      return TRUE;
  return FALSE;
}

int UserList::isUINOnline(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=onlineList.first(); ptr != 0L; ptr=onlineList.next())
    if(ptr->getInfo().uin==uin)
      return TRUE;
  return FALSE;
}

int UserList::isUINNotInList(unsigned long uin)
{
  UserItem *ptr;
  for(ptr=notInList.first(); ptr != 0L; ptr=notInList.next())
    if(ptr->getInfo().uin==uin)
      return TRUE;
  return FALSE;
}

UserItem *UserList::getItemByUIN(unsigned long uin)
{
  UserItem *ptr;
  for(ptr = onlineList.first(); ptr != 0L; ptr = onlineList.next())
    if(ptr->UIN() == uin)
      return ptr;
  for(ptr = offlineList.first(); ptr != 0L; ptr = offlineList.next())
    if(ptr->UIN() == uin)
      return ptr;
  for(ptr = notInList.first(); ptr != 0L; ptr = notInList.next())
    if(ptr->UIN() == uin)
      return ptr;
  return 0L;
}

void UserList::setBlinkingByUIN(unsigned long uin,int b)
{
  UserItem *ptr ;
  int count = 0 ;

  if(onlineList.count())
    count++; // This one is for separator
  for(ptr = onlineList.first() ; ptr != 0L ; ptr = onlineList.next())
  {
    if(ptr->getInfo().uin == uin)
    {
      ptr->updatePixmap() ;
      setBlinking(count,b) ;
      return ;
    }
    count++;
  }

  if(notInList.count())
    count++; // This one is for separator too
  for(ptr = notInList.first() ; ptr != 0L ; ptr = notInList.next())
  {
    if(ptr->getInfo().uin == uin)
    {
      ptr->updatePixmap() ;
      setBlinking(count,b) ;
      return ;
    }
    count++;
  }

  if(offlineList.count())
    count++; // This one is for separator (surprise! surprise!)
  for(ptr = offlineList.first() ; ptr != 0L ; ptr = offlineList.next())
  {
    if(ptr->getInfo().uin == uin)
    {
      ptr->updatePixmap() ;
      setBlinking(count,b) ;
      return ;
    }
    count++;
  }
}

void UserList::addToContactListByUIN(unsigned long uin)
{
  UserItem *ptr;
  ptr=notInList.first();
  while(ptr != 0L)
  {
    if(ptr->getInfo().uin == uin)
    {
      offlineList.insert(0, ptr);
      notInList.removeRef(ptr);
      ptr=notInList.first();
    }
    else
      ptr = notInList.next();
  }
  changeList();
}

void UserList::delNotInListByUIN(unsigned long uin)
{
  UserItem *ptr;
  ptr=notInList.first();
  while(ptr != 0L)
  {
    if(ptr->getInfo().uin == uin)
    {
      notInList.removeRef(ptr);
      delete ptr;
      ptr=notInList.first();
    }
    else
      ptr = notInList.next();
  }
  changeList();
}
