// $Id: renwindow.cpp,v 1.3 1998/12/08 16:29:48 denis Exp $
// $Log: renwindow.cpp,v $
// Revision 1.3  1998/12/08 16:29:48  denis
// Cleaned up a little before releasing
//

#include "renwindow.h"
#include "mainwindow.h"

#include "renwindow.moc"

RenameWindow::RenameWindow(QString name, unsigned long puin, QString nick, QString first, QString last, QString email) : QDialog()
{
  QString txt;
  txt.sprintf("Rename user %s to:", (const char*)name);
  uin = puin;
  label = new QLabel(txt,this);
  aliasbox = new QComboBox(TRUE, this);
  aliasbox->setInsertionPolicy(QComboBox::NoInsertion);
  if(!nick.isEmpty() && nick!="N/A")
    aliasbox->insertItem(nick);
  if(!first.isEmpty() && first!="N/A" && first!=nick)
    aliasbox->insertItem(first);
  if(!last.isEmpty() && last!="N/A" && last!=nick)
    aliasbox->insertItem(last);
  if(!first.isEmpty() && !last.isEmpty() && first!="N/A" && last!="N/A")
    aliasbox->insertItem(first+" "+last);
  if(!email.isEmpty() && email!="N/A")
    aliasbox->insertItem(email);
  txt.setNum(uin);
  aliasbox->insertItem(txt);
  okbtn = new QPushButton("Ok", this);
  okbtn->setDefault(TRUE);
  connect(okbtn, SIGNAL(clicked()), SLOT(accept()));
  cancelbtn = new QPushButton("Cancel", this);
  connect(cancelbtn, SIGNAL(clicked()), SLOT(reject()));
  setCaption("Rename User");
  aliasbox->setFocus();
  resize(250,100);
  setMinimumSize(250,100);
}

RenameWindow::~RenameWindow()
{
  if(label)
    delete label;
  if(aliasbox)
    delete aliasbox;
  if(okbtn)
    delete okbtn;
  if(cancelbtn)
    delete cancelbtn;
}

void RenameWindow::resizeEvent(QResizeEvent *re)
{
  QSize labelsize, aliasboxsize, okbtnsize, cancelbtnsize;
  QWidget::resizeEvent(re);
  labelsize = label->sizeHint();
  aliasboxsize = aliasbox->sizeHint();
  okbtnsize = okbtn->sizeHint();
  cancelbtnsize = cancelbtn->sizeHint();
  int w = width()-30;
  int h = QMAX(okbtnsize.height(), cancelbtnsize.height());
  label->setGeometry((width()-w)/2,(height()-labelsize.height()-aliasboxsize.height()-h-10)/2,w,labelsize.height());
  aliasbox->setGeometry((width()-w)/2,(height()-labelsize.height()-aliasboxsize.height()-h-10)/2+labelsize.height()+3,w,aliasboxsize.height());
  w = QMAX(okbtnsize.width(), cancelbtnsize.width());
  okbtn->setGeometry((width()-w*2-10)/2,height()-h-8,w,h);
  cancelbtn->setGeometry(okbtn->x()+w+10,height()-h-8,w,h);
}

unsigned long RenameWindow::UIN()
{
  return uin;
}

void RenameWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
  ((MainWindow*)(kapp->topWidget()))->delRenWin(this);
}

void RenameWindow::accept()
{
  ((MainWindow*)(kapp->topWidget()))->renameUser(uin, aliasbox->currentText());
  QDialog::accept();
  ((MainWindow*)(kapp->topWidget()))->delRenWin(this);
}

void RenameWindow::reject()
{
  QDialog::reject();
  ((MainWindow*)(kapp->topWidget()))->delRenWin(this);
}

void RenameWindow::done(int p)
{
  QDialog::done(p);
  ((MainWindow*)(kapp->topWidget()))->delRenWin(this);
}
