#ifndef _MAINWINDOW_
#define _MAINWINDOW_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <qlistbox.h>
#include <qwidget.h>
#include <qpushbt.h>
#include <qsocknot.h>
#include <qmsgbox.h>
#include <icq.h>
#include "userlist.h"
#include "useritem.h"
#include "systembar.h"
#include "connectbutton.h"
#include "preferences.h"
#include "findwindow.h"
#include "infowindow.h"
#include "msgwindow.h"
#include "recvwindow.h"
#include "docking.h"
#include "urlsndwin.h"
#include "renwindow.h"
#include "historywin.h"
#include "alertbox.h"

#define MENU_SHUTDOWN		  1
#define MENU_PREFERENCES	2

class MainWindow : public KTopLevelWidget {
  Q_OBJECT
public:
  MainWindow();
  ~MainWindow();
  void loadConfig();
  void saveConfig(unsigned long, const char*, const char*, const char*, unsigned short, int, const char*, unsigned short, int, const char*, const char*, int, const char*, int, int, int, int, int, int, int, int);
  void saveProperties();
  void saveStatus();
  UserList *listWidget();
  DockWidget *dockWidget();
  FindWindow *findWindow();
  int isLogged();
  void saveUser(unsigned long, QString, QString, QString, QString, unsigned char);
  void saveUser(ContactItem);
  void initContact();
  void updateContact();
  void infoWindow(unsigned long);
  void infoShow(ContactItem, int loc = TRUE);
  void delInfoWin(InfoWindow*);
  void delSendWin(MsgWindow*);
  void delURLSendWin(URLSndWindow*);
  void delRecvWin(RecvWindow*);
  void delRenWin(RenameWindow*);
  void delHistoryWin(HistoryWindow *) ;
  void delAlertWin(AlertMsgBox*);
  void addAlertWin(unsigned long);
  void updateHistoryWindows(unsigned long) ;  
  void infoReplyHandler(unsigned long, const char*, const char*, const char*, const char*, char);
  void infoExtReplyHandler(unsigned long, const char*, unsigned short, char, const char*, unsigned short, char, const char*, const char*, const char*);
  static void logEvent(time_t, unsigned char, const char*);
  int isCloseRecv();
  int isConvertCRLF();
  int isQuote();
  icqStatus status();
  void setIcon(QPixmap);
  void setBlinking(int);
  void togglePixmap(int);
  QString contactsDir();
  QPopupMenu *stateMenu();
  int isUnreadMsgs();
  unsigned long getFirstUnreadMsgUIN();
  void renameUser(unsigned long, const char*);
  void setBlinkPixmap(const char *) ;
  void setToolTip();
  void updateBlinking();
public slots:
  void menuCommand();
  void stateCommand();
  void recvRequest();
  void recvRequest(int);
  void messageRequest();
  void messageRequest(int);
  void messageRequest(unsigned long, const char*);
  void urlRequest();
  void urlRequest(int);
  void historyRequest() ;
  void historyRequest(int) ;
  void readFirstRequest();
  void addCommand();
  void setStatus(int);
  void setLogStatus();
  void debug1Request();
  void debug2Request();
  void icqCommand(int);
  void infoRequest();
  void onlineAlert();
  void visibleUser();
  void delUserRequest();
  void renameRequest();
  const char *logFile();
signals:
protected:
  int logged;
  int keepalivetimer;
  unsigned long uin;
  QString passwd;
  QString nick;
  QString server;
  unsigned short port;
  int useproxy;
  QString proxyhost;
  unsigned short proxyport;
  int proxyauth;
  QString proxyuser, proxypass;
  QString logfile;
  int bell;
  int playWav;
  int userPlay;
  int closeRecv;
  int convertCRLF;
  int quote;
  int reconnect;
  icqStatus log_status;
  icqStatus cur_status;
  QWidget *panelwidget;
  UserList *listwidget;
  SystemBar *syswidget;
  DockWidget *dockwidget;
  QPushButton *menubutton;
  ConnectButton *statebutton;
  QPushButton *addbutton;
  QPopupMenu *statemenu;
  QPopupMenu *icqmenu;
  Preferences *prefwin;
  FindWindow *findwin;
  QString appdir, contdir;
  QPixmap blinkPixmap[2];
  QPixmap stateIcon;
  int blinkFlag;
  int blinkPixNum;
  QList<InfoWindow> infoWinList;
  QList<MsgWindow> sendWinList;
  QList<URLSndWindow> sendURLWinList;
  QList<RecvWindow> recvWinList;
  QList<RenameWindow> renWinList;
  QList<HistoryWindow> historyWinList ;
  QList<AlertMsgBox> alertWinList;
  int icqSocket, icqProxySocket;
  QSocketNotifier *socketnotifier, *proxynotifier;
  void resizeEvent(QResizeEvent *);
  void closeEvent(QCloseEvent *);
  void setupGUICallbacks();
  static void loggedIn();
  static void disconnected();
  static void userOnline(unsigned long, unsigned long, unsigned long, unsigned long, unsigned long);
  static void userStatusUpdate(unsigned long, unsigned long);
  static void userOffline(unsigned long);
  static void message(unsigned long, unsigned char, unsigned char, unsigned char, unsigned char, unsigned short, const char*);
  static void url(unsigned long, unsigned char, unsigned char, unsigned char, unsigned char, unsigned short, const char*, const char*);
  static void infoReply(unsigned long, const char*, const char*, const char*, const char*, char);
  static void infoExtReply(unsigned long, const char*, unsigned short, char, const char*, unsigned short, char, const char*, const char*, const char*);
  static void srvAck(unsigned short);
/*  static void url(URL *);
  static void added(ADDED *); */
  virtual void timerEvent(QTimerEvent *);
  void login(unsigned long);
  void disconnect();
  int checkConfig();
  void setTitle();
  QStrList getUINDirList();
  void stopAll();
  void closeSendWin(unsigned short);
  void closeURLSendWin(unsigned short);
  void updateRecvWindows();
protected slots:
  void dataReceived(int);
  void quitRequest();
private:
private slots:
};
#endif /* _MAINWINDOW_ */
