// $Id: mainwindow.cpp,v 1.23 1998/12/08 16:22:58 denis Exp $
// $Log: mainwindow.cpp,v $
// Revision 1.23  1998/12/08 16:22:58  denis
// getFirstUnreadMsgUIN method added
// setToolTip with updateBlinking methods added
// Reconnect on disconnect preference option added
// Cleaned up a little before releasing
//
// Revision 1.22  1998/11/25 19:17:23  denis
// Hopefully fixed icq_HandleProxyResponse bug
//
// Revision 1.21  1998/11/25 17:47:56  denis
// QSocketNotifier for proxy socket fixed, I hope
// Commented out previous fix

#include <qdir.h>
#include <kapp.h>
#include <kiconloader.h>
#include <ksimpleconfig.h>
#include <kwm.h>
#include <qmsgbox.h>
#include <qstrlist.h>
#include <qregexp.h>
#include <sys/stat.h>  // for mkdir()
#include <unistd.h>    // for unlink()
#include "mainwindow.h"

#include "mainwindow.moc"

MainWindow::MainWindow() : KTopLevelWidget()
{
  KIconLoader *il = kapp->getIconLoader();
  resize(150,250);
  setMinimumSize(150,250);
  panelwidget = new QWidget(this);
  setView(panelwidget);
  listwidget = new UserList(panelwidget);

  statemenu = new QPopupMenu();
  statemenu->insertItem(il->loadIcon("online.xpm"),"Online/Connect",stOnline);
  statemenu->insertItem(il->loadIcon("away.xpm"),"Away",stAway);
  statemenu->insertItem(il->loadIcon("na.xpm"),"N/A (Extended Away)",stNA);
  statemenu->insertItem(il->loadIcon("occupied.xpm"),"Occupied (Urgent Msgs)",stOccupied);
  statemenu->insertItem(il->loadIcon("dnd.xpm"),"DND (Do not Disturb)",stDND);
  statemenu->insertItem(il->loadIcon("privacy.xpm"),"Privacy (Invisible)",stInvisible);
  statemenu->insertItem(il->loadIcon("freechat.xpm"),"Free for Chat",stFFC);
  statemenu->insertItem(il->loadIcon("offline.xpm"),"Offline/Disconnect",stOffline);
  statemenu->setMouseTracking(TRUE);
  connect(statemenu, SIGNAL(activated(int)), SLOT(setStatus(int)));

  dockwidget = new DockWidget();
  dockwidget->setIcon(il->loadIcon("offline.xpm")); // Why this doesn't work???
  dockwidget->dock();
  connect(dockwidget, SIGNAL(quitClicked()), this, SLOT(quitRequest()));

  addbutton = new QPushButton("Search/Add Users",panelwidget);
  connect(addbutton, SIGNAL(clicked()), SLOT(addCommand()));

  syswidget = new SystemBar(panelwidget);

  menubutton = new QPushButton("ICQ",panelwidget);
  connect(menubutton, SIGNAL(clicked()), SLOT(menuCommand()));
  statebutton = new ConnectButton(panelwidget);
  connect(statebutton, SIGNAL(clicked()), SLOT(stateCommand()));

  icqmenu = new QPopupMenu();
  icqmenu->insertItem(il->loadIcon("search.xpm"),"Search/Add Users",this,SLOT(addCommand()));
  icqmenu->insertSeparator();
  icqmenu->insertItem(il->loadIcon("setup.xpm"),"Preferences",MENU_PREFERENCES);
  icqmenu->insertSeparator();
  icqmenu->insertItem(il->loadIcon("shutdown.xpm"),"Shut Down",MENU_SHUTDOWN);
  icqmenu->setMouseTracking(TRUE);
  connect(icqmenu, SIGNAL(activated(int)), SLOT(icqCommand(int)));

  blinkPixmap[0] = il->loadIcon("message.xpm");
  blinkPixmap[1] = il->loadIcon("null.xpm");
  blinkFlag = 0;

  prefwin = new Preferences();
  if(!checkConfig())
  {
    prefwin->setUser(0,"","");
    prefwin->setServer("icq1.mirabilis.com",4000);
    prefwin->setProxy(FALSE, "", 1080, FALSE, "", "");
    prefwin->setLogging(0, "");
    prefwin->setSound(TRUE, FALSE, FALSE);
    prefwin->setOther(FALSE, TRUE, TRUE, FALSE, TRUE);
    if(prefwin->exec()==QDialog::Rejected)
      exit(1);
  }

  appdir = kapp->localkdedir()+"/share/apps";
  mkdir((const char*)appdir,0700);
  appdir += "/kicq";
  mkdir((const char*)appdir,0700);
  contdir = appdir + "/contacts";
  mkdir((const char*)contdir,0700);

  infoWinList.setAutoDelete(TRUE);
  sendWinList.setAutoDelete(TRUE);
  sendURLWinList.setAutoDelete(TRUE);
  recvWinList.setAutoDelete(TRUE);
  renWinList.setAutoDelete(TRUE);
  historyWinList.setAutoDelete(TRUE);
  alertWinList.setAutoDelete(TRUE);

  findwin = new FindWindow();

  logged = FALSE;
  log_status = stOffline;
  socketnotifier = 0L;
  proxynotifier = 0L;
  keepalivetimer = -1;

  setupGUICallbacks();
  loadConfig();
  setTitle();
  initContact();
}

MainWindow::~MainWindow()
{
  if(socketnotifier)
    delete socketnotifier;
  if(proxynotifier)
    delete proxynotifier;
  if(findwin)
    delete findwin;
  if(prefwin)
    delete prefwin;
  if(listwidget)
    delete listwidget;
  if(addbutton)
    delete addbutton;
  if(syswidget)
    delete syswidget;
  if(menubutton)
    delete menubutton;
  if(statebutton)
    delete statebutton;
  if(statemenu)
  {
    statemenu->clear();
    delete statemenu;
  }
  if(icqmenu)
  {
    icqmenu->clear();
    delete icqmenu;
  }
  if(panelwidget)
    delete panelwidget;
  if(dockwidget)
    delete dockwidget;
}

void MainWindow::setTitle()
{
  QString title;
  title.setNum(uin);
  setCaption(title);
}

void MainWindow::initContact()
{
  UserItem *useritem;
  ContactItem item;
  unsigned i;
  unsigned long cur_uin = 0;
  char buf[1024] = "\0";
  QString contfile, uinstr, aboutfname, notesfname;

  if(listwidget->currentItem()>=0)
    cur_uin = listwidget->getItem(listwidget->currentItem())->UIN();
  listwidget->clear();
  icq_ContClear();
  QStrList usrlist = getUINDirList();
  for(i=0; i<usrlist.count(); i++)
  {
    contfile = contdir+"/"+usrlist.at(i);
    KSimpleConfig usrcfg((const char*)contfile);
    usrcfg.setGroup("Info");
    uinstr = usrlist.at(i);
    uinstr.resize(uinstr.find(".")+1);
    item.uin = strtoul(uinstr, 0, 10);
    item.nick = usrcfg.readEntry("Nick", "N/A");
    item.email = usrcfg.readEntry("EMail", "N/A");
    item.firstName = usrcfg.readEntry("FirstName", "N/A");
    item.lastName = usrcfg.readEntry("LastName", "N/A");
    item.alias = usrcfg.readEntry("Alias","");
    if(item.alias.isEmpty())
      if(!item.nick.isEmpty() && item.nick!="N/A")
        item.alias = item.nick;
      else if(!item.firstName.isEmpty() && item.firstName!="N/A")
        item.alias = item.firstName;
      else if(!item.lastName.isEmpty() && item.lastName!="N/A")
        item.alias = item.lastName;
      else if(!item.email.isEmpty() && item.email!="N/A")
        item.alias = item.email;
      else
        item.alias.setNum(item.uin);
    item.city = usrcfg.readEntry("City", "N/A");
    item.state = usrcfg.readEntry("State", "N/A");
    item.zip = usrcfg.readEntry("Zip", "N/A");
    item.country = usrcfg.readNumEntry("Country", 0);
    item.countryStat = usrcfg.readNumEntry("CountryStatus", 0);
    item.homePage = usrcfg.readEntry("HomePage", "N/A");
    item.age = usrcfg.readUnsignedNumEntry("Age", 0);
    item.phone = usrcfg.readEntry("Phone", "N/A");
    item.gender = usrcfg.readUnsignedNumEntry("Gender", 0);
    item.onlineAlert = usrcfg.readNumEntry("OnlineAlert", 0);
    item.visibleUser = usrcfg.readNumEntry("VisibleUser", 0);
    aboutfname = contdir+"/"+uinstr+".about";
    QFile aboutfile(aboutfname);
    if(aboutfile.exists())
    {
      aboutfile.open(IO_ReadOnly);
      aboutfile.readBlock(buf, aboutfile.size());
      buf[aboutfile.size()] = 0;
      item.about = (const char*)buf;
      aboutfile.close();
    }
    else
      item.about = "";
    notesfname = contdir+"/"+uinstr+".notes";
    QFile notesfile(notesfname);
    if(notesfile.exists())
    {
      notesfile.open(IO_ReadOnly);
      notesfile.readBlock(buf, notesfile.size());
      buf[notesfile.size()] = 0;
      item.notes = (const char*)buf;
      notesfile.close();
    }
    else
      item.notes = "";
    item.status = (unsigned long)STATUS_OFFLINE;
    icq_ContAddUser(item.uin);
    if(item.visibleUser)
      icq_ContSetVis(item.uin);
    useritem = new UserItem(item);
    listwidget->appendItem(useritem);
  }
  listwidget->changeList();
  if(cur_uin)
    for(i=0; i<listwidget->count(); i++)
      if(listwidget->getItem(i)->UIN()==cur_uin)
        listwidget->setCurrentItem(i);
  if(isLogged())
    icq_SendContactList();
}

void MainWindow::updateContact()
{
  ContactItem *item;
  unsigned i;
  unsigned long uin;
  QString contfile, uinstr, aboutfname, notesfname;
  char buf[1024] = "\0";

  icq_ContClear();
  QStrList usrlist = getUINDirList();
  for(i=0; i<usrlist.count(); i++)
  {
    contfile = contdir+"/"+usrlist.at(i);
    KSimpleConfig usrcfg((const char*)contfile);
    usrcfg.setGroup("Info");
    uinstr = usrlist.at(i);
    uinstr.resize(uinstr.find(".")+1);
    uin = strtoul(uinstr, 0, 10);
    item = listwidget->getInfoByUIN(uin);
    if(!item)
    {
      ContactItem newitem;
      UserItem *useritem;
      newitem.uin = uin;
      useritem = new UserItem(newitem);
      listwidget->appendItem(useritem);
      item = listwidget->getInfoByUIN(uin);
      if(isLogged())
        icq_SendNewUser(uin);
    }
    item->nick = usrcfg.readEntry("Nick", "N/A");
    item->email = usrcfg.readEntry("EMail", "N/A");
    item->firstName = usrcfg.readEntry("FirstName", "N/A");
    item->lastName = usrcfg.readEntry("LastName", "N/A");
    item->alias = usrcfg.readEntry("Alias","");
    if(item->alias.isEmpty())
      if(!item->nick.isEmpty() && item->nick!="N/A")
        item->alias = item->nick;
      else if(!item->firstName.isEmpty() && item->firstName!="N/A")
        item->alias = item->firstName;
      else if(!item->lastName.isEmpty() && item->lastName!="N/A")
        item->alias = item->lastName;
      else if(!item->email.isEmpty() && item->email!="N/A")
        item->alias = item->email;
      else
        item->alias.setNum(item->uin);
    item->city = usrcfg.readEntry("City", "N/A");
    item->state = usrcfg.readEntry("State", "N/A");
    item->zip = usrcfg.readEntry("Zip", "N/A");
    item->country = usrcfg.readNumEntry("Country", 0);
    item->countryStat = usrcfg.readNumEntry("CountryStatus", 0);
    item->homePage = usrcfg.readEntry("HomePage", "N/A");
    item->age = usrcfg.readUnsignedNumEntry("Age", 0);
    item->phone = usrcfg.readEntry("Phone", "N/A");
    item->gender = usrcfg.readUnsignedNumEntry("Gender", 0);
    item->onlineAlert = usrcfg.readNumEntry("OnlineAlert", 0);
    item->visibleUser = usrcfg.readNumEntry("VisibleUser", 0);
    aboutfname = contdir+"/"+uinstr+".about";
    QFile aboutfile(aboutfname);
    if(aboutfile.exists())
    {
      aboutfile.open(IO_ReadOnly);
      aboutfile.readBlock(buf, aboutfile.size());
      buf[aboutfile.size()] = 0;
      item->about = (const char*)buf;
      aboutfile.close();
    }
    else
      item->about = "";
    notesfname = contdir+"/"+uinstr+".notes";
    QFile notesfile(notesfname);
    if(notesfile.exists())
    {
      notesfile.open(IO_ReadOnly);
      notesfile.readBlock(buf, notesfile.size());
      buf[notesfile.size()] = 0;
      item->notes = (const char*)buf;
      notesfile.close();
    }
    else
      item->notes = "";
    icq_ContAddUser(item->uin);
    if(item->visibleUser)
      icq_ContSetVis(item->uin);
  }
  listwidget->changeList();
}

int MainWindow::checkConfig()
{
  KConfig *config = kapp->getConfig();
  config->setGroup("User");
  unsigned long uin = config->readUnsignedLongNumEntry("UIN");
  if(!uin)
    return FALSE;
  else
    return TRUE;
}

void MainWindow::loadConfig()
{
  KConfig *config = kapp->getConfig();
  config->setGroup("User");
  uin = config->readUnsignedLongNumEntry("UIN");
  passwd = config->readEntry("Password","");
  nick = config->readEntry("Nick","");
  config->setGroup("Server");
  server = config->readEntry("Host","");
  port = config->readUnsignedNumEntry("Port",4000);
  config->setGroup("Proxy");
  useproxy = config->readNumEntry("Use",FALSE);
  proxyhost = config->readEntry("Host", "");
  proxyport = config->readUnsignedNumEntry("Port",1080);
  proxyauth = config->readNumEntry("Auth",FALSE);
  proxyuser = config->readEntry("User","");
  proxypass = config->readEntry("Password","");
  config->setGroup("Sound");
  bell = config->readNumEntry("Bell", TRUE);
  playWav = config->readNumEntry("playWav", FALSE);
  userPlay = config->readNumEntry("userPlay", FALSE);
  config->setGroup("Other");
  icq_Russian = config->readNumEntry("Koi2win", FALSE);
  closeRecv = config->readNumEntry("CloseRecv", TRUE);
  convertCRLF = config->readNumEntry("ConvertCRLF", TRUE);
  quote = config->readNumEntry("Quote", FALSE);
  reconnect = config->readNumEntry("Reconnect", TRUE);
  icqStatus st = (icqStatus)config->readNumEntry("Status", stOffline);
  config->setGroup("Log");
  icq_LogLevel = config->readNumEntry("Level",0);
  logfile = config->readEntry("File","");
  config->setGroup("Properties");
  QString prop = config->readEntry("Main");
  if(!prop.isEmpty())
    setGeometry(KWM::setProperties(winId(), prop));
  if(config->readNumEntry("Restored", TRUE))
    show();
  setStatus(st);
}

void MainWindow::closeEvent(QCloseEvent*)
{
/* Until we don't know how to get "minimize window" event
   MainWindow will be docked on "close window" event */
/*  KTopLevelWidget::closeEvent(e);
  quitRequest();*/
  dockwidget->hideWindow() ;
}

void MainWindow::resizeEvent(QResizeEvent *re)
{
  KTopLevelWidget::resizeEvent(re);
  menubutton->setGeometry(0,panelwidget->height()-25,40,25);
  statebutton->setGeometry(42,panelwidget->height()-25,panelwidget->width()-42,25);
  syswidget->setGeometry(0,menubutton->y()-syswidget->itemHeight(0)-6,
                         panelwidget->width(),syswidget->itemHeight(0)+4);
  addbutton->setGeometry(0,syswidget->y()-22,panelwidget->width(),20);
  listwidget->setGeometry(0,0,panelwidget->width(),addbutton->y()-2);
}

void MainWindow::menuCommand()
{
  icqmenu->move(-1000,-1000);
  icqmenu->show();
  QPoint pos = menubutton->mapToGlobal(QPoint(0,0));
  pos.setY(pos.y()-icqmenu->height());
  icqmenu->popup(pos);
}

void MainWindow::stateCommand()
{
  statemenu->move(-1000,-1000);
  statemenu->show();
  QPoint pos = statebutton->mapToGlobal(QPoint(0,0));
  pos.setY(pos.y()-statemenu->height());
  statemenu->popup(pos);
}

void MainWindow::quitRequest()
{
  saveProperties();
  saveStatus();
  kapp->quit();
}

void MainWindow::icqCommand(int num)
{
  switch(num)
  {
    case MENU_SHUTDOWN:
      quitRequest();
      break;
    case MENU_PREFERENCES:
      prefwin->setUser(uin,nick,passwd);
      prefwin->setServer(server,port);
      prefwin->setProxy(useproxy, proxyhost, proxyport, proxyauth, proxyuser, proxypass);
      prefwin->setLogging(icq_LogLevel, logfile);
      prefwin->setSound(bell, playWav, userPlay);
      prefwin->setOther(icq_Russian, closeRecv, convertCRLF, quote, reconnect);
      if(prefwin->exec()==QDialog::Accepted)
      {
        loadConfig();
        setTitle();
      }
      break;
  }
}

void MainWindow::recvRequest()
{
  if(listwidget->currentItem()>=0)
    recvRequest(listwidget->currentItem());
}

void MainWindow::recvRequest(int num)
{
  UserItem *usritem = listwidget->getItem(num);
  if(usritem->type()!=tpOnSeparator && usritem->type()!=tpOffSeparator &&
     usritem->type()!=tpNILSeparator)
  {
    /* If we have any new messages here, we must show them */
    /* otherwise display new message window */
    if(usritem->getNumUnreadMsgs() != 0)
    {
      RecvWindow *recvwin = 0L, *ptr;
      for(ptr = recvWinList.first(); ptr != 0L; ptr = recvWinList.next())
        if(ptr->UIN() == usritem->getInfo().uin)
          recvwin = ptr;
      if(!recvwin)
      {
        recvwin = new RecvWindow(usritem->getListPtr(),
          usritem->getListPtr()->count() - usritem->getNumUnreadMsgs(),
          usritem->getInfo().uin,TRUE);
        recvwin->show();
        recvWinList.append(recvwin);
      }
      else
        recvwin->raise();
    }
    else
      messageRequest(num);
  }
}

void MainWindow::messageRequest()
{
  if(listwidget->currentItem()>=0)
    messageRequest(listwidget->currentItem());
}

void MainWindow::messageRequest(int num)
{
  UserItem *usritem = listwidget->getItem(num);
  MsgWindow *msgwin = new MsgWindow(usritem->nick(),usritem->UIN(),usritem->email(),0L);
  sendWinList.append(msgwin);
  msgwin->show();
}

void MainWindow::messageRequest(unsigned long uin, const char *msg)
{
  MsgWindow *msgwin;
  ContactItem *item = listwidget->getInfoByUIN(uin);
  if(item)
  {
    msgwin = new MsgWindow(item->nick, item->uin, item->email, msg);
    sendWinList.append(msgwin);
    msgwin->show();
  }
}

void MainWindow::urlRequest()
{
  if(listwidget->currentItem()>=0)
    urlRequest(listwidget->currentItem());
}

void MainWindow::urlRequest(int num)
{
  UserItem *usritem = listwidget->getItem(num);
  URLSndWindow *urlwin = new URLSndWindow(usritem->nick(),usritem->UIN(),usritem->email());
  sendURLWinList.append(urlwin);
  urlwin->show();
}

void MainWindow::historyRequest()
{
  if(listwidget->currentItem()>=0)
    historyRequest(listwidget->currentItem());
}

void MainWindow::historyRequest(int num)
{
  UserItem *usritem = listwidget->getItem(num);
  HistoryWindow *hwin = new HistoryWindow(usritem->UIN()) ;
  historyWinList.append(hwin) ;
  hwin->show() ;
}

void MainWindow::readFirstRequest()
{
  unsigned int i;
  for(i=0; i<listwidget->count(); i++)
    if(listwidget->getItem(i)->type()==tpUser)
      if(listwidget->getItem(i)->getNumUnreadMsgs())
      {
        recvRequest(i);
        return;
      }
}

void MainWindow::addCommand()
{
  findwin->show();
  findwin->raise();
}

void MainWindow::debug1Request()
{
  if(listwidget->currentItem()>=0)
  {
    UserItem *usritem = listwidget->getItem(listwidget->currentItem());
    message(usritem->UIN(),22,45,19,10,1998,"This is a test message\n");
//    userOnline(usritem->UIN(), STATUS_ONLINE, 0x0a0a0a0a, 0, 0);
  }
}

void MainWindow::debug2Request()
{
  if(listwidget->currentItem()>=0)
  {
    UserItem *usritem = listwidget->getItem(listwidget->currentItem());
    url(usritem->UIN(),22,45,19,10,1998,"http://www.cn.ua/~denis/kde/kicq.html","kicq home page");
//    userOffline(usritem->UIN());
  }
}

void MainWindow::userOnline(unsigned long uin, unsigned long status, unsigned long ip, unsigned long port, unsigned long r_ip)
{
  ((MainWindow*)(kapp->topWidget()))->listwidget->setStatus(uin,status);
  ((MainWindow*)(kapp->topWidget()))->listwidget->getInfoByUIN(uin)->lastIp = ip;
  ((MainWindow*)(kapp->topWidget()))->listwidget->getInfoByUIN(uin)->realIp = r_ip;
  ((MainWindow*)(kapp->topWidget()))->listwidget->getInfoByUIN(uin)->port = port;
  ((MainWindow*)(kapp->topWidget()))->listwidget->changeList();
  if(((MainWindow*)(kapp->topWidget()))->listwidget->getInfoByUIN(uin)->onlineAlert)
    ((MainWindow*)(kapp->topWidget()))->addAlertWin(uin);
}

void MainWindow::userStatusUpdate(unsigned long uin, unsigned long status)
{
  ((MainWindow*)(kapp->topWidget()))->listwidget->setStatus(uin,status);
}

void MainWindow::userOffline(unsigned long uin)
{
  ((MainWindow*)(kapp->topWidget()))->listwidget->setStatus(uin,(unsigned long)STATUS_OFFLINE);
}

void MainWindow::infoRequest()
{
  ContactItem *info;
  if(listwidget->currentItem()>=0)
  {
    info = listwidget->getItem(listwidget->currentItem())->getInfoPtr();
    if(listwidget->isUINNotInList(info->uin))
      infoShow(*info, FALSE);
    else
      infoShow(*info);
  }
}

void MainWindow::infoWindow(unsigned long uin)
{
  ContactItem *item = listwidget->getInfoByUIN(uin);
  if(item)
    infoShow(*item);
}

void MainWindow::infoShow(ContactItem info, int loc)
{
  InfoWindow *ptr, *infowin = 0L;
  for(ptr=infoWinList.first(); ptr != 0L; ptr=infoWinList.next())
  {
    if(ptr->UIN()==info.uin)
      infowin = ptr;
  }
  if(!infowin)
    infowin = new InfoWindow(loc);
  infowin->setInfo(info);
  infoWinList.append(infowin);
  infowin->show();
  infowin->raise();
}

void MainWindow::onlineAlert()
{
  ContactItem *item;
  if(listwidget->currentItem()>=0)
  {
    item = listwidget->getInfoByUIN(listwidget->getItem(listwidget->currentItem())->UIN());
    item->onlineAlert = !item->onlineAlert;
    saveUser(*item);
    listwidget->changeList();
  }
}

void MainWindow::visibleUser()
{
  ContactItem *item;
  if(listwidget->currentItem()>=0)
  {
    item = listwidget->getItem(listwidget->currentItem())->getInfoPtr();
    item->visibleUser = !item->visibleUser;
    saveUser(*item);
    if(item->visibleUser)
    {
      icq_ContSetVis(item->uin);
      if(logged)
        icq_SendVisibleList();
    }
  }
}

void MainWindow::renameRequest()
{
  UserItem *usritem;
  RenameWindow *ptr, *renwin = 0L;
  if(listwidget->currentItem()>=0)
  {
    usritem = listwidget->getItem(listwidget->currentItem());
    for(ptr = renWinList.first(); ptr != 0L; ptr = renWinList.next())
      if(ptr->UIN() == usritem->UIN())
        renwin = ptr;
    if(!renwin)
    {
      renwin = new RenameWindow(usritem->Name(),usritem->UIN(),usritem->nick(),usritem->first(),usritem->last(),usritem->email());
      renwin->show();
      renWinList.append(renwin);
    }
    else
      renwin->raise();
  }
}

void MainWindow::renameUser(unsigned long uin, const char *alias)
{
  listwidget->getInfoByUIN(uin)->alias = alias;
  saveUser(*listwidget->getInfoByUIN(uin));
  updateContact();
}

void MainWindow::delUserRequest()
{
  UserItem *usritem;
  QString uinstr, tmp;
  if(listwidget->currentItem()>=0)
  {
    usritem = listwidget->getItem(listwidget->currentItem());
    tmp.sprintf("Are you sure you want to delete user %s?",listwidget->getNickByUIN(usritem->UIN()));
    if(QMessageBox::warning(this, "Confirm", (const char*)tmp, QMessageBox::Yes, QMessageBox::No)==QMessageBox::Yes)
    {
      if(listwidget->isUINNotInList(usritem->UIN()))
      {
        if(usritem->isBlinking())
          listwidget->setBlinkingByUIN(usritem->UIN(), FALSE);
        listwidget->delNotInListByUIN(usritem->UIN());
        listwidget->changeList();
      }
      else
      {
        ContactItem *item;
        item = listwidget->getInfoByUIN(usritem->UIN());
        if(usritem->isBlinking())
          listwidget->setBlinkingByUIN(usritem->UIN(), FALSE);
        uinstr.setNum(usritem->UIN());
        unlink(contdir+"/"+uinstr+".uin");
        unlink(contdir+"/"+uinstr+".about");
        unlink(contdir+"/"+uinstr+".notes");
        unlink(contdir+"/"+uinstr+".history");
        listwidget->deleteByUIN(usritem->UIN());
        listwidget->changeList();
      }
    }
  }
}

void MainWindow::setStatus(int status)
{
  switch(status)
  {
    case stOffline:
      if(logged==TRUE)
      {
        logged = FALSE;
        icq_Logout();
      }
      statebutton->setStatus(stOffline);
      cur_status = stOffline;
      listwidget->allOffline();
      disconnect();
      break;
    case stOnline:
      if(logged==TRUE)
      {
        statebutton->setStatus(stOnline);
        icq_ChangeStatus(STATUS_ONLINE);
        cur_status = stOnline;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_ONLINE);
          log_status = stOnline;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stAway:
      if(logged==TRUE)
      {
        statebutton->setStatus(stAway);
        icq_ChangeStatus(STATUS_AWAY);
        cur_status = stAway;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_AWAY);
          log_status = stAway;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stDND:
      if(logged==TRUE)
      {
        statebutton->setStatus(stDND);
        icq_ChangeStatus(STATUS_DND);
        cur_status = stDND;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_DND);
          log_status = stDND;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stNA:
      if(logged==TRUE)
      {
        statebutton->setStatus(stNA);
        icq_ChangeStatus(STATUS_NA);
        cur_status = stNA;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_NA);
          log_status = stNA;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stOccupied:
      if(logged==TRUE)
      {
        statebutton->setStatus(stOccupied);
        icq_ChangeStatus(STATUS_OCCUPIED);
        cur_status = stOccupied;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_OCCUPIED);
          log_status = stOccupied;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stInvisible:
      if(logged==TRUE)
      {
        statebutton->setStatus(stInvisible);
        icq_ChangeStatus(STATUS_INVISIBLE);
        cur_status = stInvisible;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_INVISIBLE);
          log_status = stInvisible;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    case stFFC:
      if(logged==TRUE)
      {
        statebutton->setStatus(stFFC);
        icq_ChangeStatus(STATUS_FREE_CHAT);
        cur_status = stFFC;
      }
      else
      {
        statebutton->setStatus(stLogin);
        if(useproxy)
          icq_SetProxy(proxyhost, proxyport, proxyauth, proxyuser, proxypass);
        else
          icq_UnsetProxy();
        if(icq_Connect(server,port)!=-1)
        {
          login(STATUS_FREE_CHAT);
          log_status = stFFC;
        }
        else
          statebutton->setStatus(stOffline);
      }
      break;
    default:
      statebutton->setStatus((icqStatus)status);
      cur_status = (icqStatus)status;
      break;
  }
  setToolTip();
}

void MainWindow::setLogStatus()
{
  setStatus(log_status);
}

icqStatus MainWindow::status()
{
  return cur_status;
}

void MainWindow::login(unsigned long status)
{
  icqSocket = icq_GetSok();
  icqProxySocket = icq_GetProxySok();
  if(socketnotifier)
  {
    delete socketnotifier;
    socketnotifier = 0L;
  }
  if(proxynotifier)
  {
    delete proxynotifier;
    proxynotifier = 0L;
  }
  socketnotifier = new QSocketNotifier(icqSocket, QSocketNotifier::Read);
  connect(socketnotifier, SIGNAL(activated(int)), SLOT(dataReceived(int)));
  if(useproxy)
  {
    proxynotifier = new QSocketNotifier(icqProxySocket, QSocketNotifier::Read);
    connect(proxynotifier, SIGNAL(activated(int)), SLOT(dataReceived(int)));
  }
  icq_Init(uin, (const char*)passwd.left(8));
  icq_Login(status);
  if(keepalivetimer==-1)
    keepalivetimer = startTimer(120000);
}

void MainWindow::disconnect()
{
  stopAll();
  icq_Disconnect();
  if(socketnotifier)
  {
    delete socketnotifier;
    socketnotifier = 0L;
  }
  if(proxynotifier)
  {
    delete proxynotifier;
    proxynotifier = 0L;
  }
  killTimer(keepalivetimer);
  keepalivetimer = -1;
}

void MainWindow::dataReceived(int sok)
{
  if(sok==icqSocket)
    icq_HandleServerResponse();
  if(useproxy)
    if(sok==icqProxySocket)
      icq_HandleProxyResponse();
}

void MainWindow::setupGUICallbacks()
{
  icq_Logged = loggedIn;
  icq_Disconnected = disconnected;
  icq_UserOnline = userOnline;
  icq_UserOffline = userOffline;
  icq_UserStatusUpdate = userStatusUpdate;
  icq_RecvMessage = message;
  icq_RecvURL = url;
  icq_InfoReply = infoReply;
  icq_ExtInfoReply = infoExtReply;
  icq_SrvAck = srvAck;
  icq_Log = logEvent;
}

void MainWindow::logEvent(time_t time, unsigned char level, const char *str)
{
  char lvl[4][4] = {"fat", "err", "wrn", "msg"};
  int std = FALSE;
  FILE *log;
  struct tm *log_time;
  log = fopen(((MainWindow*)(kapp->topWidget()))->logFile(), "a");
  if(!log)
  {
    log = fdopen(1, "w");
    std = TRUE;
  }
  log_time = localtime(&time);
  fprintf(log, "%02i/%02i/%04i %02i:%02i:%02i [%s] %s", log_time->tm_mday, log_time->tm_mon+1,
          log_time->tm_year+1900, log_time->tm_hour, log_time->tm_min, log_time->tm_sec, lvl[level-1], str);
  if(!std)
    fclose(log);
}

void MainWindow::loggedIn()
{
  ((MainWindow*)(kapp->topWidget()))->logged = TRUE;
  ((MainWindow*)(kapp->topWidget()))->setLogStatus();
}

void MainWindow::disconnected()
{
  icqStatus status = ((MainWindow*)(kapp->topWidget()))->status();
  ((MainWindow*)(kapp->topWidget()))->setStatus(stOffline);
  if(((MainWindow*)(kapp->topWidget()))->reconnect)
    ((MainWindow*)(kapp->topWidget()))->setStatus(status);
}

void MainWindow::stopAll()
{
  InfoWindow *iptr;
  MsgWindow *sptr;
  findwin->stopCommand();
  for(iptr=infoWinList.first(); iptr != 0L; iptr=infoWinList.next())
    iptr->stopCommand();
  for(sptr=sendWinList.first(); sptr != 0L; sptr=sendWinList.next())
    sptr->stopCommand();
}

void MainWindow::message(unsigned long uin, unsigned char hour, unsigned char minute, unsigned char day, unsigned char month, unsigned short year, const char *data)
{
  if(((MainWindow*)(kapp->topWidget()))->bell)
    kapp->beep();
  TimeStr time(hour,minute,day,month,year);
  ((MainWindow*)(kapp->topWidget()))->listwidget->addMsg(uin,time,data);
  ((MainWindow*)(kapp->topWidget()))->updateRecvWindows();
  ((MainWindow*)(kapp->topWidget()))->updateBlinking();
}

void MainWindow::url(unsigned long uin, unsigned char hour, unsigned char minute, unsigned char day, unsigned char month, unsigned short year, const char *url, const char *desc)
{
  if(((MainWindow*)(kapp->topWidget()))->bell)
    kapp->beep();
  TimeStr time(hour,minute,day,month,year);
  ((MainWindow*)(kapp->topWidget()))->listwidget->addMsg(uin,time,url,desc);
  ((MainWindow*)(kapp->topWidget()))->updateRecvWindows();
  ((MainWindow*)(kapp->topWidget()))->updateBlinking();
}

/*
void MainWindow::added(ADDED *)
{
}
*/

void MainWindow::infoReply(unsigned long uin, const char *nick, const char *first,
                           const char *last, const char *email, char auth)
{
  ((MainWindow*)(kapp->topWidget()))->infoReplyHandler(uin, nick, first, last, email, auth);
}

void MainWindow::infoExtReply(unsigned long uin, const char *city, unsigned short country_code,
                              char country_stat, const char *state, unsigned short age,
                              char gender, const char *phone, const char *hp, const char *about)
{
  ((MainWindow*)(kapp->topWidget()))->infoExtReplyHandler(uin, city, country_code, country_stat,
                                                          state, age, gender, phone, hp, about);
}

void MainWindow::infoReplyHandler(unsigned long uin, const char *nick, const char *first,
                                  const char *last, const char *email, char auth)
{
  InfoWindow *ptr;
/* It is probably infoReply for request from InfoWindow */
  for(ptr=infoWinList.first(); ptr != 0L; ptr=infoWinList.next())
    if(ptr->UIN()==uin)
      ptr->updateInfo(nick, first, last, email, auth);

/* Or maybe it is infoReply for request from UserList about some NotInList user */
  ((MainWindow*)(kapp->topWidget()))->listwidget->updateInfoByUIN(uin,nick,first,last,email,auth);
}

void MainWindow::infoExtReplyHandler(unsigned long uin, const char *city,
     unsigned short country_code, char country_stat, const char *state,
     unsigned short age, char gender, const char *phone, const char *hp,
     const char *about)
{
  InfoWindow *ptr;
  for(ptr=infoWinList.first(); ptr != 0L; ptr=infoWinList.next())
  {
    if(ptr->UIN()==uin)
      ptr->updateExtInfo(city, country_code, country_stat, state, age,
                         gender, phone, hp, about);
  }
}

void MainWindow::srvAck(unsigned short seq)
{
  ((MainWindow*)(kapp->topWidget()))->closeSendWin(seq);
  ((MainWindow*)(kapp->topWidget()))->closeURLSendWin(seq);
}

void MainWindow::closeSendWin(unsigned short seq)
{
  MsgWindow *ptr;
  for(ptr=sendWinList.first(); ptr != 0L; ptr=sendWinList.next())
  {
    if(ptr->seq()==seq)
    {
      ptr->hide();
      ptr->saveHistory();
      delSendWin(ptr);
    }
  }
}

void MainWindow::closeURLSendWin(unsigned short seq)
{
  URLSndWindow *ptr;
  for(ptr=sendURLWinList.first(); ptr != 0L; ptr=sendURLWinList.next())
  {
    if(ptr->seq()==seq)
    {
      ptr->hide();
      ptr->saveHistory();
      delURLSendWin(ptr);
    }
  }
}

void MainWindow::timerEvent(QTimerEvent *te)
{
  if(te->timerId()==keepalivetimer)
    icq_KeepAlive();
}

void MainWindow::saveConfig(unsigned long uin, const char *nick, const char *pass,
     const char *host, unsigned short port, int pruse, const char *prhost, unsigned short prport,
     int prauth, const char *pruser, const char *prpass, int loglvl, const char *logfile, 
     int beep, int wav, int user, int rus, int closereply, int crlf, int quoteorig, int recon)
{
  KConfig *config = kapp->getConfig();
  config->setGroup("User");
  config->writeEntry("UIN",uin);
  config->writeEntry("Nick",nick);
  config->writeEntry("Password",pass);
  config->setGroup("Server");
  config->writeEntry("Host",host);
  config->writeEntry("Port",port);
  config->setGroup("Proxy");
  config->writeEntry("Use",pruse);
  config->writeEntry("Host",prhost);
  config->writeEntry("Port",prport);
  config->writeEntry("Auth",prauth);
  config->writeEntry("User",pruser);
  config->writeEntry("Password",prpass);
  config->setGroup("Sound");
  config->writeEntry("bell", beep);
  config->writeEntry("playWav", wav);
  config->writeEntry("userPlay", user);
  config->setGroup("Other");
  icq_Russian = rus;
  config->writeEntry("Koi2win",icq_Russian);
  config->writeEntry("CloseRecv",closereply);
  config->writeEntry("ConvertCRLF",crlf);
  config->writeEntry("Quote",quoteorig);
  config->writeEntry("Reconnect",recon);
  config->writeEntry("Status",cur_status);
  config->setGroup("Log");
  icq_LogLevel = loglvl;
  config->writeEntry("Level",loglvl);
  config->writeEntry("File",logfile);
  config->setGroup("Properties");
  config->writeEntry("Main", KWM::getProperties(winId()));
  config->sync();
}

void MainWindow::saveProperties()
{
  KConfig *config = kapp->getConfig();
  config->setGroup("Properties");
  config->writeEntry("Main", KWM::getProperties(winId()));
  config->writeEntry("Restored", (int)isVisible());
  config->sync();
}

void MainWindow::saveStatus()
{
  KConfig *config = kapp->getConfig();
  config->setGroup("Other");
  config->writeEntry("Status", cur_status);
  config->sync();
}

UserList *MainWindow::listWidget()
{
  return listwidget;
}

DockWidget *MainWindow::dockWidget()
{
  return dockwidget;
}

FindWindow *MainWindow::findWindow()
{
  return findwin;
}

int MainWindow::isLogged()
{
  return logged;
}

QStrList MainWindow::getUINDirList()
{
  QDir dir(contdir);
  return *dir.entryList("*.uin", QDir::Files | QDir::Readable);
}

void MainWindow::saveUser(unsigned long uin, QString nick, QString first, QString last, QString email, unsigned char auth)
{
  QString uinstr, uinfile, alias;
  uinstr.setNum(uin);
  uinfile = contdir+"/"+uinstr+".uin";
  KSimpleConfig usrcfg((const char*)uinfile);
  usrcfg.setGroup("Info");
  usrcfg.writeEntry("Nick", nick);
  usrcfg.writeEntry("FirstName", first);
  usrcfg.writeEntry("LastName", last);
  usrcfg.writeEntry("EMail", email);
  if(!nick.isEmpty() && nick!="N/A")
    alias = nick;
  else if(!first.isEmpty() && first!="N/A")
    alias = first;
  else if(!last.isEmpty() && last!="N/A")
    alias = last;
  else if(!email.isEmpty() && email!="N/A")
    alias = email;
  else
    alias.setNum(uin);
  usrcfg.writeEntry("Alias", alias);
  usrcfg.writeEntry("Auth", auth);
  usrcfg.sync();
}

void MainWindow::saveUser(ContactItem item)
{
  QString uinstr, uinfile, aboutfname, notesfname;
  uinstr.setNum(item.uin);
  uinfile = contdir+"/"+uinstr+".uin";
  KSimpleConfig usrcfg((const char*)uinfile);
  usrcfg.setGroup("Info");
  usrcfg.writeEntry("Nick", item.nick);
  usrcfg.writeEntry("Alias", item.alias);
  usrcfg.writeEntry("FirstName", item.firstName);
  usrcfg.writeEntry("LastName", item.lastName);
  usrcfg.writeEntry("EMail", item.email);
  usrcfg.writeEntry("City",item.city);
  usrcfg.writeEntry("State",item.state);
  usrcfg.writeEntry("Zip",item.zip);
  usrcfg.writeEntry("Country",item.country);
  usrcfg.writeEntry("CountryStatus",item.countryStat);
  usrcfg.writeEntry("HomePage",item.homePage);
  usrcfg.writeEntry("Age",item.age);
  usrcfg.writeEntry("Phone",item.phone);
  usrcfg.writeEntry("Gender",item.gender);
  usrcfg.writeEntry("OnlineAlert", item.onlineAlert);
  usrcfg.writeEntry("VisibleUser", item.visibleUser);
  aboutfname = contdir+"/"+uinstr+".about";
  QFile aboutfile(aboutfname);
  if(aboutfile.exists())
    unlink(aboutfname);
  aboutfile.open(IO_WriteOnly | IO_Raw);
  aboutfile.writeBlock((const char*)item.about, item.about.length());
  notesfname = contdir+"/"+uinstr+".notes";
  QFile notesfile(notesfname);
  if(notesfile.exists())
    unlink(notesfname);
  notesfile.open(IO_WriteOnly | IO_Raw);
  notesfile.writeBlock((const char*)item.notes, item.notes.length());
  usrcfg.sync();
}

void MainWindow::delInfoWin(InfoWindow *win)
{
  infoWinList.removeRef(win);
}

void MainWindow::delSendWin(MsgWindow *win)
{
  win->stopCommand();
  sendWinList.removeRef(win);
}

void MainWindow::delURLSendWin(URLSndWindow *win)
{
  win->stopCommand();
  sendURLWinList.removeRef(win);
}

void MainWindow::delRecvWin(RecvWindow *win)
{
  recvWinList.removeRef(win);
}

void MainWindow::delHistoryWin(HistoryWindow *win)
{
  historyWinList.removeRef(win) ;
}

void MainWindow::delRenWin(RenameWindow *win)
{
  renWinList.removeRef(win);
}

void MainWindow::delAlertWin(AlertMsgBox *win)
{
  alertWinList.removeRef(win);
}

void MainWindow::addAlertWin(unsigned long uin)
{
  AlertMsgBox *win = 0L, *ptr;
  QString text;
  for(ptr = alertWinList.first(); ptr != 0L; ptr = alertWinList.next())
    if(ptr->uin() == uin)
    {
      ptr->raise();
      return;
    }
  text.sprintf("User %s is online", listwidget->getItemByUIN(uin)->Name());
  win = new AlertMsgBox(uin, "Online Alert", text);
  win->show();
  alertWinList.append(win);
}

const char *MainWindow::logFile()
{
  return (const char*)logfile;
}

int MainWindow::isCloseRecv()
{
  return closeRecv;
}

int MainWindow::isConvertCRLF()
{
  return convertCRLF;
}

int MainWindow::isQuote()
{
  return quote;
}

void MainWindow::updateRecvWindows()
{
  RecvWindow *ptr;
  for(ptr = recvWinList.first() ; ptr != 0L ; ptr = recvWinList.next())
    ptr->updateNextAvailability();
}

void MainWindow::setIcon(QPixmap icon)
{
  stateIcon = icon;
  if(!blinkFlag)
  {
    KWM::setMiniIcon(winId(), stateIcon);
    dockwidget->setIcon(stateIcon);
  }
}

void MainWindow::setBlinking(int flag)
{
  blinkFlag = flag;
  if(blinkFlag)
  {
    togglePixmap(0);
  }
  else
    setIcon(stateIcon);
}

void MainWindow::togglePixmap(int num)
{
  KWM::setMiniIcon(winId(), blinkPixmap[num]);
  dockwidget->setIcon(blinkPixmap[num]);
}

QString MainWindow::contactsDir()
{
  return contdir;
}

QPopupMenu *MainWindow::stateMenu()
{
  return statemenu;
}

int MainWindow::isUnreadMsgs()
{
  unsigned int i;
  for(i=0; i<listwidget->count(); i++)
    if(listwidget->getItem(i)->type()==tpUser)
      if(listwidget->getItem(i)->getNumUnreadMsgs())
        return TRUE;
  return FALSE;
}

unsigned long MainWindow::getFirstUnreadMsgUIN()
{
  unsigned int i;
  for(i=0; i<listwidget->count(); i++)
    if(listwidget->getItem(i)->type()==tpUser)
      if(listwidget->getItem(i)->getNumUnreadMsgs())
        return listwidget->getItem(i)->UIN();
  return 0;
}

void MainWindow::updateHistoryWindows(unsigned long uin)
{
  HistoryWindow *ptr;
  for(ptr = historyWinList.first() ; ptr != 0L ; ptr = historyWinList.next())
    if(ptr->UIN() == uin)
      ptr->refresh();
}

void MainWindow::setBlinkPixmap(const char *p)
{
  KIconLoader *il = kapp->getIconLoader();
  blinkPixmap[0] = il->loadIcon(p) ;
}

void MainWindow::setToolTip()
{
  QString text;
  if(isUnreadMsgs())
  {
    unsigned long u = getFirstUnreadMsgUIN();
    if(u)
    {
      switch(listwidget->getItemByUIN(u)->getFirstUnreadMsgType())
      {
        case MSG_SENT:
        case MSG_RECV:
          text = "Message from ";
          break;
        case MSG_URL_SENT:
        case MSG_URL_RECV:
          text = "URL from ";
          break;
        default:
          text = "Event from ";
          break;
      }
      text += listwidget->getItemByUIN(u)->Name();
    }
  }
  else
  {
    switch(cur_status)
    {
      case stLogin:
        text = "Connecting";
        break;
      case stOffline:
        text = "Offline";
        break;
      case stOnline:
        text = "Online";
        break;
      case stAway:
        text = "Away";
        break;
      case stNA:
        text = "Not Available";
        break;
      case stDND:
        text = "Do not Disturb";
        break;
      case stOccupied:
        text = "Occupied";
        break;
      case stInvisible:
        text = "Invisible";
        break;
      case stFFC:
        text = "Free for Chat";
        break;
    }
  }
  dockwidget->setToolTip(text);
}

void MainWindow::updateBlinking()
{
  if(listwidget->blinkItemsCount())
    setBlinking(TRUE);
  else
    setBlinking(FALSE);
  if(isUnreadMsgs())
  {
    unsigned long u = getFirstUnreadMsgUIN();
    if(u)
      switch(listwidget->getItemByUIN(u)->getFirstUnreadMsgType())
      {
        case MSG_SENT:
        case MSG_RECV:
          setBlinkPixmap("message.xpm");
          break;
        case MSG_URL_SENT:
        case MSG_URL_RECV:
          setBlinkPixmap("url.xpm");
          break;
        default:
          setBlinkPixmap("null.xpm");
          break;
      }
  }
  setToolTip();
}
