// $Id: infomain.cpp,v 1.4 1998/12/08 16:17:47 denis Exp $
// $Log: infomain.cpp,v $
// Revision 1.4  1998/12/08 16:17:47  denis
// Cleaned up a little before releasing
//

#include "infomain.h"

#include "infomain.moc"

MainWidget::MainWidget(QWidget *parent) : QWidget(parent)
{
  uinline = new QLineEdit(this);
  uinline->setFocusPolicy(QWidget::NoFocus);
  ipline = new QLineEdit(this);
  ipline->setFocusPolicy(QWidget::NoFocus);
  nickline = new QLineEdit(this);
  nickline->setFocusPolicy(QWidget::NoFocus);
  emailline = new QLineEdit(this);
  emailline->setFocusPolicy(QWidget::NoFocus);
  firstline = new QLineEdit(this);
  firstline->setFocusPolicy(QWidget::NoFocus);
  lastline = new QLineEdit(this);
  lastline->setFocusPolicy(QWidget::NoFocus);
  uinlabel = new QLabel(uinline, "ICQ#",this);
  iplabel = new QLabel(ipline, "Current/Last IP",this);
  nicklabel = new QLabel(nickline, "Nickname",this);
  emaillabel = new QLabel(emailline, "EMail",this);
  firstlabel = new QLabel(firstline, "First Name",this);
  lastlabel = new QLabel(lastline, "Last Name",this);
}

MainWidget::~MainWidget()
{
  if(uinlabel)
    delete uinlabel;
  if(iplabel)
    delete iplabel;
  if(nicklabel)
    delete nicklabel;
  if(emaillabel)
    delete emaillabel;
  if(firstlabel)
    delete firstlabel;
  if(lastlabel)
    delete lastlabel;
  if(uinline)
    delete uinline;
  if(ipline)
    delete ipline;
  if(nickline)
    delete nickline;
  if(emailline)
    delete emailline;
  if(firstline)
    delete firstline;
  if(lastline)
    delete lastline;
}

void MainWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  int hlbl = QMAX(QMAX(QMAX(uinlabel->sizeHint().height(),iplabel->sizeHint().height()),
                       QMAX(nicklabel->sizeHint().height(),emaillabel->sizeHint().height())),
                  QMAX(firstlabel->sizeHint().height(),lastlabel->sizeHint().height()));
  int hline = QMAX(QMAX(QMAX(uinline->sizeHint().height(),ipline->sizeHint().height()),
                        QMAX(nickline->sizeHint().height(),emailline->sizeHint().height())),
                   QMAX(firstline->sizeHint().height(),lastline->sizeHint().height()));
  int w = (width()-20)/2;
  int h = (height()-2)/3;
  uinlabel->setGeometry(6,5,w,hlbl);
  uinline->setGeometry(6,5+hlbl,w,hline);
  iplabel->setGeometry(w+15,5,w,hlbl);
  ipline->setGeometry(w+15,5+hlbl,w,hline);
  nicklabel->setGeometry(6,5+h,w,hlbl);
  nickline->setGeometry(6,5+h+hlbl,w,hline);
  emaillabel->setGeometry(w+15,5+h,w,hlbl);
  emailline->setGeometry(w+15,5+h+hlbl,w,hline);
  firstlabel->setGeometry(6,5+h*2,w,hlbl);
  firstline->setGeometry(6,5+h*2+hlbl,w,hline);
  lastlabel->setGeometry(w+15,5+h*2,w,hlbl);
  lastline->setGeometry(w+15,5+h*2+hlbl,w,hline);
}

void MainWidget::setInfo(unsigned long puin, unsigned long pip, const char *pnick, const char *pemail, const char *pfirst, const char *plast)
{
  QString stmp;
  stmp.setNum(puin);
  uinline->setText((const char*)stmp);
  if(pip!=0)
    stmp.sprintf("%i.%i.%i.%i", (pip >> 24) & 0x000000ff, (pip >> 16) & 0x000000ff, (pip >> 8) & 0x000000ff, pip & 0x000000ff);
  else
    stmp = "N/A";
  ipline->setText((const char*)stmp);
  nickline->setText(strlen(pnick)==0?"Not Entered":pnick);
  emailline->setText(strlen(pemail)==0?"Not Entered":pemail);
  firstline->setText(strlen(pfirst)==0?"Not Entered":pfirst);
  lastline->setText(strlen(plast)==0?"Not Entered":plast);
}
