#ifndef _FINDWINDOW_
#define _FINDWINDOW_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktabctl.h>
#include <ktablistbox.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include "emailwidget.h"
#include "detailswidget.h"
#include "uinwidget.h"

class FindWindow : public QDialog {
  Q_OBJECT
public:
  FindWindow();
  ~FindWindow();
  static void userFound(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth);
	static void searchDone(void);
public slots:
  void addRequest();
  void infoRequest();
  void popupRequest(int, int);
  void stopCommand();
signals:
protected:
  KTabCtl *tabctl;
  EMailWidget *emailwidget;
  DetailsWidget *detailswidget;
  UINWidget *uinwidget;
  QGroupBox *btnbox;
  QPushButton *searchbtn, *stopbtn, *newbtn;
  QLabel *searchanim;
  KTabListBox *foundlist;
  QPopupMenu *popup;
	int curtab;
  void resizeEvent(QResizeEvent *);
  void addUserLine(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth);
protected slots:
  void searchCommand();
	void clearCommand();
	void changeTab(int);
private:
private slots:
};
#endif /* _FINDWINDOW_ */
