/* $Id$
   $Log$

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGPROXY_H
#define _DLGPROXY_H

#include <qgroupbox.h> 
#include <qpushbutton.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>

class DlgProxy : public QWidget
{
Q_OBJECT
  public:
    DlgProxy(QWidget *parent=0, const char *name=0, WFlags f=0);
    ~DlgProxy();

    void setData();
    void getData();
     
  private:

    QGroupBox *gb_proxy;
    
    // ftp proxy fields
    QLabel *lb_ftp_url;		// label ftp url
    QLineEdit *le_ftp_url;	// lineedit ftp url
    QLabel *lb_ftp_port;	// and so on :)
    QLineEdit *le_ftp_port;

    // http proxy fields
    QLabel *lb_http_url;
    QLineEdit *le_http_url;
    QLabel *lb_http_port;
    QLineEdit *le_http_port;  

    // "no proxy for" fields
    QLabel *lb_no_prx;
    QLineEdit *le_no_prx;

    // copy down button
    QPushButton *cp_down;
    // use proxy checker
    QCheckBox *cb_useProxy;

  public slots:
    void copyDown();		// use the http setting for all services

};

#endif // _DLGPROXY_H
