/* $Id: configdlg.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: configdlg.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.3  1998/12/19 19:38:57  matt
   Added buttongroup mode
   finally works

   Revision 1.2  1998/11/09 22:33:01  matt
   Config dialog for transfer

   Revision 1.1  1998/11/05 23:06:47  matt
   *** empty log message ***


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _CONFIGDLG_H
#define _CONFIGDLG_H

#include <qwidget.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qdialog.h>

#include "bwdatetime.h"

class KItem;
class KMainWidget;

class ConfigDlg : public QDialog
{
  Q_OBJECT

public:
  ConfigDlg(KMainWidget *_km, KItem *_item);
  ~ConfigDlg();

  friend class KItem;
  friend class KMainWidget;

protected:

  // info stuff
  QLabel *lb_from;
  QLabel *lb_source;
  QLabel *lb_to;
  QLabel *lb_dest;

  // mode stuff
  QButtonGroup *modeButtons;

  QRadioButton *rbQueued;
  QRadioButton *rbScheduled;
  QRadioButton *rbDelayed;

  // timer stuff
  QGroupBox *groupTimer;

  QDateTime qdt;
  BWDateTime *spins;
  
  QPushButton *ok;
  QPushButton *cancel;

  KItem *item;
  void setTimer();

private:
  KMainWidget *km;

public slots:
  void changeMode();

protected slots:

  virtual void done ( int r );
  
};

#endif // _CONFIGDLG_H
