#!/usr/bin/env python

####################################################################
#                                                                  #
# The installer is (C) Martin P Holland 2000                       #
# I give unlimited permission to copy, distribute and modify it.   #
# No warranty is given or implied for the installer. You use it at #
# your own risk.                                                   #
#                                                                  #
####################################################################

import sys, os, compileall, string, ConfigParser

try:
    import qt
except ImportError:
    print 'Uh oh! you do not have the python bindings for qt installed'
    sys.exit(0)
try:
    from kdecore import KApplication
except ImportError:
    print 'Uh oh! you do not have the python bindings for KDE installed'
    sys.exit(0)

p=ConfigParser.ConfigParser()
p.read("Config.in")
if "Options" not in p.sections() or "app" not in p.options("Options"):
    print """
Broken Config.in file.

It should look like this:

[Options]
APP=name_of_app_here

    """
    sys.exit(1)
app=p.get("Options","APP")
if "menudir" not in p.options("Options"):
    menudir='Applications'
else:
    menudir=p.get("Options","MENUDIR")

datadir=str(KApplication.kde_datadir())
bindir=str(KApplication.kde_bindir())
docdir=str(KApplication.kde_htmldir())
icondir=str(KApplication.kde_icondir())
lnkdir=str(KApplication.kde_appsdir())

try:
    f=open('Config','w')
except IOError,detail:
    print "Can't open Config to write",detail
    sys.exit(1)

f.write("[Options]\n")
f.write("APP="+app+"\n")
f.write("MENUDIR="+menudir+"\n")
f.write("KDEDATADIR="+datadir+"\n")
f.write("KDEBINDIR="+bindir+"\n")
f.write("KDEHTMLDIR="+docdir+"\n")
f.write("KDEICONDIR="+icondir+"\n")
f.write("KDELNKDIR="+lnkdir+"\n")

#insert custom options here


if len(sys.argv)==2:
    clidir=sys.argv[1]
else:
    clidir='/usr/local'
f.write("CLIDIR="+clidir+"\n")

f.close()
print "written Config options"
