#ifndef __STARTCONFIGPAGE_H__
#define __STARTCONFIGPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include "kintegerline.h"
#include "ircClient.h"
#include "ircApp.h"

class StartConfigPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QVBoxLayout* topLayout;
  QGridLayout* grid;
  QDict<QButtonGroup> btnGroup;
  QDict<QGroupBox>    groupBox;
  QDict<QCheckBox>    checkBox;
  QStrList            autoCheckText;
  QStrList            delayText;
  QStrList            rawText;
  QDict<KIntegerLine> intLine;
public:
  StartConfigPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~StartConfigPage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createAutoCheckBox();
  void    createDelayBox();
  void    createRawBox();
  void    createPushButton();
protected slots:
  void slotApply();
  void slotCurrentPage(const char* page);
};

#endif



