#include <iostream.h>
#include "StringToken.h"
#include "pageTab.h"
#include "pageTab.moc"
#include "outputPage.h"

#include <qfiledlg.h> 
#include <qlayout.h>

PageTab::PageTab(IrcClient* Client, QWidget* parent, const char* Name):
  QFrame(parent, Name)
{
  client  = Client;
  panner  = new KNewPanner (this,"Panner", KNewPanner::Vertical, KNewPanner::Absolute);
  panner->setSeparatorPos(95);

  page = new QDict<QWidget>(20, FALSE, TRUE);
  page->setAutoDelete (true);

  pageWidget = new QWidget  (panner,"pageWidget");
  treeList   = new KTreeList(panner,"treeList");
  treeList->raise();
  treeList->setTreeDrawing(TRUE);
  treeList->setExpandButtonDrawing(TRUE);
  treeList->setScrollBar(TRUE);

  panner->activate(treeList, pageWidget);

  connect(treeList,  
	  SIGNAL(highlighted(int)),
	  this,      
	  SLOT  (slotSetPage(int))); 

  createTreeListItem();

  show();
}

PageTab::~PageTab()
{
#ifdef EDEBUG
  cout << "Destruktor PageTab" << endl;
#endif
  delete page;
}

void PageTab::slotSetPage(int idx)
{
#ifdef EDEBUG
  cout << "PageTab::slotSetPage:"<<idx<<endl;
#endif
  
  QWidget* w;
  if ((w = page->find("PageDefault"))!=NULL )
     w->raise();
  if (treeList->count()<1)
     return;

  treeList->setCurrentItem(idx);
  KTreeListItem* item = treeList->itemAt(idx);
  if (item){
     QString s = item->getText();
     w=page->find(s);
     if (w){
        w->raise();
	emit signCurrentPage(s);
     }
  }
}

void PageTab::slotDelPage(const char* Name)
{
#ifdef EDEBUG
  cout << " PageTab::slotDelPage:"<<Name<<endl;
#endif
  OutputPage*    op;
  KTreeListItem* item;
  for (int i=0;i<(int)treeList->count();i++){
     item = treeList->itemAt(i);
     if (!stricmp(Name, item->getText())){
        treeList->removeItem(i);
	op=(OutputPage*)page->find(Name);
	if (op)
	   page->remove(Name);
	i=treeList->currentItem();
	if (i>=0)
	   slotSetPage(i);
	return;
     }
  } 
}

void PageTab::slotChangeItemName(const char* Old, const char* New)
{
#ifdef EDEBUG
  cout << "PageTab::slotChangeItemName:"<<Old<<":"<<New<<endl;
#endif
  slotDelPage(New);
  KTreeListItem* item;
  for (uint i=0;i<treeList->count();i++){
     item = treeList->itemAt(i);
     if (!stricmp(Old, item->getText())){
        QWidget* pw = page->take(Old);
	pw->setName(New);
	page->insert(New, pw);
        treeList->changeItem(New, NULL, i);
	slotSetPage(i);
	return;
     }
  } 
}

void PageTab::slotDetach(bool, const char*)
{

}

void PageTab::createTreeListItem()
{
  QVBoxLayout* vbox = new QVBoxLayout(pageWidget,0);
  QWidget* w=new QWidget(pageWidget);
  vbox->addWidget(w);
  page->insert("PageDefault", w);
}

void PageTab::resizeEvent(QResizeEvent*)
{
  panner->setGeometry (0,
		       0,
		       width(),
		       height());
  
  QDictIterator<QWidget> iw(*(page));
  QWidget* w;
  while((w=iw.current())!=0L){
    if (w->parentWidget()!=0L)
        w->setGeometry(0,
		       0,
		       pageWidget->width()- 0,
		       pageWidget->height()-0);
    ++iw;
  }
}

QWidget* PageTab::getPage(const char* Name)
{
  return page->find(Name);
}

bool PageTab::isActive()
{
#ifdef EDEBUG
  cout << "PageTab::isActive():"<<name()<<endl;
#endif
  QWidget* w=topLevelWidget();
  if (w->isActiveWindow())
     return true;

  QDictIterator<QWidget> it(*page);
  for (w=it.current();(w=it.current())!=0L;++it){
     if (w->parentWidget()==0L && w->isActiveWindow())
        return true;
  }
  return false;
}


