#include "ircPopup.h"
#include "kiconloader.h"
#include "StringToken.h"
#include "outputPage.h"
#include "outputPage.moc"
#include "ircClient.h"
#include "ircDefine.h"
#include "colorOpt.h"
#include "fontOpt.h"
#include <iostream.h>
#include <qclipbrd.h>
#include "ircApp.h"

int OutputPage::barHeight=24;

OutputPage::OutputPage(IrcClient* Client, QWidget* parent, const char* Name) :
            QWidget(parent, Name)
{
#ifdef EDEBUG
  cout << "Konstruktor OutputPage"<<endl;
#endif
  
  client   = Client;
  mdiWnd   = 0L;

  outWidget = new QWidget(this);
  topLayout = new QVBoxLayout(outWidget, 0);
  toolbar   = new KToolBar   (outWidget, "outputToolbar", 24);
  idTbCounter = 0;
  idTbDetach  = idTbCounter++;
  idTbBack    = idTbCounter++;
  idTbForward = idTbCounter++;
  idTbClear   = idTbCounter++;
  idTbLog     = idTbCounter++;

  createToolbar();
  topLayout->addWidget(toolbar);
  toolbar->setFixedHeight(barHeight);

  panner    = new KNewPanner (this, "Panner", 
			      KNewPanner::Vertical, 
			      KNewPanner::Percent);
  topLayout->addWidget(panner);
  topLayout->addSpacing(2);

  htmlMsg   = new IrcHtml (panner, Name);
  htmlMsg->installEventFilter(this);

  panWidget = new QWidget (panner);
  panner->setSeparatorPos(99);
  panner->activate(htmlMsg, panWidget);
  
  inpCmd  = new IrcLine (outWidget,"InpCmd", 25, TRUE);
  topLayout->addWidget(inpCmd);
  inpCmd->setFixedHeight(25);

  connect(client,
	  SIGNAL(signWriteOnActive(int , const char*, bool)),
	  SLOT  (slotWriteOnActive(int , const char*, bool)));
  connect(this,
	  SIGNAL(signSetFlag(int, bool)),
	  htmlMsg,
	  SLOT  (slotSetFlag(int, bool)));
  connect(toolbar,
	  SIGNAL(moved(BarPosition)),
	  this,
	  SLOT  (slotToolbarMoved()));

  // new keirc-0.2
  connect((ColorOpt*)client->optPrefDlg->getPage("Color"),
	  SIGNAL(colorsChanged(const QColor&, int)),
	  htmlMsg,
	  SLOT  (slotSetColor (const QColor&, int))
	  );  

  connect((FontOpt*)client->optPrefDlg->getPage("Font"),
	  SIGNAL(signFontSize(int , int)),
	  htmlMsg,
	  SLOT  (slotSetFontSize(int, int))
	  );
  connect((FontOpt*)client->optPrefDlg->getPage("Font"),
	  SIGNAL(signFontName(const char*, int)),
	  htmlMsg,
	  SLOT  (slotSetFontName(const char*, int))
	  );

  createPopup();
  topLayout->activate();
  initAll();
}

OutputPage::~OutputPage()
{
#ifdef EDEBUG
  cout << "Destruktor OutputPage" << endl;
#endif;
  delete toolbar;
}

void OutputPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("Input")))
     popup = client->popup.find("Default");

  if (popup){
     connect(inpCmd,
	     SIGNAL(signMouseRightPress(const QPoint&)),
	     this,
	     SLOT  (slotInputPopup(const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotInputPopupAction(const char*)));
  }
}

void OutputPage::createToolbar()
{
  // pixmap which we will use
  QPixmap pix;
  
  // We get iconloader from KApplication
  KIconLoader* loader = ircapp->getIconLoader();

  // and set it to full width
  toolbar->setFullWidth(TRUE);

  pix = loader->loadIcon("back.xpm");
  toolbar->insertButton(pix, idTbBack, SIGNAL(clicked()), this, SLOT(slotBack()), TRUE, "Previous document");

  pix = loader->loadIcon("forward.xpm");
  toolbar->insertButton(pix, idTbForward, SIGNAL(clicked()), this, SLOT(slotForward()), TRUE, "Next document");

  toolbar->insertSeparator();
  pix = loader->loadIcon("irclog.xpm");
  toolbar->insertButton(pix, idTbLog, TRUE, "Log/Don't log");
  toolbar->setToggle(idTbLog);
  toolbar->addConnection (idTbLog, SIGNAL(toggled(bool)), this, SLOT(slotToggleLog(bool)));

  pix = loader->loadIcon("clear.xpm");
  toolbar->insertButton(pix, idTbClear, SIGNAL(clicked()), this, SLOT(slotHtmlClear()), TRUE, "Clear document");

  toolbar->insertSeparator();

  toolbar->enableMoving  (FALSE);
  toolbar->setBarPos(KToolBar::Top);
  toolbar->updateRects(TRUE);

}

void OutputPage::initAll()
{
  QString  cfgString;
  bool     setLog;
  cfgString = ircapp->readEntry("SetLog", "No");
  if (cfgString.find( "No", 0, false ) == 0)
     setLog=false;
  else
     setLog = true;
  if (setLog)
     toolbar->toggleButton(idTbLog);

  emit signSetFlag(FLAG_LOG, setLog);

  if (parentWidget()==0L)
     toolbar->toggleButton(idTbDetach);

}

void OutputPage::slotInputPopup(const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"OutputPage::slotInputPopup:"<<endl;
#endif
  IrcPopup* popup = client->popup.find("Input");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  } 
}

void OutputPage::slotInputPopupAction(const char*)
{
}

void OutputPage::slotBack()
{
  ircHtml()->slotBackward();
}

void OutputPage::slotForward()
{
  ircHtml()->slotForward();
}

void OutputPage::slotEditCopy()
{
  QString text;

  ircHtml()->htmlWidget()->getSelectedText(text);
  if (text.isEmpty())
     return;
  QClipboard *cb = kapp->clipboard();
  cb->setText(text);
}


void OutputPage::slotToggleLog(bool state)
{
  ircapp->writeEntry( "SetLog",   state ? "Yes" : "No" );
  emit signSetFlag(FLAG_LOG, state);
}

void OutputPage::slotToggleDetach(bool state)
{
  emit signDetach(state, name());
}


void OutputPage::slotHtmlClear()
{
  emit signSetFlag(FLAG_CLEAR, TRUE);
}

void OutputPage::slotWriteOnActive(int Type, const char* txt, bool Filter)
{
  if (IsSelected()==1 && isActiveWindow()==true){
     ircHtml()->slotWrite(Type, txt, Filter);
  }
}

void OutputPage::slotToolbarMoved()
{
#ifdef EDEBUG
  cout << "OutputPage::slotToolbarMoved()" << endl;
#endif
  toolbar->setMaxWidth(width());
  toolbar->updateRects(true);
}

void OutputPage::resizeEvent(QResizeEvent*)
{
  outWidget->setGeometry(0,
			 0,
			 width(),
			 height());
		       	 
  toolbar->setMaxWidth(width());
  toolbar->updateRects(true);
}

bool OutputPage::eventFilter ( QObject *, QEvent *e )
{
  if (e->type() == Event_MouseButtonPress)
     mousePressEvent( (QMouseEvent *)e );

  return false;
}

void OutputPage::mousePressEvent ( QMouseEvent *e)
{
  if (e->button() == LeftButton)
     inpCmd->setFocus();
}

IrcHtml* OutputPage::ircHtml()
{
  return htmlMsg;
}

IrcLine* OutputPage::ircLine()
{
  return inpCmd;
}

void OutputPage::setMDIWindow(MDIWindow* w)
{
  mdiWnd = w;
  connect(w,   SIGNAL(closed  (MDIWindow*)),
	  this,SLOT  (slotExit(MDIWindow*)));
  connect(w,   SIGNAL(selected(MDIWindow*)),
	  this,SLOT  (slotSelected(MDIWindow*)));
	  
}

void OutputPage::slotExit(MDIWindow*)
{
}

// -----------------------------------
// Window Page
// -----------------------------------

WindowPage::WindowPage(IrcClient* Client, QWidget* parent, const char* Name) :
  OutputPage(Client, parent, Name)
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("Default")))
     return;

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotPopupAction(const char*)));
  }
}

WindowPage::~WindowPage()
{

}
  
void WindowPage::slotPopup(const char*, const QPoint& pos)
{
  IrcPopup* popup = client->popup.find("Default");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void WindowPage::slotPopupAction(const char* Action)
{
  if ( IsSelected()==true && isActiveWindow()==true)
     client->slotInputParse(Action);

  return;
}

void WindowPage::slotExit(MDIWindow*)
{
} 


void WindowPage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

