#ifndef __ONDCCFILEPAGE_H__
#define __ONDCCFILEPAGE_H__

#include <qfiledlg.h>
#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h>
#include "fileListBox.h" 
#include "kintegerline.h"
#include "ircClient.h"
#include <kconfig.h>

class OnDCCFilePage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QVBoxLayout* topLayout;
  QGridLayout* grid;
  QDict<QButtonGroup> btnGroup;
  QDict<QRadioButton> radioBtn;
  QDict<QCheckBox>    checkBox;
  QStrList            actionText;
  QDict<QGroupBox>    groupBox;
  QStrList            configText;
  QStrList            checkText;
  QDict<KIntegerLine> intLine;
  QLineEdit*          pathEdit;
  FileDirBox*         dirBox;
  QComboBox*          blockCombo;
public:
  OnDCCFilePage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~OnDCCFilePage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createActionRadioBtn();
  void    createConfigBox();
  void    createOnClosed();
  void    createPushButton();
protected slots:
  void slotApply();
  void slotSelect();
  void slotCurrentPage(const char* page){
      if (!stricmp(page, name()))
	 readConfig();
  } 
};

#endif
