#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "ircBell.h"
#include "onBrowserPage.h"
#include "onBrowserPage.moc"
#include "ircApp.h"

void OnBrowserPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnBrowserPage::OnBrowserPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createRadioBtn();
  createConfigBox();
  createPushButton();
  topLayout->activate();
  readConfig();
  show();
}

OnBrowserPage::~OnBrowserPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnBrowserPage" << endl;
#endif
}


void OnBrowserPage::createRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Browser", bg=new QButtonGroup("Browser", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("KFM"));
  radioBtn.insert(entry, rb = new QRadioButton("KFM", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  rb->setEnabled(false);
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Netscape"));
  radioBtn.insert(entry, rb = new QRadioButton("Netscape", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  rb->setEnabled(true);
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("KEirc"));
  radioBtn.insert(entry, rb = new QRadioButton("KEirc", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  rb->setEnabled(false);
  vbox->addWidget(rb);
  vbox->addSpacing(bg->fontMetrics().height());
  //bg->setFixedWidth(bg->sizeHint().width());
  vbox->activate();
}

void OnBrowserPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("OnKEirc", gb=new QGroupBox("On KEirc", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());

  vbox->addStretch(10);
  vbox->activate();
}

void OnBrowserPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnBrowserPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnBrowserPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;
  
  entry = "OnBrowser";
  value = ircapp->readEntry(entry, "Netscape");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
}

void OnBrowserPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnBrowserPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnBrowser";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }
}








