#ifndef __LINEDIALOG_H__
#define __LINEDIALOG_H__

#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qlayout.h>
#include "ircLine.h"

class LineDialog : public QDialog
{
  Q_OBJECT
protected:
  QString        mTitle;;
  QList<IrcLine> eWidget;
  QList<QLabel>  lWidget;
public:
  LineDialog(QWidget *parent=NULL, const char *name=NULL, bool Modal=TRUE, const char* topic=NULL);
  ~LineDialog();
  void    setText(QStrList& label, QStrList& edit);
  void    setText(QString  label, QString  edit, QString delim=";");
  QString getText(int idx, bool stripWhiteSpace=false);

};

class SingleDialog : public LineDialog
{
public:
  SingleDialog(const char* Label, const char* Edit=0L,  const char* topic=0L, 
	       QWidget *parent=0L, const char *name=0L, bool Modal=TRUE) :
       LineDialog(parent, name, Modal, topic)
  {
    setText(QString(QString(Label)+";"), QString(QString(Edit)+";"));
  }

  ~SingleDialog(){}
  QString getText(bool strip=FALSE)
  {
    return LineDialog::getText(0, strip);
  }

};

#endif

