#ifndef __FONTOPT_H__
#define __FONTOPT_H__

#include <qcombo.h>
#include <qgrpbox.h>
#include <qstring.h>
#include <qstrlist.h>
#include <kconfig.h>

class FontOpt : public QWidget
{
  Q_OBJECT

public:
  FontOpt( QWidget *parent = NULL, const char *name = NULL );
  ~FontOpt();
public slots:
  void    slotTextFSize  (const char* s);             
  void    slotMsgFSize   (const char* s);   
  void    slotInfoFSize  (const char* s);   
  void    slotActionFSize(const char* s);   
  void    slotErrorFSize (const char* s);   
  void    slotTextFName  (const char* n); 
  void    slotMsgFName   (const char* n);  
  void    slotInfoFName  (const char* n); 
  void    slotActionFName(const char* n); 
  void    slotErrorFName (const char* n); 

signals:
  void    signFontSize( int, int );
  void    signFontName( const char*, int);

private:
  void    readOptions();
  void    getFontList( QStrList &list, const char *pattern );
  void    addFont    ( QStrList &list, const char *xfont );    
private:
  int      textFSize;
  int      msgFSize;
  int      infoFSize;
  int      actionFSize;
  int      errorFSize;
  QString  textFName;
  QString  msgFName;
  QString  infoFName;
  QString  actionFName;
  QString  errorFName;
  QStrList textFonts;
  QStrList msgFonts;
  QStrList infoFonts;
  QStrList actionFonts;
  QStrList errorFonts;
};    

#endif


