#include <iostream.h>
#include "ircView.h"
#include "dccView.h"
#include "dccView.moc"

DCCView::DCCView(IrcClient* client, QWidget* parent, const char* name ) : 
             QFrame(parent, name)
{
   this->client = client;
   setFrameStyle(QFrame::Panel | QFrame::Sunken);
   setLineWidth (2);
   tabCtl           = new KTabCtl(this);
   tab.setAutoDelete(FALSE);
   wid.setAutoDelete(FALSE);

   QWidget* w;
   wid.insert("DCCChatTab", w = new QWidget(tabCtl));
   tab.insert("DCCChatTab", dccChatTab  = new DCCChatTab(client, w));
   tabCtl->addTab(w,  "DCC Chat");

   wid.insert("DCCFileTab", w = new QWidget(tabCtl));
   tab.insert("DCCFileTab", dccFileTab  = new DCCFileTab(client, w));
   tabCtl->addTab(w,  "DCC File");

   show();
}

DCCView::~DCCView()
{
#ifdef EDEBUG
  cout << "Destruktor DCCView" << endl;
#endif
}

void DCCView::closeEvent (QCloseEvent *)
{
}

void DCCView::resizeEvent(QResizeEvent*)
{
  tabCtl->resize   (width(),height());
    
  dccChatTab->setGeometry  (0, 
			    0, 
			    wid["DCCChatTab"]->width()-0, 
			    wid["DCCChatTab"]->height()-0);

  dccFileTab->setGeometry  (0, 
			    0, 
			    wid["DCCFileTab"]->width()-0, 
			    wid["DCCFileTab"]->height()-0);

}

QWidget* DCCView::getTab(const char* Name)
{
  return tab.find(Name);
}


bool DCCView::isActive()
{
  PageTab* pt;
  QDictIterator<QWidget> it(tab);
  for (;(pt=(PageTab*)it.current())!=0L;++it){
     if (pt->isActive())
        return true;
  }
  return false;
}









