#ifndef  __DCCCLIENT_H__
#define  __DCCCLIENT_H__

#include <qlist.h>
#include <qstrlist.h>
#include <qdict.h>
#include <qsocknot.h>
#include "clientCore.h"
#include "ircPopup.h"
#include "ClientSocket.h"
#include "ServerSocket.h"
#include "ircServer.h"
#include "ircUser.h"

class IrcClient;

class DCCClient : public ClientCore
{
  Q_OBJECT
public:
  DCCClient (const char* User, QObject* Parent, const char* Name=NULL);
  ~DCCClient();
  virtual QString cmdSubstitution(const char* Txt);
  int  changeNick  (const char*);
public:
  IrcServer*        host;
protected:
  int type;          // DCC_INCOMING, DCC_OUTGOING
  IrcClient*  client;
public:
  int               state;
  ClientSocket*     socket;
  ServerSocket      server;
  QSocketNotifier*  sn;
  IrcUser*          user;
private:
  void Init();
public slots:
  void slotConnect (IrcCore*);
  virtual void slotServe   (IrcCore*);
  virtual void slotCusTimeout(IrcCore*);
  virtual void slotAccept  (ClientSocket* cs);
  virtual void slotConnected();
  virtual void slotDisconnected();
  virtual void slotMsgParse(int);
signals:
  void signConnect();
  void signServe  (); 
  void signConnected();
  void signDisconnected();
};

#endif





